/*
 * Decompiled with CFR 0.152.
 */
package nu.validator.encoding;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CoderResult;
import nu.validator.encoding.Decoder;
import nu.validator.encoding.Encoding;

public class InfallibleSingleByteDecoder
extends Decoder {
    protected final char[] upperHalf;

    protected InfallibleSingleByteDecoder(Encoding cs, char[] upperHalf) {
        super(cs, 1.0f, 1.0f);
        this.upperHalf = upperHalf;
    }

    protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
        while (in.hasRemaining()) {
            if (!out.hasRemaining()) {
                return CoderResult.OVERFLOW;
            }
            byte b = in.get();
            if (b >= 0) {
                out.put((char)b);
                continue;
            }
            out.put(this.upperHalf[b + 128]);
        }
        return CoderResult.UNDERFLOW;
    }
}

