/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.db;

import java.io.File;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.spi.DeploymentManager;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.j2ee.deployment.devmodules.api.J2eeModule;
import org.netbeans.modules.j2ee.deployment.devmodules.spi.J2eeModuleProvider;
import org.netbeans.modules.payara.eecommon.api.DomainEditor;
import org.netbeans.modules.payara.jakartaee.Hk2DeploymentManager;
import org.netbeans.modules.payara.spi.PayaraModule;
import org.netbeans.modules.payara.tooling.PayaraIdeException;
import org.netbeans.modules.payara.tooling.admin.CommandCreateJDBCConnectionPool;
import org.netbeans.modules.payara.tooling.admin.CommandCreateJDBCResource;
import org.netbeans.modules.payara.tooling.data.PayaraServer;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class ResourcesHelper {
    private static final Logger LOG = Logger.getLogger("payara-jakartaee");
    private static RequestProcessor RP = new RequestProcessor("Sample Datasource work");

    public static void addSampleDatasource(final J2eeModule module, final DeploymentManager dmParam) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                File f = module.getResourceDirectory();
                if (null != f && f.exists()) {
                    f = f.getParentFile();
                }
                if (null != f) {
                    Project p = FileOwnerQuery.getOwner((URI)Utilities.toURI((File)f));
                    if (null != p) {
                        PayaraModule commonSupport;
                        String gfdir;
                        DeploymentManager dm;
                        J2eeModuleProvider jmp = ResourcesHelper.getProvider(p);
                        if (null != jmp && (dm = dmParam) instanceof Hk2DeploymentManager && null != (gfdir = (String)(commonSupport = ((Hk2DeploymentManager)dm).getCommonServerSupport()).getInstanceProperties().get("domainsfolder"))) {
                            String domain = (String)commonSupport.getInstanceProperties().get("domainname");
                            if (commonSupport.getServerState() != PayaraModule.ServerState.RUNNING) {
                                DomainEditor de = new DomainEditor(gfdir, domain);
                                de.createSampleDatasource();
                            } else {
                                ResourcesHelper.registerSampleResource(commonSupport);
                            }
                        }
                    } else {
                        LOG.finer("Could not find project for J2eeModule");
                    }
                } else {
                    LOG.finer("Could not find project root directory for J2eeModule");
                }
            }
        });
    }

    private static J2eeModuleProvider getProvider(Project project) {
        J2eeModuleProvider provider = null;
        if (project != null) {
            Lookup lookup = project.getLookup();
            provider = (J2eeModuleProvider)lookup.lookup(J2eeModuleProvider.class);
        }
        return provider;
    }

    private static void registerSampleResource(PayaraModule commonSupport) {
        String sample_poolname = "H2Pool";
        String sample_jdbc = "jdbc/__default";
        String sample_classname = "org.h2.jdbcx.JdbcDataSource";
        String sample_restype = "javax.sql.DataSource";
        HashMap<String, String> sample_props = new HashMap<String, String>();
        sample_props.put("URL", "jdbc:h2:${com.sun.aas.instanceRoot}/lib/databases/embedded_default;AUTO_SERVER=TRUE");
        Map jdbcsMap = commonSupport.getResourcesMap("jdbc-resource");
        if (!jdbcsMap.containsKey(sample_jdbc)) {
            try {
                CommandCreateJDBCConnectionPool.createJDBCConnectionPool((PayaraServer)commonSupport.getInstance(), (String)sample_poolname, (String)sample_classname, (String)sample_restype, sample_props, (long)60000L);
                CommandCreateJDBCResource.createJDBCResource((PayaraServer)commonSupport.getInstance(), (String)sample_poolname, (String)sample_jdbc, null, null, (long)60000L);
            }
            catch (PayaraIdeException ex) {
                LOG.log(Level.SEVERE, ex.getLocalizedMessage(), ex);
            }
        }
    }
}

