/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.navigation;

import java.awt.Dimension;
import java.awt.Image;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import org.netbeans.modules.web.jsf.navigation.PageFlowView;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

public class PageFlowToolbarUtilities {
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.web.jsf.navigation");
    private static Map<Scope, String> scope2String = new EnumMap<Scope, String>(Scope.class);
    private static Map<String, Scope> string2Scope = new HashMap<String, Scope>();
    private static final String TT_SCOPE = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"TT_Scope_DropDown");
    private static final String LBL_SCOPE_FACESCONFIG = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"LBL_Scope_FacesConfig");
    private static final String LBL_SCOPE_PROJECT = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"LBL_Scope_Project");
    private static final String LBL_SCOPE_ALL_PROJECT = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"LBL_Scope_All_FacesConfig");
    private static final String TT_LAYOUTPAGES = NbBundle.getMessage(PageFlowToolbarUtilities.class, (String)"TT_LayoutPages");
    private Scope currentScope = Scope.SCOPE_PROJECT;
    private static PageFlowToolbarUtilities instance;
    private static final Map<PageFlowView, PageFlowToolbarUtilities> map;
    private JComboBox scopeBox;
    private static final Image LAYOUT_ICON;
    private JButton layoutButton = null;
    private Reference<PageFlowView> pageFlowViewRef;

    public static final String getScopeLabel(Scope scope) {
        return scope2String.get((Object)scope);
    }

    public static final Scope getScope(String scopeStr) {
        return string2Scope.get(scopeStr);
    }

    private PageFlowToolbarUtilities(PageFlowView view) {
        this.setPageFlowView(view);
    }

    protected static boolean removePageFlowView(PageFlowView view) {
        if (map.containsKey((Object)view)) {
            map.remove((Object)view);
            return true;
        }
        return false;
    }

    public static PageFlowToolbarUtilities getInstance(PageFlowView view) {
        PageFlowToolbarUtilities myInstance = map.get((Object)view);
        if (myInstance == null) {
            myInstance = new PageFlowToolbarUtilities(view);
            map.put(view, myInstance);
        }
        return myInstance;
    }

    public static Set<PageFlowView> getViews() {
        return map.keySet();
    }

    public Scope getCurrentScope() {
        return this.currentScope;
    }

    public void setCurrentScope(Scope scope) {
        this.currentScope = scope;
        if (this.scopeBox != null && !this.scopeBox.getSelectedItem().equals(PageFlowToolbarUtilities.getScopeLabel(this.currentScope))) {
            this.scopeBox.setSelectedItem(PageFlowToolbarUtilities.getScopeLabel(this.currentScope));
        }
    }

    public JComboBox createScopeComboBox() {
        JComboBox<String> comboBox = new JComboBox<String>();
        comboBox.addItem(PageFlowToolbarUtilities.getScopeLabel(Scope.SCOPE_FACESCONFIG));
        comboBox.addItem(PageFlowToolbarUtilities.getScopeLabel(Scope.SCOPE_PROJECT));
        comboBox.addItem(PageFlowToolbarUtilities.getScopeLabel(Scope.SCOPE_ALL_FACESCONFIG));
        Dimension prefSize = comboBox.getPreferredSize();
        comboBox.setMinimumSize(prefSize);
        comboBox.setMaximumSize(prefSize);
        comboBox.setSelectedItem(PageFlowToolbarUtilities.getScopeLabel(this.currentScope));
        comboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent event) {
                PageFlowView view = PageFlowToolbarUtilities.this.getPageFlowView();
                if (event.getStateChange() == 1) {
                    String newScope = (String)event.getItem();
                    view.saveLocations();
                    LogRecord record = new LogRecord(Level.FINE, "PageFLowEditor Scope Changed To:" + newScope);
                    record.setSourceClassName("PageFlowUtilities.ItemListener");
                    record.setSourceMethodName("itemStateChanged");
                    record.setParameters(new Object[]{newScope, new Date()});
                    LOGGER.log(record);
                    PageFlowToolbarUtilities.this.setCurrentScope(PageFlowToolbarUtilities.getScope(newScope));
                    view.getPageFlowController().setupGraphNoSaveData();
                }
                view.requestMultiViewActive();
            }
        });
        comboBox.setToolTipText(TT_SCOPE);
        this.scopeBox = comboBox;
        return comboBox;
    }

    public JButton createLayoutButton() {
        if (this.layoutButton != null) {
            return this.layoutButton;
        }
        this.layoutButton = new JButton(new ImageIcon(LAYOUT_ICON));
        this.layoutButton.setToolTipText(TT_LAYOUTPAGES);
        this.layoutButton.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                PageFlowToolbarUtilities.this.getPageFlowView().layoutNodes();
                PageFlowToolbarUtilities.this.getPageFlowView().requestMultiViewActive();
            }
        });
        return this.layoutButton;
    }

    public final PageFlowView getPageFlowView() {
        return this.pageFlowViewRef.get();
    }

    public void setPageFlowView(PageFlowView view) {
        this.pageFlowViewRef = new WeakReference<PageFlowView>(view);
    }

    static {
        scope2String.put(Scope.SCOPE_FACESCONFIG, LBL_SCOPE_FACESCONFIG);
        scope2String.put(Scope.SCOPE_PROJECT, LBL_SCOPE_PROJECT);
        scope2String.put(Scope.SCOPE_ALL_FACESCONFIG, LBL_SCOPE_ALL_PROJECT);
        string2Scope.put(LBL_SCOPE_FACESCONFIG, Scope.SCOPE_FACESCONFIG);
        string2Scope.put(LBL_SCOPE_PROJECT, Scope.SCOPE_PROJECT);
        string2Scope.put(LBL_SCOPE_ALL_PROJECT, Scope.SCOPE_ALL_FACESCONFIG);
        map = new WeakHashMap<PageFlowView, PageFlowToolbarUtilities>();
        LAYOUT_ICON = ImageUtilities.loadImage((String)"org/netbeans/modules/web/jsf/navigation/resources/navigation.gif");
    }

    public static enum Scope {
        SCOPE_FACESCONFIG,
        SCOPE_PROJECT,
        SCOPE_ALL_FACESCONFIG;

    }
}

