/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.gradle.java.classpath;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.gradle.api.NbGradleProject;
import org.netbeans.modules.gradle.java.api.GradleJavaProject;
import org.netbeans.modules.gradle.java.api.GradleJavaSourceSet;
import org.netbeans.modules.gradle.java.classpath.AnnotationProcessorPathImpl;
import org.netbeans.modules.gradle.java.classpath.BootClassPathImpl;
import org.netbeans.modules.gradle.java.classpath.Bundle;
import org.netbeans.modules.gradle.java.classpath.CompileClassPathImpl;
import org.netbeans.modules.gradle.java.classpath.RuntimeClassPathImpl;
import org.netbeans.modules.gradle.java.classpath.SourceClassPathImpl;
import org.netbeans.modules.java.api.common.classpath.ClassPathSupportFactory;
import org.netbeans.spi.java.classpath.ClassPathFactory;
import org.netbeans.spi.java.classpath.ClassPathImplementation;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class ClassPathProviderImpl
extends ProjectOpenedHook
implements ClassPathProvider {
    public static final String MODULE_INFO_JAVA = "module-info.java";
    private static final Set<String> SUPPORTED_PATHS = new HashSet<String>(Arrays.asList("classpath/source", "classpath/boot", "classpath/compile", "classpath/execute", "classpath/processor", "modules/boot", "modules/compile", "modules/classpath", "modules/execute", "modules/execute-classpath"));
    private final Project project;
    private final PropertyChangeListener pcl;
    private final PropertyChangeListener wPcl;
    private volatile Map<String, SourceSetCP> groups = new HashMap<String, SourceSetCP>();
    private boolean lateProjectLoadAttempted;

    public ClassPathProviderImpl(Project project) {
        this.project = project;
        this.pcl = evt -> {
            if ("ProjectInfo".equals(evt.getPropertyName())) {
                this.updateGroups();
            }
            if ("resources".equals(evt.getPropertyName())) {
                URI uri = (URI)evt.getNewValue();
                this.updateResources(uri);
            }
        };
        NbGradleProject gp = NbGradleProject.get((Project)project);
        this.wPcl = WeakListeners.propertyChange((PropertyChangeListener)this.pcl, null, (Object)gp);
        if (gp.isGradleProjectLoaded()) {
            this.updateGroups();
        }
        gp.addPropertyChangeListener(this.wPcl);
    }

    private void updateResources(URI uri) {
        GradleJavaProject gjp;
        if (uri != null && uri.getPath() != null && uri.getPath().endsWith(MODULE_INFO_JAVA) && (gjp = GradleJavaProject.get(this.project)) != null) {
            GradleJavaSourceSet ss = gjp.containingSourceSet(Utilities.toFile((URI)uri));
            if (ss == null) {
                return;
            }
            SourceSetCP ssp = this.groups.get(ss.getName());
            if (ssp != null) {
                ssp.reset();
            }
        }
    }

    private void updateGroups() {
        GradleJavaProject p = GradleJavaProject.get(this.project);
        if (p != null) {
            this.updateGroups(p.getSourceSets().keySet());
        } else {
            this.updateGroups(Collections.emptySet());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClassPath findClassPath(FileObject fo, String type) {
        GradleJavaSourceSet sourceSet;
        GradleJavaProject prj = GradleJavaProject.get(this.project);
        if (!SUPPORTED_PATHS.contains(type) || prj == null) {
            return null;
        }
        NbGradleProject ngp = NbGradleProject.get((Project)this.project);
        if (ngp != null) {
            boolean attempt;
            if (ngp.getQuality().worseThan(NbGradleProject.Quality.EVALUATED)) {
                ClassPathProviderImpl classPathProviderImpl = this;
                synchronized (classPathProviderImpl) {
                    attempt = !this.lateProjectLoadAttempted;
                    this.lateProjectLoadAttempted = true;
                }
            } else {
                attempt = false;
            }
            if (attempt) {
                ngp.toQuality(Bundle.MSG_ObtainClasspath(), NbGradleProject.Quality.FULL, false).thenAccept(p -> {
                    if (p.getQuality().atLeast(NbGradleProject.Quality.EVALUATED)) {
                        this.updateGroups();
                    }
                });
            }
        }
        return (sourceSet = prj.containingSourceSet(FileUtil.toFile((FileObject)fo))) != null ? this.getSourceSetPath(type, sourceSet) : null;
    }

    private ClassPath getSourceSetPath(String type, GradleJavaSourceSet sourceSet) {
        SourceSetCP scp = this.groups.get(sourceSet.getName());
        return scp != null ? scp.getClassPath(type) : null;
    }

    protected void projectOpened() {
        GradleJavaProject p = GradleJavaProject.get(this.project);
        if (p != null) {
            this.updateGroups(p.getSourceSets().keySet());
        }
    }

    protected void projectClosed() {
        NbGradleProject.removePropertyChangeListener((Project)this.project, (PropertyChangeListener)this.pcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateGroups(Set<String> newGroups) {
        ClassPathProviderImpl classPathProviderImpl = this;
        synchronized (classPathProviderImpl) {
            HashMap<String, SourceSetCP> g = new HashMap<String, SourceSetCP>(this.groups);
            Iterator it = g.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry oldGroup = it.next();
                if (newGroups.contains(oldGroup.getKey())) continue;
                it.remove();
            }
            for (String newGroup : newGroups) {
                if (g.containsKey(newGroup)) continue;
                SourceSetCP scp = new SourceSetCP(newGroup);
                g.put(newGroup, scp);
            }
            this.groups = g;
        }
    }

    private class SourceSetCP {
        ClassPath boot;
        ClassPath source;
        ClassPath compile;
        ClassPath runtime;
        ClassPath platformModules;
        ClassPath compileTime;
        ClassPath runTime;
        ClassPath annotationProcessor;
        ClassPath moduleBoot;
        ClassPath moduleCompile;
        ClassPath moduleAnnotationProcessor;
        ClassPath moduleLegacy;
        ClassPath moduleExecute;
        ClassPath moduleLegacyRuntime;
        final String group;
        final List<SourceSetAwareSelector> selectors = new ArrayList<SourceSetAwareSelector>();

        SourceSetCP(String group) {
            this.group = group;
        }

        public ClassPath getClassPath(String type) {
            switch (type) {
                case "classpath/boot": {
                    return this.getBootClassPath();
                }
                case "classpath/source": {
                    return this.getSourcepath();
                }
                case "classpath/compile": {
                    return this.getCompileTimeClasspath();
                }
                case "classpath/execute": {
                    return this.getRuntimeClassPath();
                }
                case "modules/boot": {
                    return this.getModuleBoothPath();
                }
                case "modules/compile": {
                    return this.getModuleCompilePath();
                }
                case "modules/classpath": {
                    return this.getModuleLegacyClassPath();
                }
                case "modules/execute": {
                    return this.getModuleExecutePath();
                }
                case "modules/execute-classpath": {
                    return this.getModuleLegacyRuntimeClassPath();
                }
                case "classpath/processor": {
                    return this.getJava8AnnotationProcessorPath();
                }
            }
            return null;
        }

        private synchronized ClassPath getCompileTimeClasspath() {
            if (this.compileTime == null) {
                this.compileTime = this.createMultiplexClassPath(ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createModuleInfoBasedPath((ClassPath)this.getModuleCompilePath(), (ClassPath)this.getSourcepath(), (ClassPath)this.getModuleBoothPath(), (ClassPath)this.getModuleCompilePath(), (ClassPath)this.getJava8CompileClassPath(), null)), this.getJava8CompileClassPath());
            }
            return this.compileTime;
        }

        private synchronized ClassPath getRuntimeClassPath() {
            if (this.runTime == null) {
                this.runTime = this.createMultiplexClassPath(ClassPathFactory.createClassPath((ClassPathImplementation)ClassPathSupportFactory.createModuleInfoBasedPath((ClassPath)this.getJava8RuntimeClassPath(), (ClassPath)this.getSourcepath(), (ClassPath)this.getModuleBoothPath(), (ClassPath)this.getJava8RuntimeClassPath(), (ClassPath)this.getJava8RuntimeClassPath(), null)), this.getJava8RuntimeClassPath());
            }
            return this.runTime;
        }

        private synchronized ClassPath getModuleLegacyClassPath() {
            if (this.moduleLegacy == null) {
                this.moduleLegacy = this.createMultiplexClassPath(ClassPath.EMPTY, this.getJava8CompileClassPath());
            }
            return this.moduleLegacy;
        }

        private synchronized ClassPath getModuleExecutePath() {
            if (this.moduleExecute == null) {
                this.moduleExecute = this.createMultiplexClassPath(this.getJava8RuntimeClassPath(), ClassPath.EMPTY);
            }
            return this.moduleExecute;
        }

        private synchronized ClassPath getModuleLegacyRuntimeClassPath() {
            if (this.moduleLegacyRuntime == null) {
                this.moduleLegacyRuntime = this.createMultiplexClassPath(ClassPath.EMPTY, this.getJava8RuntimeClassPath());
            }
            return this.moduleLegacyRuntime;
        }

        private synchronized ClassPath getBootClassPath() {
            if (this.boot == null) {
                this.boot = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImpl(ClassPathProviderImpl.this.project, false));
            }
            return this.boot;
        }

        private synchronized ClassPath getSourcepath() {
            if (this.source == null) {
                this.source = ClassPathFactory.createClassPath((ClassPathImplementation)new SourceClassPathImpl(ClassPathProviderImpl.this.project, this.group));
            }
            return this.source;
        }

        private synchronized ClassPath getJava8CompileClassPath() {
            if (this.compile == null) {
                this.compile = ClassPathFactory.createClassPath((ClassPathImplementation)new CompileClassPathImpl(ClassPathProviderImpl.this.project, this.group));
            }
            return this.compile;
        }

        private synchronized ClassPath getJava8AnnotationProcessorPath() {
            if (this.annotationProcessor == null) {
                this.annotationProcessor = ClassPathFactory.createClassPath((ClassPathImplementation)new AnnotationProcessorPathImpl(ClassPathProviderImpl.this.project, this.group));
            }
            return this.annotationProcessor;
        }

        private synchronized ClassPath getPlatformModulesPath() {
            if (this.platformModules == null) {
                this.platformModules = ClassPathFactory.createClassPath((ClassPathImplementation)new BootClassPathImpl(ClassPathProviderImpl.this.project, true));
            }
            return this.platformModules;
        }

        private synchronized ClassPath getJava8RuntimeClassPath() {
            if (this.runtime == null) {
                this.runtime = ClassPathFactory.createClassPath((ClassPathImplementation)new RuntimeClassPathImpl(ClassPathProviderImpl.this.project, this.group));
            }
            return this.runtime;
        }

        private synchronized ClassPath getModuleBoothPath() {
            if (this.moduleBoot == null) {
                this.moduleBoot = this.createMultiplexClassPath(this.getPlatformModulesPath(), this.getBootClassPath());
            }
            return this.moduleBoot;
        }

        private synchronized ClassPath getModuleCompilePath() {
            if (this.moduleCompile == null) {
                this.moduleCompile = this.createMultiplexClassPath(this.getJava8CompileClassPath(), this.getJava8CompileClassPath());
            }
            return this.moduleCompile;
        }

        private ClassPath createMultiplexClassPath(ClassPath modulePath, ClassPath classPath) {
            SourceSetAwareSelector selector = new SourceSetAwareSelector(modulePath, classPath);
            this.selectors.add(selector);
            return ClassPathSupport.createMultiplexClassPath((ClassPathSupport.Selector)selector);
        }

        public boolean hasModuleInfo() {
            GradleJavaProject gjp = GradleJavaProject.get(ClassPathProviderImpl.this.project);
            GradleJavaSourceSet ss = gjp != null ? gjp.getSourceSets().get(this.group) : null;
            return ss != null && ss.findResource(ClassPathProviderImpl.MODULE_INFO_JAVA, false, GradleJavaSourceSet.SourceType.JAVA) != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            ArrayList<SourceSetAwareSelector> copy;
            SourceSetCP sourceSetCP = this;
            synchronized (sourceSetCP) {
                copy = new ArrayList<SourceSetAwareSelector>(this.selectors);
            }
            for (SourceSetAwareSelector selector : copy) {
                selector.reset();
            }
        }

        private class SourceSetAwareSelector
        implements ClassPathSupport.Selector {
            PropertyChangeSupport support = new PropertyChangeSupport(this);
            final ClassPath modulePath;
            final ClassPath classPath;
            ClassPath active;

            public SourceSetAwareSelector(ClassPath modulePath, ClassPath classPath) {
                this.modulePath = modulePath;
                this.classPath = classPath;
            }

            public ClassPath getActiveClassPath() {
                if (this.active == null) {
                    this.active = SourceSetCP.this.hasModuleInfo() ? this.modulePath : this.classPath;
                }
                return this.active;
            }

            public void addPropertyChangeListener(PropertyChangeListener listener) {
                this.support.addPropertyChangeListener(listener);
            }

            public void removePropertyChangeListener(PropertyChangeListener listener) {
                this.support.removePropertyChangeListener(listener);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void reset() {
                SourceSetAwareSelector sourceSetAwareSelector = this;
                synchronized (sourceSetAwareSelector) {
                    ClassPath oldActive = this.active;
                    ClassPath classPath = this.active = SourceSetCP.this.hasModuleInfo() ? this.modulePath : this.classPath;
                    if (oldActive == this.active) {
                        return;
                    }
                }
                this.support.firePropertyChange("activeClassPath", null, null);
            }
        }
    }
}

