/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.glassfish.tooling.utils;

import java.io.File;
import java.util.LinkedList;

public class OsUtils {
    public static final String LINES_SEPARATOR = System.getProperty("line.separator");
    public static final int FILE_SEPARATOR_LENGTH = File.separator.length();
    public static final String OS_NAME_PROPERTY = "os.name";
    public static final String OS_NAME = System.getProperty("os.name");
    public static final String OS_NAME_UPCASE = OS_NAME != null ? OS_NAME.toUpperCase() : OS_NAME;
    private static final String OS_WIN_SUBSTR = "WINDOWS";
    private static final boolean IS_WIN = OS_NAME != null ? OS_NAME_UPCASE.contains("WINDOWS") : false;
    public static final String EXEC_SUFFIX = IS_WIN ? ".exe" : "";

    public static boolean isWin() {
        return IS_WIN;
    }

    public static String[] parseParameters(String exec, String args) {
        int NULL = 0;
        int INPARAM = 1;
        int INPARAMPENDING = 2;
        int STICK = 4;
        int STICKPENDING = 8;
        LinkedList<String> params = new LinkedList<String>();
        params.add(exec);
        int state = NULL;
        StringBuilder buff = new StringBuilder(20);
        int slength = args.length();
        for (int i = 0; i < slength; ++i) {
            char c = args.charAt(i);
            if (Character.isWhitespace(c)) {
                if (state == NULL) {
                    if (buff.length() <= 0) continue;
                    params.add(buff.toString());
                    buff.setLength(0);
                    continue;
                }
                if (state == STICK) {
                    params.add(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\\');
                    params.add(buff.toString());
                    buff.setLength(0);
                    state = NULL;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    state = INPARAM;
                    buff.append('\\');
                    buff.append(c);
                    continue;
                }
                buff.append(c);
                continue;
            }
            if (c == '\\') {
                if (state == NULL) {
                    if (++i < slength) {
                        char cc = args.charAt(i);
                        if (cc == '\"' || cc == '\\') {
                            buff.append(cc);
                            continue;
                        }
                        if (Character.isWhitespace(cc)) {
                            buff.append(c);
                            --i;
                            continue;
                        }
                        buff.append(c);
                        buff.append(cc);
                        continue;
                    }
                    buff.append('\\');
                    break;
                }
                if (state == INPARAM) {
                    state = INPARAMPENDING;
                    continue;
                }
                if (state == INPARAMPENDING) {
                    buff.append('\\');
                    state = INPARAM;
                    continue;
                }
                if (state == STICK) {
                    state = STICKPENDING;
                    continue;
                }
                if (state != STICKPENDING) continue;
                buff.append('\\');
                state = STICK;
                continue;
            }
            if (c == '\"') {
                if (state == NULL) {
                    state = INPARAM;
                    continue;
                }
                if (state == INPARAM) {
                    state = STICK;
                    continue;
                }
                if (state == STICK) {
                    state = INPARAM;
                    continue;
                }
                if (state == STICKPENDING) {
                    buff.append('\"');
                    state = STICK;
                    continue;
                }
                buff.append('\"');
                state = INPARAM;
                continue;
            }
            if (state == INPARAMPENDING) {
                buff.append('\\');
                state = INPARAM;
            } else if (state == STICKPENDING) {
                buff.append('\\');
                state = STICK;
            }
            buff.append(c);
        }
        if (state == INPARAM) {
            params.add(buff.toString());
        } else if ((state & (INPARAMPENDING | STICKPENDING)) != 0) {
            buff.append('\\');
            params.add(buff.toString());
        } else if (buff.length() != 0) {
            params.add(buff.toString());
        }
        String[] retArgs = new String[params.size()];
        int i = 0;
        for (String param : params) {
            retArgs[i++] = param;
        }
        return retArgs;
    }

    public static String escapeParameters(String[] params) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < params.length; ++i) {
            OsUtils.escapeString(params[i], sb);
            sb.append(' ');
        }
        int len = sb.length();
        if (len > 0) {
            sb.setLength(len - 1);
        }
        return sb.toString().trim();
    }

    public static void escapeString(String s, StringBuffer sb) {
        if (s.length() == 0) {
            sb.append("\"\"");
            return;
        }
        boolean hasSpace = false;
        int sz = sb.length();
        int slen = s.length();
        for (int i = 0; i < slen; ++i) {
            char c = s.charAt(i);
            if (Character.isWhitespace(c)) {
                hasSpace = true;
                sb.append(c);
                continue;
            }
            if (c == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (c == '\"') {
                sb.append('\\').append('\"');
                continue;
            }
            sb.append(c);
        }
        if (hasSpace) {
            sb.insert(sz, '\"');
            sb.append('\"');
        }
    }

    public static String escapeString(String s) {
        int sLen;
        int tLen = sLen = s.length();
        boolean quote = sLen == 0;
        block6: for (int i = 0; i < sLen; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    ++tLen;
                    continue block6;
                }
                default: {
                    if (!Character.isWhitespace(c)) continue block6;
                    quote = true;
                }
            }
        }
        if (quote) {
            tLen += 2;
        }
        StringBuilder sb = new StringBuilder(tLen);
        if (quote) {
            sb.append('\"');
        }
        for (int i = 0; i < sLen; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    sb.append('\\');
                }
            }
            sb.append(c);
        }
        if (quote) {
            sb.append('\"');
        }
        return sb.toString();
    }

    public static boolean rmDirContent(File target) {
        boolean result = true;
        if (target != null) {
            File[] content;
            for (File file : content = target.listFiles()) {
                if (file.canWrite()) {
                    if (file.isDirectory() && !".".equals(file.getName()) && !"..".equals(file.getName())) {
                        result = result && OsUtils.rmDirContent(file);
                    }
                    result = result && file.delete();
                    continue;
                }
                result = false;
            }
        }
        return result;
    }

    public static boolean rmDir(File target) {
        boolean result = OsUtils.rmDirContent(target);
        return result && target.delete();
    }

    public static String joinPaths(String e1, String e2) {
        int l1 = e1 != null ? e1.length() : 0;
        int l2 = e2 != null ? e2.length() : 0;
        boolean separator = l1 > 0 && !e1.endsWith(File.separator);
        StringBuilder sb = new StringBuilder(l1 + l2 + (separator ? FILE_SEPARATOR_LENGTH : 0));
        if (l1 > 0) {
            sb.append(e1);
        }
        if (separator) {
            sb.append(File.separator);
        }
        if (l2 > 0) {
            sb.append(e2);
        }
        return sb.toString();
    }
}

