/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.saas.codegen.java;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.websvc.saas.codegen.Constants;
import org.netbeans.modules.websvc.saas.codegen.SaasClientAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.SaasClientCodeGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.SaasClientJavaAuthenticationGenerator;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaSourceHelper;
import org.netbeans.modules.websvc.saas.codegen.java.support.JavaUtil;
import org.netbeans.modules.websvc.saas.codegen.java.support.SourceGroupSupport;
import org.netbeans.modules.websvc.saas.codegen.model.CustomClientSaasBean;
import org.netbeans.modules.websvc.saas.codegen.model.ParameterInfo;
import org.netbeans.modules.websvc.saas.codegen.model.SaasBean;
import org.netbeans.modules.websvc.saas.codegen.util.Util;
import org.netbeans.modules.websvc.saas.model.CustomSaasMethod;
import org.netbeans.modules.websvc.saas.model.SaasMethod;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;

public class CustomClientPojoCodeGenerator
extends SaasClientCodeGenerator {
    public static final String VAR_NAMES_RESULT_DECL = "RestResponse result";
    private JavaSource targetSource;
    private FileObject serviceFolder;
    private SaasClientJavaAuthenticationGenerator authGen;

    public CustomClientPojoCodeGenerator() {
        this.setDropFileType(Constants.DropFileType.JAVA_CLIENT);
    }

    public boolean canAccept(SaasMethod method, Document doc) {
        return SaasBean.canAccept((SaasMethod)method, CustomSaasMethod.class, (Constants.DropFileType)this.getDropFileType()) && Util.isJava((Document)doc);
    }

    public void init(SaasMethod m, Document doc) throws IOException {
        this.init(m, new CustomClientSaasBean((CustomSaasMethod)m, false), doc);
    }

    protected void preGenerate() throws IOException {
        this.createRestConnectionFile(this.getProject());
        if (this.getBean().getMethod().getSaas().getLibraryJars().size() > 0) {
            JavaUtil.addClientJars((SaasBean)this.getBean(), this.getProject(), null);
        }
        this.getTargetFolder().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

            public void run() throws IOException {
                Map templates = CustomClientPojoCodeGenerator.this.getBean().getArtifactTemplates(Constants.DropFileType.RESOURCE.prefix());
                for (Map.Entry e : templates.entrySet()) {
                    String id = (String)e.getKey();
                    String template = (String)e.getValue();
                    Util.createDataObjectFromTemplate((String)template, (FileObject)CustomClientPojoCodeGenerator.this.getSaasServiceFolder(), (String)id);
                }
            }
        });
    }

    public void init(SaasMethod m, CustomClientSaasBean saasBean, Document doc) throws IOException {
        super.init(m, doc);
        this.setBean((SaasBean)saasBean);
        this.targetSource = JavaSource.forFileObject((FileObject)this.getTargetFile());
        String packageName = JavaSourceHelper.getPackageName(this.getTargetSource());
        this.getBean().setPackageName(packageName);
        this.serviceFolder = null;
        this.authGen = new SaasClientJavaAuthenticationGenerator((SaasBean)this.getBean(), this.getProject());
        this.authGen.setLoginArguments(this.getLoginArguments());
        this.authGen.setAuthenticatorMethodParameters(this.getAuthenticatorMethodParameters());
        this.authGen.setSaasServiceFolder(this.getSaasServiceFolder());
        this.getBean();
        this.authGen.setAuthenticationProfile(CustomClientSaasBean.getProfile((SaasMethod)m, (Constants.DropFileType)this.getDropFileType()));
        this.authGen.setDropFileType(this.getDropFileType());
    }

    public CustomClientSaasBean getBean() {
        return (CustomClientSaasBean)super.getBean();
    }

    public SaasClientAuthenticationGenerator getAuthenticationGenerator() {
        return this.authGen;
    }

    protected JavaSource getTargetSource() {
        return this.targetSource;
    }

    public FileObject getSaasServiceFolder() throws IOException {
        if (this.serviceFolder == null) {
            SourceGroup[] srcGrps = SourceGroupSupport.getJavaSourceGroups(this.getProject());
            this.serviceFolder = SourceGroupSupport.getFolderForPackage(srcGrps[0], this.getBean().getSaasServicePackageName(), true);
        }
        return this.serviceFolder;
    }

    public Set<FileObject> generate() throws IOException {
        this.preGenerate();
        this.getAuthenticationGenerator().createAuthenticatorClass();
        this.getAuthenticationGenerator().createAuthorizationClasses();
        this.getAuthenticationGenerator().modifyAuthenticationClass();
        this.setJaxbWrapper();
        this.insertSaasServiceAccessCode(this.isInBlock(this.getTargetDocument()));
        this.addImportsToTargetFile();
        this.finishProgressReporting();
        return new HashSet<FileObject>(Collections.emptyList());
    }

    private void setJaxbWrapper() {
    }

    protected String getCustomMethodBody() throws IOException {
        String paramUse = "";
        String paramDecl = "";
        String indent = "        ";
        String indent2 = "             ";
        List<ParameterInfo> params = this.getServiceMethodParameters();
        this.clearVariablePatterns();
        this.updateVariableNames(params);
        List renamedParams = this.renameParameterNames(params);
        paramUse = paramUse + Util.getHeaderOrParameterUsage((List)renamedParams);
        paramDecl = paramDecl + this.getHeaderOrParameterDeclaration(renamedParams);
        String methodBody = "\n" + indent + "try {\n";
        methodBody = methodBody + paramDecl + "\n";
        methodBody = methodBody + indent2 + "RestResponse" + " " + this.getResultPattern() + " = " + this.getBean().getSaasServiceName() + "." + this.getBean().getSaasServiceMethodName() + "(" + paramUse + ");\n";
        methodBody = methodBody + Util.createPrintStatement((List)this.getBean().getOutputWrapperPackageNames(), (List)this.getBean().getOutputWrapperNames(), (Constants.DropFileType)this.getDropFileType(), (Constants.HttpMethodType)this.getBean().getHttpMethod(), (boolean)this.getBean().canGenerateJAXBUnmarshaller(), (String)this.getResultPattern(), (String)indent2);
        methodBody = methodBody + indent + "} catch (Exception ex) {\n";
        methodBody = methodBody + indent2 + "ex.printStackTrace();\n";
        methodBody = methodBody + indent + "}\n";
        return methodBody;
    }

    protected void insertSaasServiceAccessCode(boolean isInBlock) throws IOException {
        try {
            String code = "";
            if (isInBlock) {
                code = this.getCustomMethodBody();
            } else {
                code = "\nprivate String call" + this.getBean().getName() + "Service() {\n";
                code = code + this.getCustomMethodBody() + "\n";
                code = code + "return " + this.getResultPattern() + ";\n";
                code = code + "}\n";
            }
            this.insert(code, true);
        }
        catch (BadLocationException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    protected void addImportsToTargetFile() throws IOException {
        ArrayList<String> imports = new ArrayList<String>();
        imports.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getSaasServiceName());
        if (this.getBean().getAuthenticationType() != Constants.SaasAuthenticationType.PLAIN) {
            imports.add(this.getBean().getSaasServicePackageName() + "." + this.getBean().getAuthenticatorClassName());
        }
        imports.add("org.netbeans.saas.RestResponse");
        JavaUtil.addImportsToSource(this.getTargetSource(), imports);
    }

    protected List<ParameterInfo> getServiceMethodParameters() {
        List params = this.getBean().filterParametersByAuth(this.getBean().filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED}));
        Constants.HttpMethodType httpMethod = this.getBean().getHttpMethod();
        if (httpMethod == Constants.HttpMethodType.PUT || httpMethod == Constants.HttpMethodType.POST) {
            ParameterInfo contentTypeParam = Util.findParameter((List)this.getBean().getInputParameters(), (String)"Content-Type");
            Class contentType = InputStream.class;
            if (contentTypeParam == null) {
                params.add(new ParameterInfo("Content-Type", String.class));
            } else if (!contentTypeParam.isFixed() && !params.contains(contentTypeParam)) {
                params.add(contentTypeParam);
            } else {
                String value = Util.findParamValue((ParameterInfo)contentTypeParam);
                if (value.equals("text/plain") || value.equals("application/xml") || value.equals("text/xml")) {
                    contentType = String.class;
                }
            }
            params.add(new ParameterInfo("content", contentType));
        }
        return params;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> params, String indent) {
        if (indent == null) {
            indent = " ";
        }
        String paramDecl = "";
        for (ParameterInfo param : params) {
            String name = this.getVariableName(param.getName());
            String paramVal = Util.findParamValue((ParameterInfo)param);
            if (param.getType() != String.class) {
                paramDecl = paramDecl + indent + param.getType().getName() + " " + name + " = " + paramVal + ";\n";
                continue;
            }
            if (paramVal != null) {
                paramDecl = paramDecl + indent + "String " + name + " = \"" + paramVal + "\";\n";
                continue;
            }
            paramDecl = paramDecl + indent + "String " + name + " = null;\n";
        }
        return paramDecl;
    }

    protected String getHeaderOrParameterDeclaration(List<ParameterInfo> params) {
        String indent = "                 ";
        return this.getHeaderOrParameterDeclaration(params, indent);
    }

    public static List<ParameterInfo> getAuthenticatorMethodParametersForWeb() {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        params.add(new ParameterInfo("request", Object.class, "HttpServletRequest"));
        params.add(new ParameterInfo("response", Object.class, "HttpServletResponse"));
        return params;
    }

    public static List<ParameterInfo> getServiceMethodParametersForWeb(CustomClientSaasBean bean) {
        ArrayList<ParameterInfo> params = new ArrayList<ParameterInfo>();
        params.addAll(CustomClientPojoCodeGenerator.getAuthenticatorMethodParametersForWeb());
        params.addAll(bean.filterParametersByAuth(bean.filterParameters(new ParameterInfo.ParamFilter[]{ParameterInfo.ParamFilter.FIXED})));
        return params;
    }

    protected List<ParameterInfo> getAuthenticatorMethodParameters() {
        return Collections.emptyList();
    }

    protected String getLoginArguments() {
        return "";
    }

    protected void createRestConnectionFile(Project project) throws IOException {
        SourceGroup[] srcGrps = SourceGroupSupport.getJavaSourceGroups(project);
        String pkg = "org.netbeans.saas";
        FileObject targetFolder = SourceGroupSupport.getFolderForPackage(srcGrps[0], pkg, true);
        JavaSourceHelper.createJavaSource("Templates/SaaSServices/RestConnection.java", targetFolder, pkg, "RestConnection");
        String restResponseTemplate = "Templates/SaaSServices/RestResponse.java";
        JavaSource restResponseJS = JavaSourceHelper.createJavaSource(restResponseTemplate, targetFolder, pkg, "RestResponse");
    }
}

