/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.i18n;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.modules.i18n.I18nSupport;
import org.netbeans.modules.i18n.I18nUtil;
import org.netbeans.modules.i18n.Util;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.MapFormat;

public class I18nString {
    protected I18nSupport support;
    protected String key;
    protected String value;
    protected String comment;
    protected String replaceFormat;

    protected I18nString(I18nSupport support) {
        if (support == null) {
            throw new NullPointerException();
        }
        this.support = support;
        this.replaceFormat = I18nUtil.getOptions().getReplaceJavaCode();
    }

    protected I18nString(I18nString copy) {
        this.key = copy.key;
        this.value = copy.value;
        this.comment = copy.comment;
        this.replaceFormat = copy.replaceFormat;
        this.support = copy.support;
    }

    public void become(I18nString copy) {
        this.key = copy.key;
        this.value = copy.value;
        this.comment = copy.comment;
        this.replaceFormat = copy.replaceFormat;
        this.support = copy.support;
    }

    public Object clone() {
        return new I18nString(this);
    }

    public I18nSupport getSupport() {
        return this.support;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        if (Objects.equals(this.key, key)) {
            return;
        }
        this.key = key;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        if (Objects.equals(this.value, value)) {
            return;
        }
        this.value = value;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        if (Objects.equals(this.comment, comment)) {
            return;
        }
        this.comment = comment;
    }

    public String getReplaceFormat() {
        return this.replaceFormat;
    }

    public void setReplaceFormat(String replaceFormat) {
        this.replaceFormat = replaceFormat;
    }

    public String getReplaceString() {
        if (this.getKey() == null || this.getSupport() == null) {
            return null;
        }
        if (this.replaceFormat == null) {
            this.replaceFormat = I18nUtil.getOptions().getReplaceJavaCode();
        }
        DataObject sourceDataObject = this.getSupport().getSourceDataObject();
        HashMap<String, String> map = new HashMap<String, String>(4);
        if (this.getSupport().getResourceHolder().getResource() != null) {
            FileObject fo = this.getSupport().getResourceHolder().getResource().getPrimaryFile();
            ClassPath cp = Util.getExecClassPath(sourceDataObject.getPrimaryFile(), fo);
            if (cp == null) {
                return null;
            }
            map.put("bundleNameSlashes", Util.getResourceName(sourceDataObject.getPrimaryFile(), fo, '/', false));
            map.put("bundleNameDots", Util.getResourceName(sourceDataObject.getPrimaryFile(), fo, '.', false));
        }
        map.put("key", this.getKey());
        map.put("sourceFileName", sourceDataObject == null ? "" : sourceDataObject.getPrimaryFile().getName());
        this.fillFormatMap(map);
        String res = null;
        try {
            res = MapFormat.format((String)this.replaceFormat, map);
        }
        catch (IllegalArgumentException ilae) {
            return null;
        }
        return res;
    }

    protected void fillFormatMap(Map<String, String> subst) {
    }
}

