/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.jakarta.web.beans.analysis.analyzer.type;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.AnnotationUtil;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ClassModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.analysis.analyzer.ModelAnalyzer;
import org.netbeans.modules.jakarta.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.jakarta.web.beans.hints.EditorAnnotationsHelper;
import org.netbeans.spi.editor.hints.Severity;
import org.openide.util.NbBundle;

public class ManagedBeansAnalizer
implements ClassModelAnalyzer.ClassAnalyzer {
    private static final String EXTENSION = "jakarta.enterprise.inject.spi.Extension";

    @Override
    public void analyze(TypeElement element, TypeElement parent, WebBeansModel model, AtomicBoolean cancel, ModelAnalyzer.Result result) {
        boolean cdiManaged;
        boolean bl = cdiManaged = model.getQualifiers(element, true).size() > 0;
        if (!cdiManaged) {
            return;
        }
        result.requireCdiEnabled(element, model);
        if (cancel.get()) {
            return;
        }
        this.checkCtor(element, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkInner(element, parent, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkAbstract(element, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkImplementsExtension(element, model, result);
        if (cancel.get()) {
            return;
        }
        this.checkDecorators(element, model, result);
    }

    private void checkDecorators(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        Collection<TypeElement> decorators = model.getDecorators(element);
        if (decorators != null && decorators.size() > 0) {
            EditorAnnotationsHelper helper = EditorAnnotationsHelper.getInstance(result);
            ElementHandle handle = ElementHandle.create((Element)element);
            if (helper != null) {
                helper.addDecoratedBean(result, (TypeElement)handle.resolve(result.getInfo()));
            }
        }
    }

    private void checkImplementsExtension(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        TypeElement extension = model.getCompilationController().getElements().getTypeElement(EXTENSION);
        if (extension == null) {
            return;
        }
        TypeMirror elementType = element.asType();
        if (model.getCompilationController().getTypes().isSubtype(elementType, extension.asType())) {
            result.addNotification(Severity.WARNING, (Element)element, model, NbBundle.getMessage(ManagedBeansAnalizer.class, (String)"WARN_QualifiedElementExtension"));
        }
    }

    private void checkAbstract(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        Set<Modifier> modifiers = element.getModifiers();
        if (modifiers.contains((Object)Modifier.ABSTRACT)) {
            if (AnnotationUtil.hasAnnotation(element, "jakarta.decorator.Decorator", (CompilationInfo)model.getCompilationController())) {
                return;
            }
            result.addNotification(Severity.WARNING, (Element)element, model, NbBundle.getMessage(ManagedBeansAnalizer.class, (String)"WARN_QualifierAbstractClass"));
        }
    }

    private void checkInner(TypeElement element, TypeElement parent, WebBeansModel model, ModelAnalyzer.Result result) {
        if (parent == null) {
            return;
        }
        Set<Modifier> modifiers = element.getModifiers();
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            result.addError((Element)element, model, NbBundle.getMessage(ManagedBeansAnalizer.class, (String)"ERR_NonStaticInnerType"));
        }
    }

    private void checkCtor(TypeElement element, WebBeansModel model, ModelAnalyzer.Result result) {
        List<ExecutableElement> ctors = ElementFilter.constructorsIn(element.getEnclosedElements());
        for (ExecutableElement ctor : ctors) {
            Set<Modifier> modifiers = ctor.getModifiers();
            if (modifiers.contains((Object)Modifier.PRIVATE)) continue;
            List<? extends VariableElement> parameters = ctor.getParameters();
            if (parameters.size() == 0) {
                return;
            }
            if (!AnnotationUtil.hasAnnotation(ctor, "jakarta.inject.Inject", (CompilationInfo)model.getCompilationController())) continue;
            return;
        }
        result.addNotification(Severity.WARNING, (Element)element, model, NbBundle.getMessage(ManagedBeansAnalizer.class, (String)"WARN_QualifierNoCtorClass"));
    }
}

