/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.devops.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.devops.model.DeployStage;
import com.oracle.bmc.devops.model.DeployStagePredecessorCollection;
import com.oracle.bmc.devops.model.DeployStageSummary;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="deployStageType")
@JsonFilter(value="explicitlySetFilter")
public final class FunctionDeployStageSummary
extends DeployStageSummary {
    @JsonProperty(value="functionDeployEnvironmentId")
    private final String functionDeployEnvironmentId;
    @JsonProperty(value="dockerImageDeployArtifactId")
    private final String dockerImageDeployArtifactId;
    @JsonProperty(value="config")
    private final Map<String, String> config;
    @JsonProperty(value="maxMemoryInMBs")
    private final Long maxMemoryInMBs;
    @JsonProperty(value="functionTimeoutInSeconds")
    private final Integer functionTimeoutInSeconds;

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    @Deprecated
    public FunctionDeployStageSummary(String id, String description, String displayName, String projectId, String deployPipelineId, String compartmentId, Date timeCreated, Date timeUpdated, DeployStage.LifecycleState lifecycleState, String lifecycleDetails, DeployStagePredecessorCollection deployStagePredecessorCollection, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String functionDeployEnvironmentId, String dockerImageDeployArtifactId, Map<String, String> config, Long maxMemoryInMBs, Integer functionTimeoutInSeconds) {
        super(id, description, displayName, projectId, deployPipelineId, compartmentId, timeCreated, timeUpdated, lifecycleState, lifecycleDetails, deployStagePredecessorCollection, freeformTags, definedTags, systemTags);
        this.functionDeployEnvironmentId = functionDeployEnvironmentId;
        this.dockerImageDeployArtifactId = dockerImageDeployArtifactId;
        this.config = config;
        this.maxMemoryInMBs = maxMemoryInMBs;
        this.functionTimeoutInSeconds = functionTimeoutInSeconds;
    }

    public String getFunctionDeployEnvironmentId() {
        return this.functionDeployEnvironmentId;
    }

    public String getDockerImageDeployArtifactId() {
        return this.dockerImageDeployArtifactId;
    }

    public Map<String, String> getConfig() {
        return this.config;
    }

    public Long getMaxMemoryInMBs() {
        return this.maxMemoryInMBs;
    }

    public Integer getFunctionTimeoutInSeconds() {
        return this.functionTimeoutInSeconds;
    }

    @Override
    public String toString() {
        return this.toString(true);
    }

    @Override
    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("FunctionDeployStageSummary(");
        sb.append("super=").append(super.toString(includeByteArrayContents));
        sb.append(", functionDeployEnvironmentId=").append(String.valueOf(this.functionDeployEnvironmentId));
        sb.append(", dockerImageDeployArtifactId=").append(String.valueOf(this.dockerImageDeployArtifactId));
        sb.append(", config=").append(String.valueOf(this.config));
        sb.append(", maxMemoryInMBs=").append(String.valueOf(this.maxMemoryInMBs));
        sb.append(", functionTimeoutInSeconds=").append(String.valueOf(this.functionTimeoutInSeconds));
        sb.append(")");
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof FunctionDeployStageSummary)) {
            return false;
        }
        FunctionDeployStageSummary other = (FunctionDeployStageSummary)((Object)o);
        return Objects.equals(this.functionDeployEnvironmentId, other.functionDeployEnvironmentId) && Objects.equals(this.dockerImageDeployArtifactId, other.dockerImageDeployArtifactId) && Objects.equals(this.config, other.config) && Objects.equals(this.maxMemoryInMBs, other.maxMemoryInMBs) && Objects.equals(this.functionTimeoutInSeconds, other.functionTimeoutInSeconds) && super.equals((Object)other);
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.functionDeployEnvironmentId == null ? 43 : this.functionDeployEnvironmentId.hashCode());
        result = result * 59 + (this.dockerImageDeployArtifactId == null ? 43 : this.dockerImageDeployArtifactId.hashCode());
        result = result * 59 + (this.config == null ? 43 : this.config.hashCode());
        result = result * 59 + (this.maxMemoryInMBs == null ? 43 : this.maxMemoryInMBs.hashCode());
        result = result * 59 + (this.functionTimeoutInSeconds == null ? 43 : this.functionTimeoutInSeconds.hashCode());
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="description")
        private String description;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="projectId")
        private String projectId;
        @JsonProperty(value="deployPipelineId")
        private String deployPipelineId;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="timeUpdated")
        private Date timeUpdated;
        @JsonProperty(value="lifecycleState")
        private DeployStage.LifecycleState lifecycleState;
        @JsonProperty(value="lifecycleDetails")
        private String lifecycleDetails;
        @JsonProperty(value="deployStagePredecessorCollection")
        private DeployStagePredecessorCollection deployStagePredecessorCollection;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="functionDeployEnvironmentId")
        private String functionDeployEnvironmentId;
        @JsonProperty(value="dockerImageDeployArtifactId")
        private String dockerImageDeployArtifactId;
        @JsonProperty(value="config")
        private Map<String, String> config;
        @JsonProperty(value="maxMemoryInMBs")
        private Long maxMemoryInMBs;
        @JsonProperty(value="functionTimeoutInSeconds")
        private Integer functionTimeoutInSeconds;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.__explicitlySet__.add("description");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder projectId(String projectId) {
            this.projectId = projectId;
            this.__explicitlySet__.add("projectId");
            return this;
        }

        public Builder deployPipelineId(String deployPipelineId) {
            this.deployPipelineId = deployPipelineId;
            this.__explicitlySet__.add("deployPipelineId");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder timeUpdated(Date timeUpdated) {
            this.timeUpdated = timeUpdated;
            this.__explicitlySet__.add("timeUpdated");
            return this;
        }

        public Builder lifecycleState(DeployStage.LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder lifecycleDetails(String lifecycleDetails) {
            this.lifecycleDetails = lifecycleDetails;
            this.__explicitlySet__.add("lifecycleDetails");
            return this;
        }

        public Builder deployStagePredecessorCollection(DeployStagePredecessorCollection deployStagePredecessorCollection) {
            this.deployStagePredecessorCollection = deployStagePredecessorCollection;
            this.__explicitlySet__.add("deployStagePredecessorCollection");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder functionDeployEnvironmentId(String functionDeployEnvironmentId) {
            this.functionDeployEnvironmentId = functionDeployEnvironmentId;
            this.__explicitlySet__.add("functionDeployEnvironmentId");
            return this;
        }

        public Builder dockerImageDeployArtifactId(String dockerImageDeployArtifactId) {
            this.dockerImageDeployArtifactId = dockerImageDeployArtifactId;
            this.__explicitlySet__.add("dockerImageDeployArtifactId");
            return this;
        }

        public Builder config(Map<String, String> config) {
            this.config = config;
            this.__explicitlySet__.add("config");
            return this;
        }

        public Builder maxMemoryInMBs(Long maxMemoryInMBs) {
            this.maxMemoryInMBs = maxMemoryInMBs;
            this.__explicitlySet__.add("maxMemoryInMBs");
            return this;
        }

        public Builder functionTimeoutInSeconds(Integer functionTimeoutInSeconds) {
            this.functionTimeoutInSeconds = functionTimeoutInSeconds;
            this.__explicitlySet__.add("functionTimeoutInSeconds");
            return this;
        }

        public FunctionDeployStageSummary build() {
            FunctionDeployStageSummary model = new FunctionDeployStageSummary(this.id, this.description, this.displayName, this.projectId, this.deployPipelineId, this.compartmentId, this.timeCreated, this.timeUpdated, this.lifecycleState, this.lifecycleDetails, this.deployStagePredecessorCollection, this.freeformTags, this.definedTags, this.systemTags, this.functionDeployEnvironmentId, this.dockerImageDeployArtifactId, this.config, this.maxMemoryInMBs, this.functionTimeoutInSeconds);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(FunctionDeployStageSummary model) {
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("description")) {
                this.description(model.getDescription());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("projectId")) {
                this.projectId(model.getProjectId());
            }
            if (model.wasPropertyExplicitlySet("deployPipelineId")) {
                this.deployPipelineId(model.getDeployPipelineId());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("timeUpdated")) {
                this.timeUpdated(model.getTimeUpdated());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("lifecycleDetails")) {
                this.lifecycleDetails(model.getLifecycleDetails());
            }
            if (model.wasPropertyExplicitlySet("deployStagePredecessorCollection")) {
                this.deployStagePredecessorCollection(model.getDeployStagePredecessorCollection());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("functionDeployEnvironmentId")) {
                this.functionDeployEnvironmentId(model.getFunctionDeployEnvironmentId());
            }
            if (model.wasPropertyExplicitlySet("dockerImageDeployArtifactId")) {
                this.dockerImageDeployArtifactId(model.getDockerImageDeployArtifactId());
            }
            if (model.wasPropertyExplicitlySet("config")) {
                this.config(model.getConfig());
            }
            if (model.wasPropertyExplicitlySet("maxMemoryInMBs")) {
                this.maxMemoryInMBs(model.getMaxMemoryInMBs());
            }
            if (model.wasPropertyExplicitlySet("functionTimeoutInSeconds")) {
                this.functionTimeoutInSeconds(model.getFunctionTimeoutInSeconds());
            }
            return this;
        }
    }
}

