/*
 * Decompiled with CFR 0.152.
 */
package jdk.jshell.execution;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;

class DemultiplexInput
extends Thread {
    private final DataInputStream delegate;
    private final Map<String, OutputStream> io;
    private final Iterable<OutputStream> closeList;

    DemultiplexInput(InputStream input, Map<String, OutputStream> io, Iterable<OutputStream> closeList) {
        super("output reader");
        this.setDaemon(true);
        this.delegate = new DataInputStream(input);
        this.io = io;
        this.closeList = closeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int nameLen;
            while ((nameLen = this.delegate.read()) != -1) {
                byte[] name = new byte[nameLen];
                this.delegate.readFully(name);
                int dataLen = this.delegate.read();
                byte[] data = new byte[dataLen];
                this.delegate.readFully(data);
                String chan = new String(name, "UTF-8");
                OutputStream out = this.io.get(chan);
                if (out == null) {
                    this.debug("Unexpected channel name: %s", chan);
                    continue;
                }
                out.write(data);
            }
        }
        catch (IOException ex) {
            this.debug(ex, "Failed reading output");
        }
        finally {
            for (OutputStream out : this.closeList) {
                try {
                    out.close();
                }
                catch (IOException ex) {
                    this.debug(ex, "Failed reading output");
                }
            }
        }
    }

    private void debug(String format, Object ... args) {
    }

    private void debug(Throwable ex, String where) {
    }
}

