/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.ui.models;

import com.sun.jdi.Value;
import java.io.InvalidObjectException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.security.auth.Refreshable;
import javax.swing.JToolTip;
import org.netbeans.api.debugger.jpda.Field;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAWatch;
import org.netbeans.api.debugger.jpda.LocalVariable;
import org.netbeans.api.debugger.jpda.MutableVariable;
import org.netbeans.api.debugger.jpda.ObjectVariable;
import org.netbeans.api.debugger.jpda.Super;
import org.netbeans.api.debugger.jpda.This;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.ui.models.ValuePropertyEditor;
import org.netbeans.modules.debugger.jpda.ui.models.VariablesPropertyEditorsModel;
import org.netbeans.modules.debugger.jpda.ui.models.WatchesNodeModelFilter;
import org.netbeans.modules.debugger.jpda.ui.views.VariablesViewButtons;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.netbeans.spi.debugger.ui.Constants;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TableModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.WeakSet;

public class VariablesTableModel
implements TableModel,
Constants {
    private static final Map<Variable, Object> mirrors = new WeakHashMap<Variable, Object>();
    private static final Map<Variable, String> values = new WeakHashMap<Variable, String>();
    private static final Map<Variable, String> errorValueMsg = new WeakHashMap<Variable, String>();
    private static final Map<Variable, String> errorToStringMsg = new WeakHashMap<Variable, String>();
    private final Map<Variable, Value> origValues = new WeakHashMap<Variable, Value>();
    private static final Set<Variable> checkReadOnlyMutables = new WeakSet();
    private JPDADebugger debugger;
    private final List<ModelListener> modelListeners = new ArrayList<ModelListener>();

    public VariablesTableModel(ContextProvider contextProvider) {
        this.debugger = (JPDADebugger)contextProvider.lookupFirst(null, JPDADebugger.class);
    }

    public Object getValueAt(Object row, String columnID) throws UnknownTypeException {
        if ("LocalsToString".equals(columnID) || "WatchToString".equals(columnID)) {
            if (row instanceof Super) {
                return "";
            }
            if (row instanceof ObjectVariable) {
                try {
                    String toStr = ((ObjectVariable)row).getToStringValue();
                    VariablesTableModel.setErrorToStringMsg((Variable)((ObjectVariable)row), null);
                    return toStr;
                }
                catch (InvalidExpressionException ex) {
                    String errorMsg = VariablesTableModel.getMessage(ex);
                    VariablesTableModel.setErrorToStringMsg((Variable)((ObjectVariable)row), errorMsg);
                    return errorMsg;
                }
            }
            if (row instanceof Variable) {
                return ((Variable)row).getValue();
            }
            if (row instanceof EditorContext.Operation || row == "lastOperations" || row instanceof String && ((String)row).startsWith("operationArguments ")) {
                return "";
            }
        } else if ("LocalsType".equals(columnID) || "WatchType".equals(columnID)) {
            if (row instanceof Variable) {
                return VariablesTableModel.getShort(((Variable)row).getType());
            }
            if (row instanceof JToolTip && (row = ((JToolTip)row).getClientProperty("getShortDescription")) instanceof Variable) {
                if (row instanceof Refreshable && !((Refreshable)row).isCurrent()) {
                    return "";
                }
                return ((Variable)row).getType();
            }
        } else if ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID)) {
            if (row instanceof JPDAWatch) {
                JPDAWatch w = (JPDAWatch)row;
                String e = w.getExceptionDescription();
                if (e != null) {
                    VariablesTableModel.setErrorValueMsg((Variable)w, e);
                    return e;
                }
                VariablesTableModel.setErrorValueMsg((Variable)w, null);
            }
            if (row instanceof Variable) {
                Variable var = (Variable)row;
                if (VariablesViewButtons.isShowValuePropertyEditors()) {
                    return this.getValueOf(var, row, columnID);
                }
                return var.getValue();
            }
        }
        if (row instanceof JPDAClassType) {
            return "";
        }
        if (row.toString().startsWith("SubArray")) {
            return "";
        }
        if (row instanceof EditorContext.Operation || row == "lastOperations" || row instanceof String && ((String)row).startsWith("operationArguments ")) {
            return "";
        }
        if (row == "noDebugInfoWarning") {
            return "";
        }
        if (row == "No current thread") {
            return "";
        }
        throw new UnknownTypeException(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValueOf(Variable var, Object row, String columnID) {
        Object object;
        boolean current;
        if (var instanceof Refreshable && !(current = ((Refreshable)var).isCurrent())) {
            return var.getValue();
        }
        if (ValuePropertyEditor.hasPropertyEditorFor(var)) {
            Object mirror = var.createMirrorObject();
            object = mirrors;
            synchronized (object) {
                if (mirror == null) {
                    mirrors.remove(var);
                    this.origValues.remove(var);
                } else {
                    mirrors.put(var, mirror);
                }
                values.put(var, var.getValue());
            }
        } else {
            return var.getValue();
        }
        object = checkReadOnlyMutables;
        synchronized (object) {
            boolean isROCheck = checkReadOnlyMutables.remove((Variable)row);
        }
        this.fireModelChange((ModelEvent)new ModelEvent.TableValueChanged((Object)this, row, columnID, 4));
        return var;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setOrigValue(Variable var) {
        Map<Variable, Object> map = mirrors;
        synchronized (map) {
            this.origValues.put(var, ((JDIVariable)var).getJDIValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Object getMirrorFor(Variable var) {
        Map<Variable, Object> map = mirrors;
        synchronized (map) {
            return mirrors.get(var);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getValueOf(Variable var) {
        Map<Variable, Object> map = mirrors;
        synchronized (map) {
            return values.get(var);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getErrorValueMsg(Variable v) {
        Map<Variable, String> map = errorValueMsg;
        synchronized (map) {
            return errorValueMsg.get(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setErrorValueMsg(Variable v, String errorMsg) {
        Map<Variable, String> map = errorValueMsg;
        synchronized (map) {
            if (errorMsg != null) {
                errorValueMsg.put(v, errorMsg);
            } else {
                errorValueMsg.remove(v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getErrorToStringMsg(Variable v) {
        Map<Variable, String> map = errorToStringMsg;
        synchronized (map) {
            return errorToStringMsg.get(v);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setErrorToStringMsg(Variable v, String errorMsg) {
        Map<Variable, String> map = errorToStringMsg;
        synchronized (map) {
            if (errorMsg != null) {
                errorToStringMsg.put(v, errorMsg);
            } else {
                errorToStringMsg.remove(v);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean isReadOnlyVar(Object row, JPDADebugger debugger) {
        String declaredType;
        Object w;
        String e;
        if (row instanceof This) {
            return true;
        }
        if (row instanceof JPDAWatch && row instanceof Refreshable) {
            if (!((Refreshable)row).isCurrent()) {
                return true;
            }
            try {
                Method getEvaluatedWatchMethod = row.getClass().getDeclaredMethod("getEvaluatedWatch", new Class[0]);
                getEvaluatedWatchMethod.setAccessible(true);
                row = (JPDAWatch)getEvaluatedWatchMethod.invoke(row, new Object[0]);
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (row instanceof JPDAWatch && (e = (w = (JPDAWatch)row).getExceptionDescription()) != null) {
            return true;
        }
        if (row instanceof MutableVariable) {
            w = checkReadOnlyMutables;
            synchronized (w) {
                checkReadOnlyMutables.add((Variable)((MutableVariable)row));
            }
            Object mirror = VariablesTableModel.getMirrorFor((Variable)row);
            if (mirror != null) {
                return false;
            }
        }
        if (row instanceof ObjectVariable && !"java.lang.String".equals(declaredType = row instanceof LocalVariable ? ((LocalVariable)row).getDeclaredType() : (row instanceof Field ? ((Field)row).getDeclaredType() : ((ObjectVariable)row).getType()))) {
            return true;
        }
        if (row instanceof LocalVariable || row instanceof Field || row instanceof JPDAWatch) {
            if (WatchesNodeModelFilter.isEmptyWatch(row)) {
                return true;
            }
            return !debugger.canBeModified();
        }
        return true;
    }

    public boolean isReadOnly(Object row, String columnID) throws UnknownTypeException {
        if (row instanceof Variable) {
            if ("LocalsToString".equals(columnID) || "WatchToString".equals(columnID) || "LocalsType".equals(columnID) || "WatchType".equals(columnID)) {
                return true;
            }
            if ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID)) {
                return VariablesTableModel.isReadOnlyVar(row, this.debugger);
            }
        }
        if (row instanceof JPDAClassType) {
            return true;
        }
        if (row.toString().startsWith("SubArray")) {
            return true;
        }
        if (row instanceof EditorContext.Operation) {
            return true;
        }
        if (row == "noDebugInfoWarning") {
            return true;
        }
        if (row == "No current thread") {
            return true;
        }
        throw new UnknownTypeException(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValueAt(Object row, String columnID, Object value) throws UnknownTypeException {
        if (row instanceof MutableVariable && ("LocalsValue".equals(columnID) || "WatchValue".equals(columnID))) {
            NotifyDescriptor.Message descriptor;
            if (row == value) {
                Variable var;
                boolean doSet = false;
                Value origValue = null;
                Map<Variable, Object> map = mirrors;
                synchronized (map) {
                    var = (Variable)row;
                    if (this.origValues.containsKey(var)) {
                        origValue = this.origValues.get(var);
                        doSet = true;
                    }
                }
                if (doSet) {
                    VariablesTableModel.setValueToVar(var, origValue);
                    this.fireModelChange((ModelEvent)new ModelEvent.TableValueChanged((Object)this, row, columnID));
                    return;
                }
            }
            try {
                if (value instanceof String) {
                    ((MutableVariable)row).setValue((String)value);
                } else if (value instanceof ValuePropertyEditor.VariableWithMirror) {
                    Object mirror = ((ValuePropertyEditor.VariableWithMirror)value).createMirrorObject();
                    ((MutableVariable)row).setFromMirrorObject(mirror);
                } else {
                    if (value instanceof Variable) {
                        return;
                    }
                    ((MutableVariable)row).setFromMirrorObject(value);
                }
            }
            catch (InvalidExpressionException e) {
                descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            catch (InvalidObjectException e) {
                descriptor = new NotifyDescriptor.Message((Object)e.getLocalizedMessage(), 2);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor);
            }
            return;
        }
        throw new UnknownTypeException(row);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setValueToVar(Variable var, Value value) {
        Map<Variable, Object> map = mirrors;
        synchronized (map) {
            mirrors.remove(var);
        }
        try {
            Method setValueMethod = var.getClass().getDeclaredMethod("setValue", Value.class);
            setValueMethod.setAccessible(true);
            setValueMethod.invoke((Object)var, value);
            ValuePropertyEditor pe = VariablesPropertyEditorsModel.getExistingValuePropertyEditor(var);
            if (pe != null) {
                pe.setValue(var);
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener l) {
        List<ModelListener> list = this.modelListeners;
        synchronized (list) {
            this.modelListeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener l) {
        List<ModelListener> list = this.modelListeners;
        synchronized (list) {
            this.modelListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fireModelChange(ModelEvent me) {
        Object[] listeners;
        List<ModelListener> list = this.modelListeners;
        synchronized (list) {
            listeners = this.modelListeners.toArray();
        }
        for (int i = 0; i < listeners.length; ++i) {
            ((ModelListener)listeners[i]).modelChanged(me);
        }
    }

    static String getShort(String c) {
        int i = c.lastIndexOf(46);
        if (i < 0) {
            return c;
        }
        return c.substring(i + 1);
    }

    static String getMessage(InvalidExpressionException e) {
        Throwable t;
        String m = e.getLocalizedMessage();
        if (m == null) {
            m = e.getMessage();
        }
        if (m == null) {
            m = NbBundle.getMessage(VariablesTableModel.class, (String)"MSG_NA");
        }
        if ((t = e.getTargetException()) != null && e.hasApplicationTarget()) {
            StringWriter s = new StringWriter();
            PrintWriter p = new PrintWriter(s);
            t.printStackTrace(p);
            p.close();
            m = m + " \n" + s.toString();
        }
        return m;
    }
}

