/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.docker.ui.output;

import java.io.IOException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.docker.api.ActionChunkedResult;
import org.openide.util.RequestProcessor;
import org.openide.windows.InputOutput;

public class ChunkedResultOutputTask
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(ChunkedResultOutputTask.class.getName());
    private final RequestProcessor requestProcessor = new RequestProcessor(ChunkedResultOutputTask.class);
    private final InputOutput io;
    private final ActionChunkedResult logResult;

    public ChunkedResultOutputTask(InputOutput io, ActionChunkedResult logResult) {
        this.io = io;
        this.logResult = logResult;
    }

    public Future start() {
        return this.requestProcessor.submit((Runnable)this);
    }

    @Override
    public void run() {
        try {
            ActionChunkedResult.Chunk r;
            while ((r = this.logResult.fetchChunk()) != null) {
                if (r.isError()) {
                    this.io.getErr().print(r.getData());
                    continue;
                }
                this.io.getOut().print(r.getData());
            }
        }
        finally {
            this.close();
        }
    }

    private void close() {
        this.io.getOut().close();
        try {
            this.logResult.close();
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, null, ex);
        }
    }
}

