/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.hints.bugs;

import com.sun.source.util.TreePath;
import java.text.ChoiceFormat;
import java.text.DateFormat;
import java.text.Format;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.DuplicateFormatFlagsException;
import java.util.EnumSet;
import java.util.FormatFlagsConversionMismatchException;
import java.util.Formatter;
import java.util.HashMap;
import java.util.IllegalFormatException;
import java.util.IllegalFormatPrecisionException;
import java.util.IllegalFormatWidthException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.MissingFormatArgumentException;
import java.util.MissingFormatWidthException;
import java.util.UnknownFormatConversionException;
import java.util.UnknownFormatFlagsException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.TypeUtilities;
import org.netbeans.modules.java.hints.ArithmeticUtilities;
import org.netbeans.modules.java.hints.bugs.Bundle;
import org.netbeans.modules.java.hints.errors.Utilities;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.netbeans.spi.editor.hints.Fix;
import org.netbeans.spi.java.hints.ErrorDescriptionFactory;
import org.netbeans.spi.java.hints.HintContext;

public class MalformedFormatString {
    private static final String formatSpecifier = "%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])";
    private static final Pattern formatPattern = Pattern.compile("%(\\d+\\$)?([-#+ 0,(\\<]*)?(\\d+)?(\\.\\d+)?([tT])?([a-zA-Z%])");
    private static final String[] CALENDAR_ALLOWED_TYPES = new String[]{"java.lang.Long", "java.util.Calendar", "java.util.Date"};
    private static final Map<Character, EnumSet<TypeKind>> ALLOWED_TYPES = new HashMap<Character, EnumSet<TypeKind>>();

    public static List<ErrorDescription> run(HintContext ctx) {
        TypeElement te;
        TypeMirror ct;
        TypeMirror tm;
        TreePath format = (TreePath)ctx.getVariables().get("$f");
        Collection parameters = (Collection)ctx.getMultiVariables().get("$vars1$");
        if (format == null || parameters == null) {
            return null;
        }
        Object ret = ArithmeticUtilities.compute(ctx.getInfo(), format, true, true);
        if (ArithmeticUtilities.isNull(ret)) {
            return Collections.singletonList(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)format, (String)Bundle.ERR_NullFormatString(), (Fix[])new Fix[0]));
        }
        if (!(ret instanceof String)) {
            return null;
        }
        if (parameters.size() == 1 && (tm = ctx.getInfo().getTrees().getTypeMirror((TreePath)parameters.iterator().next())) != null && tm.getKind() == TypeKind.ARRAY && (ct = ((ArrayType)tm).getComponentType()) != null && ct.getKind() == TypeKind.DECLARED && (te = (TypeElement)((DeclaredType)ct).asElement()) != null && te.getQualifiedName().contentEquals("java.lang.Object")) {
            return null;
        }
        ArrayList paramList = new ArrayList(parameters);
        String fmtString = (String)ret;
        String errorMsg = null;
        try {
            new Formatter().format(fmtString, new Object[0]);
        }
        catch (MissingFormatArgumentException missingFormatArgumentException) {
        }
        catch (UnknownFormatConversionException ex) {
            errorMsg = Bundle.ERR_UnknownFormatSpecifier(ex.getConversion());
        }
        catch (DuplicateFormatFlagsException ex) {
            errorMsg = Bundle.ERR_DuplicateFormatFlag(ex.getFlags());
        }
        catch (IllegalFormatWidthException ex) {
            errorMsg = Bundle.ERR_InvalidFormatWidth(ex.getWidth());
        }
        catch (IllegalFormatPrecisionException ex) {
            errorMsg = Bundle.ERR_InvalidFormatPrecision(ex.getPrecision());
        }
        catch (MissingFormatWidthException ex) {
            errorMsg = Bundle.ERR_FormatWidthRequired(ex.getFormatSpecifier());
        }
        catch (FormatFlagsConversionMismatchException ex) {
            errorMsg = Bundle.ERR_FormatConversionFlags(Character.valueOf(ex.getConversion()), ex.getFlags());
        }
        catch (UnknownFormatFlagsException ex) {
            errorMsg = Bundle.ERR_UnkownFormatFlag(ex.getFlags());
        }
        catch (IllegalFormatException ex) {
            errorMsg = Bundle.ERR_SyntaxError();
        }
        if (errorMsg != null) {
            return Collections.singletonList(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)format, (String)Bundle.ERR_MalformedFormatString(errorMsg), (Fix[])new Fix[0]));
        }
        Matcher matcher = formatPattern.matcher(fmtString);
        int ord = -1;
        int lastArg = -1;
        int requiredArgs = -1;
        ArrayList<ErrorDescription> descs = new ArrayList<ErrorDescription>();
        int i = 0;
        int len = fmtString.length();
        while (i < len) {
            block32: {
                String c;
                String t;
                int argIndex;
                block33: {
                    char cc;
                    String idx;
                    block30: {
                        block31: {
                            argIndex = -1;
                            if (!matcher.find(i)) break;
                            idx = matcher.group(1);
                            String f = matcher.group(2);
                            t = matcher.group(5);
                            c = matcher.group(6);
                            if (f == null || !f.contains("<")) break block30;
                            if (lastArg >= 0) break block31;
                            descs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)format, (String)Bundle.ERR_InvalidFormatArgumentIndex("<"), (Fix[])new Fix[0]));
                            break block32;
                        }
                        argIndex = lastArg;
                        break block33;
                    }
                    argIndex = idx != null ? Integer.parseInt(idx.substring(0, idx.length() - 1)) - 1 : ((cc = c.charAt(0)) == '%' || cc == 'n' ? -1 : ++ord);
                }
                if (argIndex != -1) {
                    lastArg = argIndex;
                    if (paramList.size() <= argIndex) {
                        requiredArgs = Math.max(requiredArgs, argIndex + 1);
                    } else {
                        TypeMirror tm2 = ctx.getInfo().getTrees().getTypeMirror((TreePath)paramList.get(argIndex));
                        if (Utilities.isValidType(tm2)) {
                            TypeKind tk = tm2.getKind();
                            if (t != null) {
                                if (tk != TypeKind.LONG) {
                                    if (tk == TypeKind.DECLARED) {
                                        for (int j = CALENDAR_ALLOWED_TYPES.length - 1; j >= 0; --j) {
                                            String fqn = CALENDAR_ALLOWED_TYPES[j];
                                            TypeElement el = ctx.getInfo().getElements().getTypeElement(fqn);
                                            if (el == null || el.getKind() != ElementKind.CLASS || !ctx.getInfo().getTypes().isAssignable(tm2, el.asType())) {
                                                continue;
                                            }
                                            break;
                                        }
                                    } else {
                                        descs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)((TreePath)paramList.get(argIndex)), (String)Bundle.ERR_InvalidTypeForSpecifier(ctx.getInfo().getTypeUtilities().getTypeName(tm2, new TypeUtilities.TypeNameOptions[0]), matcher.group(0), argIndex + 1), (Fix[])new Fix[0]));
                                    }
                                }
                            } else if (!(tk != TypeKind.DECLARED ? tk == TypeKind.WILDCARD || tk == TypeKind.OTHER : (tk = MalformedFormatString.unboxBoxed(tm2)) == null || tk == TypeKind.PACKAGE)) {
                                char spec;
                                EnumSet<TypeKind> allowed;
                                if (!(c == null || c.isEmpty() || (allowed = ALLOWED_TYPES.get(Character.valueOf(spec = Character.toLowerCase(c.charAt(0))))) != null && allowed.contains((Object)tk))) {
                                    descs.add(ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)((TreePath)paramList.get(argIndex)), (String)Bundle.ERR_InvalidTypeForSpecifier(ctx.getInfo().getTypeUtilities().getTypeName(tm2, new TypeUtilities.TypeNameOptions[0]), matcher.group(0), argIndex + 1), (Fix[])new Fix[0]));
                                }
                            }
                        }
                    }
                }
            }
            i = matcher.end();
        }
        if (requiredArgs > 0) {
            descs.add(0, ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)format, (String)Bundle.ERR_FormatMissingParameters(requiredArgs, paramList.size()), (Fix[])new Fix[0]));
        }
        return descs;
    }

    public static List<ErrorDescription> checkMessageFormat(HintContext ctx) {
        TreePath formatPath = (TreePath)ctx.getVariables().get("$f");
        if (formatPath == null) {
            return null;
        }
        Object res = ArithmeticUtilities.compute(ctx.getInfo(), formatPath, true, true);
        if (!(res instanceof String)) {
            return null;
        }
        ArrayList<ErrorDescription> output = new ArrayList<ErrorDescription>();
        Collection paths = (Collection)ctx.getMultiVariables().get("$vars1$");
        TypeMirror[] valTypes = new TypeMirror[paths.size()];
        Iterator it = paths.iterator();
        for (int index = 0; index < paths.size(); ++index) {
            valTypes[index] = ctx.getInfo().getTrees().getTypeMirror((TreePath)it.next());
        }
        TypeMirror arrType = null;
        if (valTypes.length == 1 && valTypes[0].getKind() == TypeKind.ARRAY) {
            arrType = ((ArrayType)valTypes[0]).getComponentType();
            valTypes = null;
        }
        int maxIndex = MalformedFormatString.checkFormatString(formatPath, (String)res, ctx, output, -1, valTypes, arrType);
        if (valTypes != null && valTypes.length < maxIndex - 1) {
            output.add(MalformedFormatString.createError(ctx, formatPath, -1, 0, Bundle.ERR_MessageFormatTooFewVals(maxIndex)));
        }
        return output.isEmpty() ? null : output;
    }

    private static ErrorDescription createError(HintContext ctx, TreePath formatPath, int offset, int len, String msg) {
        if (offset != -1) {
            return ErrorDescriptionFactory.forSpan((HintContext)ctx, (int)offset, (int)(offset + len), (String)msg, (Fix[])new Fix[0]);
        }
        return ErrorDescriptionFactory.forTree((HintContext)ctx, (TreePath)formatPath, (String)msg, (Fix[])new Fix[0]);
    }

    private static int checkFormatString(TreePath formatPath, String format, HintContext ctx, List<ErrorDescription> desc, int offset, TypeMirror[] valTypes, TypeMirror arrType) {
        MessageFormat fmt;
        int maxIndex = -1;
        try {
            fmt = new MessageFormat(format);
        }
        catch (RuntimeException ex) {
            desc.add(MalformedFormatString.createError(ctx, formatPath, offset, format.length(), Bundle.ERR_MessageFormatStringMalformed(ex.getLocalizedMessage())));
            return maxIndex;
        }
        Format[] argFormats = fmt.getFormatsByArgumentIndex();
        maxIndex = argFormats.length;
        for (int index = 0; index < argFormats.length && (valTypes == null || index < valTypes.length); ++index) {
            TypeMirror at;
            Format pf = argFormats[index];
            TypeMirror typeMirror = at = valTypes == null ? arrType : valTypes[index];
            if (!Utilities.isValidType(at) || pf == null) continue;
            if (pf instanceof NumberFormat) {
                TypeKind k = at.getKind();
                if (k == TypeKind.DECLARED && (k = MalformedFormatString.unboxBoxed(at)) == null) {
                    k = TypeKind.DECLARED;
                }
                switch (at.getKind()) {
                    case BYTE: 
                    case CHAR: 
                    case DOUBLE: 
                    case FLOAT: 
                    case INT: 
                    case LONG: 
                    case SHORT: {
                        break;
                    }
                    default: {
                        desc.add(MalformedFormatString.createError(ctx, formatPath, offset, format.length(), Bundle.ERR_MessageFormatNumber(index)));
                        break;
                    }
                }
                continue;
            }
            if (pf instanceof DateFormat) {
                if (at.getKind() == TypeKind.DECLARED) continue;
                desc.add(MalformedFormatString.createError(ctx, formatPath, offset, format.length(), Bundle.ERR_MessageFormatDateTime(index)));
                continue;
            }
            if (!(pf instanceof ChoiceFormat)) continue;
            ChoiceFormat chf = (ChoiceFormat)pf;
            String[] subformats = (String[])chf.getFormats();
            int sOffset = 0;
            for (String s : subformats) {
                sOffset = format.indexOf(s, sOffset);
                maxIndex = Math.max(maxIndex, MalformedFormatString.checkFormatString(null, s, ctx, desc, sOffset, valTypes, arrType));
                sOffset += s.length();
            }
        }
        return maxIndex;
    }

    private static TypeKind unboxBoxed(TypeMirror tm) {
        TypeElement te = (TypeElement)((DeclaredType)tm).asElement();
        String qn = te.getQualifiedName().toString();
        if (!qn.startsWith("java.lang.")) {
            if (qn.equals("java.math.BigInteger")) {
                return TypeKind.WILDCARD;
            }
            return null;
        }
        switch (qn.substring(10)) {
            case "Short": {
                return TypeKind.SHORT;
            }
            case "Long": {
                return TypeKind.LONG;
            }
            case "Byte": {
                return TypeKind.BYTE;
            }
            case "Integer": {
                return TypeKind.INT;
            }
            case "Double": {
                return TypeKind.DOUBLE;
            }
            case "Float": {
                return TypeKind.FLOAT;
            }
            case "Character": {
                return TypeKind.CHAR;
            }
            case "String": {
                return TypeKind.OTHER;
            }
            case "Object": {
                return TypeKind.PACKAGE;
            }
        }
        return null;
    }

    static {
        ALLOWED_TYPES.put(Character.valueOf('c'), EnumSet.of(TypeKind.BYTE, TypeKind.SHORT, TypeKind.INT, TypeKind.CHAR, TypeKind.WILDCARD));
        ALLOWED_TYPES.put(Character.valueOf('d'), EnumSet.of(TypeKind.BYTE, TypeKind.SHORT, TypeKind.INT, TypeKind.LONG, TypeKind.WILDCARD));
        ALLOWED_TYPES.put(Character.valueOf('o'), EnumSet.of(TypeKind.BYTE, TypeKind.SHORT, TypeKind.INT, TypeKind.LONG, TypeKind.WILDCARD));
        ALLOWED_TYPES.put(Character.valueOf('x'), EnumSet.of(TypeKind.BYTE, TypeKind.SHORT, TypeKind.INT, TypeKind.LONG, TypeKind.WILDCARD));
        ALLOWED_TYPES.put(Character.valueOf('e'), EnumSet.of(TypeKind.FLOAT, TypeKind.DOUBLE, TypeKind.WILDCARD));
        ALLOWED_TYPES.put(Character.valueOf('g'), EnumSet.of(TypeKind.FLOAT, TypeKind.DOUBLE, TypeKind.WILDCARD));
        ALLOWED_TYPES.put(Character.valueOf('f'), EnumSet.of(TypeKind.FLOAT, TypeKind.DOUBLE, TypeKind.WILDCARD));
        ALLOWED_TYPES.put(Character.valueOf('a'), EnumSet.of(TypeKind.FLOAT, TypeKind.DOUBLE, TypeKind.WILDCARD));
        ALLOWED_TYPES.put(Character.valueOf('c'), EnumSet.of(TypeKind.CHAR));
        ALLOWED_TYPES.put(Character.valueOf('s'), EnumSet.allOf(TypeKind.class));
        ALLOWED_TYPES.put(Character.valueOf('b'), EnumSet.allOf(TypeKind.class));
        ALLOWED_TYPES.put(Character.valueOf('h'), EnumSet.allOf(TypeKind.class));
    }
}

