/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.socket.sockjs.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.List;
import org.springframework.util.Assert;
import org.springframework.util.concurrent.SettableListenableFuture;
import org.springframework.web.socket.CloseStatus;
import org.springframework.web.socket.TextMessage;
import org.springframework.web.socket.WebSocketExtension;
import org.springframework.web.socket.WebSocketHandler;
import org.springframework.web.socket.WebSocketSession;
import org.springframework.web.socket.adapter.NativeWebSocketSession;
import org.springframework.web.socket.sockjs.client.AbstractClientSockJsSession;
import org.springframework.web.socket.sockjs.client.TransportRequest;

public class WebSocketClientSockJsSession
extends AbstractClientSockJsSession
implements NativeWebSocketSession {
    private WebSocketSession webSocketSession;

    public WebSocketClientSockJsSession(TransportRequest request, WebSocketHandler handler, SettableListenableFuture<WebSocketSession> connectFuture) {
        super(request, handler, connectFuture);
    }

    @Override
    public Object getNativeSession() {
        return this.webSocketSession;
    }

    @Override
    public <T> T getNativeSession(Class<T> requiredType) {
        return (T)(requiredType == null || requiredType.isInstance(this.webSocketSession) ? this.webSocketSession : null);
    }

    @Override
    public InetSocketAddress getLocalAddress() {
        this.checkDelegateSessionInitialized();
        return this.webSocketSession.getLocalAddress();
    }

    @Override
    public InetSocketAddress getRemoteAddress() {
        this.checkDelegateSessionInitialized();
        return this.webSocketSession.getRemoteAddress();
    }

    @Override
    public String getAcceptedProtocol() {
        this.checkDelegateSessionInitialized();
        return this.webSocketSession.getAcceptedProtocol();
    }

    @Override
    public void setTextMessageSizeLimit(int messageSizeLimit) {
        this.checkDelegateSessionInitialized();
        this.webSocketSession.setTextMessageSizeLimit(messageSizeLimit);
    }

    @Override
    public int getTextMessageSizeLimit() {
        this.checkDelegateSessionInitialized();
        return this.webSocketSession.getTextMessageSizeLimit();
    }

    @Override
    public void setBinaryMessageSizeLimit(int messageSizeLimit) {
        this.checkDelegateSessionInitialized();
        this.webSocketSession.setBinaryMessageSizeLimit(messageSizeLimit);
    }

    @Override
    public int getBinaryMessageSizeLimit() {
        this.checkDelegateSessionInitialized();
        return this.webSocketSession.getBinaryMessageSizeLimit();
    }

    @Override
    public List<WebSocketExtension> getExtensions() {
        this.checkDelegateSessionInitialized();
        return this.webSocketSession.getExtensions();
    }

    private void checkDelegateSessionInitialized() {
        Assert.state((this.webSocketSession != null ? 1 : 0) != 0, (String)"WebSocketSession not yet initialized");
    }

    public void initializeDelegateSession(WebSocketSession session) {
        this.webSocketSession = session;
    }

    @Override
    protected void sendInternal(TextMessage textMessage) throws IOException {
        this.webSocketSession.sendMessage(textMessage);
    }

    @Override
    protected void disconnect(CloseStatus status) throws IOException {
        if (this.webSocketSession != null) {
            this.webSocketSession.close(status);
        }
    }
}

