/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.versioning.core.api;

import java.awt.EventQueue;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.EventListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.extexecution.ProcessBuilder;
import org.netbeans.modules.versioning.core.APIAccessor;
import org.netbeans.modules.versioning.core.FlatFolder;
import org.netbeans.modules.versioning.core.Utils;
import org.netbeans.modules.versioning.core.api.APIAccessorImpl;
import org.netbeans.modules.versioning.core.filesystems.VCSFileProxyOperations;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class VCSFileProxy
implements Comparable<VCSFileProxy> {
    private final String path;
    private final VCSFileProxyOperations proxy;
    private boolean isFlat = false;
    private Boolean isDirectory = null;
    private FileChangeListener fileChangeListener = null;

    private VCSFileProxy(String path, VCSFileProxyOperations proxy) {
        this.path = path;
        this.proxy = proxy;
    }

    public static VCSFileProxy createFileProxy(File file) {
        VCSFileProxy p = new VCSFileProxy(file.getAbsolutePath(), null);
        if (file instanceof FlatFolder) {
            p.setFlat(true);
        }
        return p;
    }

    public static VCSFileProxy createFileProxy(VCSFileProxy parent, String child) {
        File parentFile = parent.toFile();
        if (parentFile != null) {
            return VCSFileProxy.createFileProxy(new File(parentFile, child));
        }
        String p = parent.getPath();
        if (p.endsWith("/")) {
            return new VCSFileProxy(p + child, parent.proxy);
        }
        if (p.isEmpty() && child.startsWith("/")) {
            return new VCSFileProxy(child, parent.proxy);
        }
        return new VCSFileProxy(p + "/" + child, parent.proxy);
    }

    static VCSFileProxy createFileProxy(String path) {
        return new VCSFileProxy(path, null);
    }

    static VCSFileProxy createFileProxy(VCSFileProxy parent, String child, boolean isDirectory) {
        VCSFileProxy file = VCSFileProxy.createFileProxy(parent, child);
        file.isDirectory = isDirectory;
        return file;
    }

    public static VCSFileProxy createFileProxy(URI uri) {
        if (uri.getScheme().equals("file")) {
            return VCSFileProxy.createFileProxy(Utilities.toFile((URI)uri));
        }
        VCSFileProxyOperations fileProxyOperations = VCSFileProxy.getFileProxyOperations(uri);
        if (fileProxyOperations != null) {
            VCSFileProxy file = new VCSFileProxy(uri.getPath(), fileProxyOperations);
            return file;
        }
        return null;
    }

    public static VCSFileProxy createFileProxy(final FileObject fileObject) {
        try {
            VCSFileProxyOperations fileProxyOperations = VCSFileProxy.getFileProxyOperations(fileObject.getFileSystem());
            if (fileProxyOperations == null) {
                File file = FileUtil.toFile((FileObject)fileObject);
                if (file != null) {
                    final VCSFileProxy p = VCSFileProxy.createFileProxy(file);
                    p.isDirectory = fileObject.isFolder();
                    p.fileChangeListener = new FileChangeListener(){

                        public void fileDeleted(FileEvent fe) {
                            p.isDirectory = null;
                        }

                        public void fileFolderCreated(FileEvent fe) {
                        }

                        public void fileDataCreated(FileEvent fe) {
                        }

                        public void fileChanged(FileEvent fe) {
                        }

                        public void fileRenamed(FileRenameEvent fe) {
                        }

                        public void fileAttributeChanged(FileAttributeEvent fe) {
                        }
                    };
                    Runnable run = new Runnable(){

                        @Override
                        public void run() {
                            fileObject.addFileChangeListener((FileChangeListener)WeakListeners.create(FileChangeListener.class, (EventListener)p.fileChangeListener, (Object)fileObject));
                        }
                    };
                    if (EventQueue.isDispatchThread()) {
                        Utils.postParallel(run);
                    } else {
                        run.run();
                    }
                    return p;
                }
                return null;
            }
            return new VCSFileProxy(fileObject.getPath(), fileProxyOperations);
        }
        catch (FileStateInvalidException ex) {
            Logger.getLogger(VCSFileProxy.class.getName()).log(Level.SEVERE, null, ex);
            return new VCSFileProxy(fileObject.getPath(), null);
        }
    }

    public String getPath() {
        return this.path;
    }

    public URI toURI() throws URISyntaxException {
        if (this.proxy == null) {
            return Utilities.toURI((File)new File(this.path));
        }
        return this.proxy.toURI(this);
    }

    public String getName() {
        if (this.proxy == null) {
            return new File(this.path).getName();
        }
        return this.proxy.getName(this);
    }

    public boolean isDirectory() {
        if (this.proxy == null) {
            if (this.isDirectory != null) {
                return this.isDirectory;
            }
            return new File(this.path).isDirectory();
        }
        return this.proxy.isDirectory(this);
    }

    public boolean isFile() {
        if (this.proxy == null) {
            if (this.isDirectory != null) {
                return this.isDirectory == false;
            }
            return new File(this.path).isFile();
        }
        return this.proxy.isFile(this);
    }

    public boolean canWrite() {
        if (this.proxy == null) {
            return new File(this.path).canWrite();
        }
        return this.proxy.canWrite(this);
    }

    public long lastModified() {
        if (this.proxy == null) {
            return new File(this.path).lastModified();
        }
        return this.proxy.lastModified(this);
    }

    public VCSFileProxy getParentFile() {
        if (this.proxy == null) {
            File parent = new File(this.path).getParentFile();
            if (parent == null) {
                return null;
            }
            return VCSFileProxy.createFileProxy(parent);
        }
        return this.proxy.getParentFile(this);
    }

    public InputStream getInputStream(boolean checkLock) throws FileNotFoundException {
        if (this.proxy == null) {
            if (checkLock) {
                FileObject fo = this.toFileObject();
                if (fo != null) {
                    return fo.getInputStream();
                }
                throw new FileNotFoundException("File not found: " + this.path);
            }
            return new FileInputStream(new File(this.path));
        }
        return this.proxy.getInputStream(this, checkLock);
    }

    public boolean exists() {
        if (this.proxy == null) {
            return new File(this.path).exists();
        }
        return this.proxy.exists(this);
    }

    public VCSFileProxy[] listFiles() {
        if (this.proxy == null) {
            File[] files = new File(this.path).listFiles();
            if (files != null) {
                VCSFileProxy[] ret = new VCSFileProxy[files.length];
                for (int i = 0; i < files.length; ++i) {
                    ret[i] = VCSFileProxy.createFileProxy(files[i]);
                }
                return ret;
            }
            return null;
        }
        return this.proxy.list(this);
    }

    public File toFile() {
        if (this.proxy == null) {
            return this.isFlat ? new FlatFolder(this.path) : new File(this.path);
        }
        return null;
    }

    public FileObject toFileObject() {
        if (this.proxy == null) {
            return FileUtil.toFileObject((File)new File(FileUtil.normalizePath((String)this.path)));
        }
        return this.proxy.toFileObject(this);
    }

    public VCSFileProxy normalizeFile() {
        if (this.proxy == null) {
            return new VCSFileProxy(FileUtil.normalizePath((String)this.path), null);
        }
        return this.proxy.normalize(this);
    }

    @Override
    public int compareTo(VCSFileProxy o) {
        return this.path.compareTo(o.path);
    }

    public String toString() {
        return this.path;
    }

    public int hashCode() {
        int hash = 5;
        hash = 61 * hash + (this.path != null ? this.path.hashCode() : 0);
        hash = 61 * hash + (this.proxy != null ? this.proxy.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        VCSFileProxy other = (VCSFileProxy)obj;
        if (this.path == null ? other.path != null : !this.path.equals(other.path)) {
            return false;
        }
        return this.proxy == other.proxy || this.proxy != null && this.proxy.equals(other.proxy);
    }

    void setFlat(boolean flat) {
        this.isFlat = flat;
    }

    boolean isFlat() {
        return this.isFlat;
    }

    private static VCSFileProxyOperations getFileProxyOperations(FileSystem fs) {
        return (VCSFileProxyOperations)VCSFileProxy.getAttribute(fs, "FileProxyOperations");
    }

    private static VCSFileProxyOperations getFileProxyOperations(URI uri) {
        for (VCSFileProxyOperations.Provider provider : Lookup.getDefault().lookupAll(VCSFileProxyOperations.Provider.class)) {
            VCSFileProxyOperations fileProxyOperations = provider.getVCSFileProxyOperations(uri);
            if (fileProxyOperations == null) continue;
            return fileProxyOperations;
        }
        return null;
    }

    private static Object getAttribute(FileSystem fileSystem, String attrName) {
        return fileSystem.getRoot().getAttribute(attrName);
    }

    ProcessBuilder createProcessBuilder() {
        if (this.proxy == null) {
            return ProcessBuilder.getLocal();
        }
        return this.proxy.createProcessBuilder(this);
    }

    VCSFileProxyOperations getFileProxyOperations() {
        return this.proxy;
    }

    static {
        APIAccessor.IMPL = new APIAccessorImpl();
    }
}

