/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.ui.models;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.debugger.ui.actions.AddBreakpointAction;
import org.netbeans.modules.debugger.ui.models.BreakpointGroup;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.Models;
import org.netbeans.spi.viewmodel.NodeActionsProvider;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.Presenter;
import org.openide.windows.TopComponent;

public class BreakpointsActionsProvider
implements NodeActionsProvider {
    private static final Action NEW_BREEAKPOINT_ACTION = new AbstractAction(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_New_Label")){

        @Override
        public void actionPerformed(ActionEvent e) {
            new AddBreakpointAction().actionPerformed(null);
        }
    };
    private static final Action ENABLE_ALL_ACTION = new AbstractAction(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_EnableAll_Label")){

        @Override
        public boolean isEnabled() {
            Breakpoint[] bs = BreakpointsActionsProvider.getShowingBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                if (bs[i].isEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Breakpoint[] bs = BreakpointsActionsProvider.getShowingBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                bs[i].enable();
            }
        }
    };
    private static final Action DISABLE_ALL_ACTION = new AbstractAction(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_DisableAll_Label")){

        @Override
        public boolean isEnabled() {
            Breakpoint[] bs = BreakpointsActionsProvider.getShowingBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                if (!bs[i].isEnabled()) continue;
                return true;
            }
            return false;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Breakpoint[] bs = BreakpointsActionsProvider.getShowingBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                bs[i].disable();
            }
        }
    };
    private static final Action DELETE_ALL_ACTION = new AbstractAction(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_DeleteAll_Label")){

        @Override
        public boolean isEnabled() {
            Breakpoint[] bs = BreakpointsActionsProvider.getShowingBreakpoints();
            return bs.length > 0;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DebuggerManager dm = DebuggerManager.getDebuggerManager();
            Breakpoint[] bs = BreakpointsActionsProvider.getShowingBreakpoints();
            int k = bs.length;
            for (int i = 0; i < k; ++i) {
                dm.removeBreakpoint(bs[i]);
            }
        }
    };
    private static final Action ENABLE_ACTION = Models.createAction((String)NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_Enable_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                ((Breakpoint)nodes[i]).enable();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action DISABLE_ACTION = Models.createAction((String)NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_Disable_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(Object[] nodes) {
            int k = nodes.length;
            for (int i = 0; i < k; ++i) {
                ((Breakpoint)nodes[i]).disable();
            }
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static RequestProcessor deleteRP = new RequestProcessor("Breakpoint Delete", 1);
    private static final Action DELETE_ACTION = Models.createAction((String)NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_Delete_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

        public boolean isEnabled(Object node) {
            return true;
        }

        public void perform(final Object[] nodes) {
            deleteRP.post(new Runnable(){

                @Override
                public void run() {
                    DebuggerManager dm = DebuggerManager.getDebuggerManager();
                    int k = nodes.length;
                    for (int i = 0; i < k; ++i) {
                        dm.removeBreakpoint((Breakpoint)nodes[i]);
                    }
                }
            });
        }
    }, (int)Models.MULTISELECTION_TYPE_ANY);
    private static final Action SET_GROUP_NAME_ACTION;
    private static final Action DELETE_ALL_ACTION_S;
    private static final Action ENABLE_ALL_ACTION_S;
    private static final Action DISABLE_ALL_ACTION_S;
    private Action moveIntoGroupAction = new MoveIntoGroupAction();

    private static Breakpoint[] getShowingBreakpoints() {
        DebuggerManager dm = DebuggerManager.getDebuggerManager();
        Breakpoint[] bs = dm.getBreakpoints();
        boolean[] visible = new boolean[bs.length];
        int n = 0;
        for (int i = 0; i < bs.length; ++i) {
            boolean v;
            Breakpoint b = bs[i];
            visible[i] = v = BreakpointsActionsProvider.isVisible(b);
            if (!v) continue;
            ++n;
        }
        Breakpoint[] visibleBs = new Breakpoint[n];
        int vi = 0;
        for (int i = 0; i < bs.length; ++i) {
            if (!visible[i]) continue;
            visibleBs[vi++] = bs[i];
        }
        return visibleBs;
    }

    private static boolean isVisible(Breakpoint b) {
        try {
            Method isHiddenMethod = b.getClass().getMethod("isHidden", new Class[0]);
            Object hidden = isHiddenMethod.invoke((Object)b, new Object[0]);
            return Boolean.FALSE.equals(hidden);
        }
        catch (Exception ex) {
            return true;
        }
    }

    public Action[] getActions(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return new Action[]{NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, DELETE_ALL_ACTION, null};
        }
        if (node instanceof BreakpointGroup) {
            if (((BreakpointGroup)node).getGroup() == BreakpointGroup.Group.CUSTOM) {
                return new Action[]{SET_GROUP_NAME_ACTION, null, ENABLE_ALL_ACTION_S, DISABLE_ALL_ACTION_S, DELETE_ALL_ACTION_S, null};
            }
            return new Action[]{ENABLE_ALL_ACTION_S, DISABLE_ALL_ACTION_S, DELETE_ALL_ACTION_S, null};
        }
        if (node instanceof Breakpoint) {
            if (((Breakpoint)node).isEnabled()) {
                return new Action[]{DISABLE_ACTION, this.moveIntoGroupAction, null, NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, null, DELETE_ACTION, DELETE_ALL_ACTION, null};
            }
            return new Action[]{ENABLE_ACTION, this.moveIntoGroupAction, null, NEW_BREEAKPOINT_ACTION, null, ENABLE_ALL_ACTION, DISABLE_ALL_ACTION, null, DELETE_ACTION, DELETE_ALL_ACTION, null};
        }
        throw new UnknownTypeException(node);
    }

    public void performDefaultAction(Object node) throws UnknownTypeException {
        if (node == "Root") {
            return;
        }
        if (node instanceof BreakpointGroup) {
            return;
        }
        if (node instanceof Breakpoint) {
            return;
        }
        throw new UnknownTypeException(node);
    }

    public void addModelListener(ModelListener l) {
    }

    public void removeModelListener(ModelListener l) {
    }

    private static void setGroupName(Object[] nodes) {
        NotifyDescriptor.InputLine descriptor = new NotifyDescriptor.InputLine(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_GroupDialog_NameLabel"), NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_GroupDialog_Title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)descriptor) == NotifyDescriptor.OK_OPTION) {
            int k = nodes.length;
            String newName = descriptor.getInputText();
            for (int i = 0; i < k; ++i) {
                if (nodes[i] instanceof BreakpointGroup) {
                    BreakpointGroup g = (BreakpointGroup)nodes[i];
                    BreakpointsActionsProvider.setGroupName(g, newName);
                    continue;
                }
                if (!(nodes[i] instanceof Breakpoint)) continue;
                ((Breakpoint)nodes[i]).setGroupName(newName);
            }
        }
    }

    private static void setGroupName(BreakpointGroup group, String name) {
        for (BreakpointGroup g : group.getSubGroups()) {
            BreakpointsActionsProvider.setGroupName(g, name);
        }
        for (Breakpoint b : group.getBreakpoints()) {
            b.setGroupName(name);
        }
    }

    static {
        DELETE_ACTION.putValue("AcceleratorKey", KeyStroke.getKeyStroke("DELETE"));
        SET_GROUP_NAME_ACTION = Models.createAction((String)NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_SetGroupName_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                BreakpointsActionsProvider.setGroupName(nodes);
            }
        }, (int)Models.MULTISELECTION_TYPE_ALL);
        DELETE_ALL_ACTION_S = Models.createAction((String)NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_DeleteAllG_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                return true;
            }

            public void perform(Object[] nodes) {
                BreakpointGroup bg = (BreakpointGroup)nodes[0];
                if (bg.getGroup() == BreakpointGroup.Group.CUSTOM) {
                    String groupName = bg.getName();
                    DebuggerManager dm = DebuggerManager.getDebuggerManager();
                    Breakpoint[] bs = dm.getBreakpoints();
                    int k = bs.length;
                    for (int i = 0; i < k; ++i) {
                        if (!bs[i].getGroupName().equals(groupName)) continue;
                        dm.removeBreakpoint(bs[i]);
                    }
                } else {
                    DebuggerManager dm = DebuggerManager.getDebuggerManager();
                    List<Breakpoint> breakpoints = bg.getBreakpoints();
                    for (Breakpoint b : breakpoints) {
                        dm.removeBreakpoint(b);
                    }
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        ENABLE_ALL_ACTION_S = Models.createAction((String)NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_EnableAllG_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                BreakpointGroup bg = (BreakpointGroup)node;
                if (bg.getGroup() == BreakpointGroup.Group.CUSTOM) {
                    String groupName = ((BreakpointGroup)node).getName();
                    DebuggerManager dm = DebuggerManager.getDebuggerManager();
                    Breakpoint[] bs = dm.getBreakpoints();
                    int k = bs.length;
                    for (int i = 0; i < k; ++i) {
                        if (!bs[i].getGroupName().equals(groupName) || bs[i].isEnabled()) continue;
                        return true;
                    }
                } else {
                    List<Breakpoint> breakpoints = bg.getBreakpoints();
                    for (Breakpoint b : breakpoints) {
                        if (b.isEnabled()) continue;
                        return true;
                    }
                }
                return false;
            }

            public void perform(Object[] nodes) {
                BreakpointGroup bg = (BreakpointGroup)nodes[0];
                if (bg.getGroup() == BreakpointGroup.Group.CUSTOM) {
                    String groupName = bg.getName();
                    Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                    int k = bs.length;
                    for (int i = 0; i < k; ++i) {
                        if (!bs[i].getGroupName().equals(groupName)) continue;
                        bs[i].enable();
                    }
                } else {
                    List<Breakpoint> breakpoints = bg.getBreakpoints();
                    for (Breakpoint b : breakpoints) {
                        b.enable();
                    }
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
        DISABLE_ALL_ACTION_S = Models.createAction((String)NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_DisableAllG_Label"), (Models.ActionPerformer)new Models.ActionPerformer(){

            public boolean isEnabled(Object node) {
                BreakpointGroup bg = (BreakpointGroup)node;
                if (bg.getGroup() == BreakpointGroup.Group.CUSTOM) {
                    String groupName = ((BreakpointGroup)node).getName();
                    DebuggerManager dm = DebuggerManager.getDebuggerManager();
                    Breakpoint[] bs = dm.getBreakpoints();
                    int k = bs.length;
                    for (int i = 0; i < k; ++i) {
                        if (!bs[i].getGroupName().equals(groupName) || !bs[i].isEnabled()) continue;
                        return true;
                    }
                } else {
                    List<Breakpoint> breakpoints = bg.getBreakpoints();
                    for (Breakpoint b : breakpoints) {
                        if (!b.isEnabled()) continue;
                        return true;
                    }
                }
                return false;
            }

            public void perform(Object[] nodes) {
                BreakpointGroup bg = (BreakpointGroup)nodes[0];
                if (bg.getGroup() == BreakpointGroup.Group.CUSTOM) {
                    String groupName = bg.getName();
                    Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
                    int k = bs.length;
                    for (int i = 0; i < k; ++i) {
                        if (!bs[i].getGroupName().equals(groupName)) continue;
                        bs[i].disable();
                    }
                } else {
                    List<Breakpoint> breakpoints = bg.getBreakpoints();
                    for (Breakpoint b : breakpoints) {
                        b.disable();
                    }
                }
            }
        }, (int)Models.MULTISELECTION_TYPE_EXACTLY_ONE);
    }

    private static class MoveIntoGroupAction
    extends AbstractAction
    implements Presenter.Popup {
        @Override
        public void actionPerformed(ActionEvent e) {
        }

        private Breakpoint[] getCurrentBreakpoints() {
            Node[] ns = TopComponent.getRegistry().getActivatedNodes();
            int k = ns.length;
            ArrayList<Breakpoint> bps = new ArrayList<Breakpoint>();
            for (int i = 0; i < k; ++i) {
                Object node = ns[i].getLookup().lookup(Object.class);
                if (!(node instanceof Breakpoint)) continue;
                bps.add((Breakpoint)node);
            }
            return bps.toArray(new Breakpoint[0]);
        }

        private String findCommonBpGroup(Breakpoint[] bps) {
            String g = null;
            for (Breakpoint bp : bps) {
                String gn = bp.getGroupName();
                if (g == null) {
                    g = gn;
                    continue;
                }
                if (g.equals(gn)) continue;
                return null;
            }
            return g;
        }

        public JMenuItem getPopupPresenter() {
            final Breakpoint[] bps = this.getCurrentBreakpoints();
            String bpGroup = this.findCommonBpGroup(bps);
            JMenu moveIntoGroupMenu = new JMenu(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_MoveIntoGroup"));
            TreeSet<String> groupNames = new TreeSet<String>();
            Breakpoint[] bs = DebuggerManager.getDebuggerManager().getBreakpoints();
            for (int i = 0; i < bs.length; ++i) {
                final String gn = bs[i].getGroupName();
                groupNames.add(gn);
            }
            groupNames.add("");
            if (bpGroup != null) {
                groupNames.remove(bpGroup);
            }
            for (final String gn : groupNames) {
                JMenuItem group = gn.length() > 0 ? new JMenuItem(gn) : new JMenuItem(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_MoveIntoDefaultGroup_Label"));
                moveIntoGroupMenu.add(group);
                group.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        for (Breakpoint bp : bps) {
                            bp.setGroupName(gn);
                        }
                    }
                });
            }
            JMenuItem newGroup = new JMenuItem(NbBundle.getMessage(BreakpointsActionsProvider.class, (String)"CTL_BreakpointAction_MoveIntoNewGroup_Label"));
            newGroup.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    BreakpointsActionsProvider.setGroupName(bps);
                }
            });
            moveIntoGroupMenu.add(newGroup);
            return moveIntoGroupMenu;
        }
    }
}

