/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.test.context.transaction;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.BeanFactoryAnnotationUtils;
import org.springframework.beans.factory.config.AutowireCapableBeanFactory;
import org.springframework.core.annotation.AnnotatedElementUtils;
import org.springframework.lang.Nullable;
import org.springframework.test.annotation.Rollback;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.transaction.AfterTransaction;
import org.springframework.test.context.transaction.BeforeTransaction;
import org.springframework.test.context.transaction.TestContextTransactionUtils;
import org.springframework.test.context.transaction.TransactionContext;
import org.springframework.test.context.transaction.TransactionContextHolder;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.annotation.AnnotationTransactionAttributeSource;
import org.springframework.transaction.interceptor.TransactionAttribute;
import org.springframework.transaction.interceptor.TransactionAttributeSource;
import org.springframework.util.Assert;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class TransactionalTestExecutionListener
extends AbstractTestExecutionListener {
    private static final Log logger = LogFactory.getLog(TransactionalTestExecutionListener.class);
    protected final TransactionAttributeSource attributeSource = new AnnotationTransactionAttributeSource(false);

    @Override
    public final int getOrder() {
        return 4000;
    }

    @Override
    public void beforeTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Class<?> testClass = testContext.getTestClass();
        Assert.notNull((Object)testMethod, (String)"Test method of supplied TestContext must not be null");
        TransactionContext txContext = TransactionContextHolder.removeCurrentTransactionContext();
        Assert.state((txContext == null ? 1 : 0) != 0, (String)"Cannot start new transaction without ending existing transaction");
        PlatformTransactionManager tm = null;
        TransactionAttribute transactionAttribute = this.attributeSource.getTransactionAttribute(testMethod, testClass);
        if (transactionAttribute != null) {
            transactionAttribute = TestContextTransactionUtils.createDelegatingTransactionAttribute(testContext, transactionAttribute);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Explicit transaction definition [" + transactionAttribute + "] found for test context " + testContext));
            }
            if (transactionAttribute.getPropagationBehavior() == 4) {
                return;
            }
            tm = this.getTransactionManager(testContext, transactionAttribute.getQualifier());
            Assert.state((tm != null ? 1 : 0) != 0, () -> "Failed to retrieve PlatformTransactionManager for @Transactional test: " + testContext);
        }
        if (tm != null) {
            txContext = new TransactionContext(testContext, tm, (TransactionDefinition)transactionAttribute, this.isRollback(testContext));
            this.runBeforeTransactionMethods(testContext);
            txContext.startTransaction();
            TransactionContextHolder.setCurrentTransactionContext(txContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterTestMethod(TestContext testContext) throws Exception {
        Method testMethod = testContext.getTestMethod();
        Assert.notNull((Object)testMethod, (String)"The test method of the supplied TestContext must not be null");
        TransactionContext txContext = TransactionContextHolder.removeCurrentTransactionContext();
        if (txContext != null) {
            TransactionStatus transactionStatus = txContext.getTransactionStatus();
            try {
                if (transactionStatus != null && !transactionStatus.isCompleted()) {
                    txContext.endTransaction();
                }
            }
            finally {
                this.runAfterTransactionMethods(testContext);
            }
        }
    }

    protected void runBeforeTransactionMethods(TestContext testContext) throws Exception {
        try {
            List<Method> methods = this.getAnnotatedMethods(testContext.getTestClass(), BeforeTransaction.class);
            Collections.reverse(methods);
            for (Method method : methods) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing @BeforeTransaction method [" + method + "] for test context " + testContext));
                }
                ReflectionUtils.makeAccessible((Method)method);
                method.invoke(testContext.getTestInstance(), new Object[0]);
            }
        }
        catch (InvocationTargetException ex) {
            if (logger.isErrorEnabled()) {
                logger.error((Object)("Exception encountered while executing @BeforeTransaction methods for test context " + testContext + "."), ex.getTargetException());
            }
            ReflectionUtils.rethrowException((Throwable)ex.getTargetException());
        }
    }

    protected void runAfterTransactionMethods(TestContext testContext) throws Exception {
        Throwable afterTransactionException = null;
        List<Method> methods = this.getAnnotatedMethods(testContext.getTestClass(), AfterTransaction.class);
        for (Method method : methods) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Executing @AfterTransaction method [" + method + "] for test context " + testContext));
                }
                ReflectionUtils.makeAccessible((Method)method);
                method.invoke(testContext.getTestInstance(), new Object[0]);
            }
            catch (InvocationTargetException ex) {
                Throwable targetException = ex.getTargetException();
                if (afterTransactionException == null) {
                    afterTransactionException = targetException;
                }
                logger.error((Object)("Exception encountered while executing @AfterTransaction method [" + method + "] for test context " + testContext), targetException);
            }
            catch (Exception ex) {
                if (afterTransactionException == null) {
                    afterTransactionException = ex;
                }
                logger.error((Object)("Exception encountered while executing @AfterTransaction method [" + method + "] for test context " + testContext), (Throwable)ex);
            }
        }
        if (afterTransactionException != null) {
            ReflectionUtils.rethrowException(afterTransactionException);
        }
    }

    @Nullable
    protected PlatformTransactionManager getTransactionManager(TestContext testContext, @Nullable String qualifier) {
        if (StringUtils.hasText((String)qualifier)) {
            try {
                AutowireCapableBeanFactory bf = testContext.getApplicationContext().getAutowireCapableBeanFactory();
                return (PlatformTransactionManager)BeanFactoryAnnotationUtils.qualifiedBeanOfType((BeanFactory)bf, PlatformTransactionManager.class, (String)qualifier);
            }
            catch (RuntimeException ex) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Object)String.format("Caught exception while retrieving transaction manager with qualifier '%s' for test context %s", qualifier, testContext), (Throwable)ex);
                }
                throw ex;
            }
        }
        return this.getTransactionManager(testContext);
    }

    @Nullable
    protected PlatformTransactionManager getTransactionManager(TestContext testContext) {
        return TestContextTransactionUtils.retrieveTransactionManager(testContext, null);
    }

    protected final boolean isDefaultRollback(TestContext testContext) throws Exception {
        boolean rollbackPresent;
        Class<?> testClass = testContext.getTestClass();
        Rollback rollback = (Rollback)AnnotatedElementUtils.findMergedAnnotation(testClass, Rollback.class);
        boolean bl = rollbackPresent = rollback != null;
        if (rollbackPresent) {
            boolean defaultRollback = rollback.value();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Retrieved default @Rollback(%s) for test class [%s].", defaultRollback, testClass.getName()));
            }
            return defaultRollback;
        }
        return true;
    }

    protected final boolean isRollback(TestContext testContext) throws Exception {
        boolean rollback = this.isDefaultRollback(testContext);
        Rollback rollbackAnnotation = (Rollback)AnnotatedElementUtils.findMergedAnnotation((AnnotatedElement)testContext.getTestMethod(), Rollback.class);
        if (rollbackAnnotation != null) {
            boolean rollbackOverride = rollbackAnnotation.value();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)String.format("Method-level @Rollback(%s) overrides default rollback [%s] for test context %s.", rollbackOverride, rollback, testContext));
            }
            rollback = rollbackOverride;
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)String.format("No method-level @Rollback override: using default rollback [%s] for test context %s.", rollback, testContext));
        }
        return rollback;
    }

    private List<Method> getAnnotatedMethods(Class<?> clazz, Class<? extends Annotation> annotationType) {
        return Arrays.stream(ReflectionUtils.getUniqueDeclaredMethods(clazz, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS)).filter(method -> AnnotatedElementUtils.hasAnnotation((AnnotatedElement)method, (Class)annotationType)).collect(Collectors.toList());
    }
}

