/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.ui.impl;

import java.awt.Toolkit;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.api.java.classpath.GlobalPathRegistry;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.spi.HudsonLogger;
import org.netbeans.modules.hudson.ui.impl.HudsonLoggerHelper;
import org.openide.filesystems.FileObject;
import org.openide.util.RequestProcessor;
import org.openide.windows.OutputEvent;
import org.openide.windows.OutputListener;
import org.openide.windows.OutputWriter;

public class JavaHudsonLogger
implements HudsonLogger {
    private static final Logger LOG = Logger.getLogger(JavaHudsonLogger.class.getName());
    private static final Pattern STACK_TRACE = Pattern.compile("(?:\t|\\[catch\\] )at ((?:[a-zA-Z_$][a-zA-Z0-9_$]*\\.)*)[a-zA-Z_$][a-zA-Z0-9_$]*\\.[a-zA-Z_$<][a-zA-Z0-9_$>]*\\(([a-zA-Z_$][a-zA-Z0-9_$]*\\.java):([0-9]+)\\)");

    public HudsonLogger.HudsonLogSession createSession(HudsonJob job) {
        return new Session();
    }

    private static class Hyperlink
    implements OutputListener {
        private static final RequestProcessor RP = new RequestProcessor(Hyperlink.class);
        private final String resource;
        private final int lineNumber;

        Hyperlink(String resource, int lineNumber) {
            this.resource = resource;
            this.lineNumber = lineNumber;
        }

        public void outputLineAction(OutputEvent ev) {
            this.acted(true);
        }

        public void outputLineSelected(OutputEvent ev) {
            this.acted(false);
        }

        public void outputLineCleared(OutputEvent ev) {
        }

        private void acted(final boolean force) {
            RP.post(new Runnable(){

                @Override
                public void run() {
                    FileObject source = GlobalPathRegistry.getDefault().findResource(resource);
                    if (source != null) {
                        HudsonLoggerHelper.openAt(source, lineNumber - 1, -1, force);
                    } else if (force) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            });
        }
    }

    private static class Session
    implements HudsonLogger.HudsonLogSession {
        private Session() {
        }

        public boolean handle(String line, OutputWriter stream) {
            Matcher m = STACK_TRACE.matcher(line);
            if (!m.matches()) {
                return false;
            }
            String pkg = m.group(1);
            String filename = m.group(2);
            String resource = pkg.replace('.', '/') + filename;
            int lineNumber = Integer.parseInt(m.group(3));
            try {
                stream.println(line, (OutputListener)new Hyperlink(resource, lineNumber));
                return true;
            }
            catch (IOException x) {
                LOG.log(Level.INFO, null, x);
                stream.println(line);
                return true;
            }
        }
    }
}

