/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.js.parser;

import com.oracle.js.parser.Token;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import java.util.Objects;

public final class Source {
    private static final int BUF_SIZE = 8192;
    private final String name;
    private final String base;
    private final Data data;
    private int hash;
    private volatile byte[] digest;
    private String explicitURL;

    private Source(String name, String base, Data data) {
        this.name = name;
        this.base = base;
        this.data = data;
    }

    private static Source sourceFor(String name, String base, URLData data) throws IOException {
        try {
            Source newSource = new Source(name, base, data);
            data.load();
            return newSource;
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw e;
        }
    }

    private String data() {
        return this.data.data();
    }

    public static Source sourceFor(String name, String content, boolean isEval) {
        return new Source(name, Source.baseName(name), new RawData(content, isEval));
    }

    public static Source sourceFor(String name, String content) {
        return Source.sourceFor(name, content, false);
    }

    public static Source sourceFor(String name, URL url) throws IOException {
        return Source.sourceFor(name, url, null);
    }

    public static Source sourceFor(String name, URL url, Charset cs) throws IOException {
        return Source.sourceFor(name, Source.baseURL(url), new URLData(url, cs));
    }

    public static Source sourceFor(String name, File file) throws IOException {
        return Source.sourceFor(name, file, null);
    }

    public static Source sourceFor(String name, Path path) throws IOException {
        File file = null;
        try {
            file = path.toFile();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        if (file != null) {
            return Source.sourceFor(name, file);
        }
        return Source.sourceFor(name, Files.newBufferedReader(path));
    }

    public static Source sourceFor(String name, File file, Charset cs) throws IOException {
        File absFile = file.getAbsoluteFile();
        return Source.sourceFor(name, Source.dirName(absFile, null), new FileData(file, cs));
    }

    public static Source sourceFor(String name, Reader reader) throws IOException {
        return new Source(name, Source.baseName(name), new RawData(reader));
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Source)) {
            return false;
        }
        Source other = (Source)obj;
        return Objects.equals(this.name, other.name) && this.data.equals(other.data);
    }

    public int hashCode() {
        int h = this.hash;
        if (h == 0) {
            h = this.hash = this.data.hashCode() ^ Objects.hashCode(this.name);
        }
        return h;
    }

    public String getString() {
        return this.data.toString();
    }

    public String getName() {
        return this.name;
    }

    public long getLastModified() {
        return this.data.lastModified();
    }

    public String getBase() {
        return this.base;
    }

    public String getString(int start, int len) {
        return this.data().substring(start, start + len);
    }

    public String getString(long token) {
        int start = Token.descPosition(token);
        int len = Token.descLength(token);
        return this.getString(start, len);
    }

    public URL getURL() {
        return this.data.url();
    }

    public String getExplicitURL() {
        return this.explicitURL;
    }

    public void setExplicitURL(String explicitURL) {
        this.explicitURL = explicitURL;
    }

    public boolean isEvalCode() {
        return this.data.isEvalCode();
    }

    private int findBOLN(int position) {
        String d = this.data();
        for (int i = position - 1; i > 0; --i) {
            char ch = d.charAt(i);
            if (ch != '\n' && ch != '\r') continue;
            return i + 1;
        }
        return 0;
    }

    private int findEOLN(int position) {
        String d = this.data();
        int length = d.length();
        for (int i = position; i < length; ++i) {
            char ch = d.charAt(i);
            if (ch != '\n' && ch != '\r') continue;
            return i - 1;
        }
        return length - 1;
    }

    public int getLine(int position) {
        String d = this.data();
        int line = 1;
        for (int i = 0; i < position; ++i) {
            char ch = d.charAt(i);
            if (ch != '\n') continue;
            ++line;
        }
        return line;
    }

    public int getColumn(int position) {
        return position - this.findBOLN(position);
    }

    public String getSourceLine(int position) {
        int first = this.findBOLN(position);
        int last = this.findEOLN(position);
        return this.data().substring(first, last + 1);
    }

    public String getContent() {
        return this.data();
    }

    public int getLength() {
        return this.data.length();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readFully(Reader reader) throws IOException {
        char[] arr = new char[8192];
        StringBuilder sb = new StringBuilder();
        try {
            int numChars;
            while ((numChars = reader.read(arr, 0, arr.length)) > 0) {
                sb.append(arr, 0, numChars);
            }
        }
        finally {
            reader.close();
        }
        return sb.toString();
    }

    public static String readFully(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file + " is not a file");
        }
        return Source.byteArrayToString(Files.readAllBytes(file.toPath()));
    }

    public static String readFully(File file, Charset cs) throws IOException {
        if (!file.isFile()) {
            throw new IOException(file + " is not a file");
        }
        byte[] buf = Files.readAllBytes(file.toPath());
        return cs != null ? new String(buf, cs) : Source.byteArrayToString(buf);
    }

    public static String readFully(URL url) throws IOException {
        return Source.readFully(url.openStream());
    }

    public static String readFully(URL url, Charset cs) throws IOException {
        return Source.readFully(url.openStream(), cs);
    }

    public String getDigest() {
        return new String(this.getDigestBytes(), StandardCharsets.US_ASCII);
    }

    private byte[] getDigestBytes() {
        byte[] ldigest = this.digest;
        if (ldigest == null) {
            String content = this.data();
            byte[] bytes = new byte[content.length() * 2];
            for (int i = 0; i < content.length(); ++i) {
                bytes[i * 2] = (byte)(content.charAt(i) & 0xFF);
                bytes[i * 2 + 1] = (byte)((content.charAt(i) & 0xFF00) >> 8);
            }
            try {
                MessageDigest md = MessageDigest.getInstance("SHA-1");
                if (this.name != null) {
                    md.update(this.name.getBytes(StandardCharsets.UTF_8));
                }
                if (this.base != null) {
                    md.update(this.base.getBytes(StandardCharsets.UTF_8));
                }
                if (this.getURL() != null) {
                    md.update(this.getURL().toString().getBytes(StandardCharsets.UTF_8));
                }
                Base64.Encoder base64 = Base64.getUrlEncoder().withoutPadding();
                this.digest = ldigest = base64.encode(md.digest(bytes));
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
        return ldigest;
    }

    public static String baseURL(URL url) {
        if (url.getProtocol().equals("file")) {
            try {
                Path path = Paths.get(url.toURI());
                Path parent = path.getParent();
                return parent != null ? parent + File.separator : null;
            }
            catch (IOError | SecurityException | URISyntaxException e) {
                return null;
            }
        }
        String path = url.getPath();
        if (path.isEmpty()) {
            return null;
        }
        path = path.substring(0, path.lastIndexOf(47) + 1);
        int port = url.getPort();
        try {
            return new URL(url.getProtocol(), url.getHost(), port, path).toString();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    private static String dirName(File file, String defaultBaseName) {
        String res = file.getParent();
        return res != null ? res + File.separator : defaultBaseName;
    }

    private static String baseName(String name) {
        int idx = name.lastIndexOf(47);
        if (idx == -1) {
            idx = name.lastIndexOf(92);
        }
        return idx != -1 ? name.substring(0, idx + 1) : null;
    }

    public static String readFully(InputStream is, Charset cs) throws IOException {
        return cs != null ? new String(Source.readBytes(is), cs) : Source.readFully(is);
    }

    public static String readFully(InputStream is) throws IOException {
        return Source.byteArrayToString(Source.readBytes(is));
    }

    private static String byteArrayToString(byte[] bytes) {
        Charset cs = StandardCharsets.UTF_8;
        int start = 0;
        if (bytes.length > 1 && bytes[0] == -2 && bytes[1] == -1) {
            start = 2;
            cs = StandardCharsets.UTF_16BE;
        } else if (bytes.length > 1 && bytes[0] == -1 && bytes[1] == -2) {
            if (bytes.length > 3 && bytes[2] == 0 && bytes[3] == 0) {
                start = 4;
                cs = Charset.forName("UTF-32LE");
            } else {
                start = 2;
                cs = StandardCharsets.UTF_16LE;
            }
        } else if (bytes.length > 2 && bytes[0] == -17 && bytes[1] == -69 && bytes[2] == -65) {
            start = 3;
            cs = StandardCharsets.UTF_8;
        } else if (bytes.length > 3 && bytes[0] == 0 && bytes[1] == 0 && bytes[2] == -2 && bytes[3] == -1) {
            start = 4;
            cs = Charset.forName("UTF-32BE");
        }
        return new String(bytes, start, bytes.length - start, cs);
    }

    static byte[] readBytes(InputStream is) throws IOException {
        byte[] arr = new byte[8192];
        try {
            byte[] byArray;
            try (ByteArrayOutputStream buf = new ByteArrayOutputStream();){
                int numBytes;
                while ((numBytes = is.read(arr, 0, arr.length)) > 0) {
                    buf.write(arr, 0, numBytes);
                }
                byArray = buf.toByteArray();
            }
            return byArray;
        }
        finally {
            is.close();
        }
    }

    public String toString() {
        return this.getName();
    }

    private static URL getURLFromFile(File file) {
        try {
            return file.toURI().toURL();
        }
        catch (SecurityException | MalformedURLException ignored) {
            return null;
        }
    }

    private static class FileData
    extends URLData {
        private final File file;

        private FileData(File file, Charset cs) {
            super(Source.getURLFromFile(file), cs);
            this.file = file;
        }

        @Override
        protected void loadMeta() {
            if (this.length == 0 && this.lastModified == 0L) {
                this.length = (int)this.file.length();
                this.lastModified = this.file.lastModified();
            }
        }

        @Override
        protected void load() throws IOException {
            if (this.source == null) {
                this.source = this.cs == null ? Source.readFully(this.file) : Source.readFully(this.file, this.cs);
                this.length = this.source.length();
                this.lastModified = this.file.lastModified();
            }
        }
    }

    private static class URLData
    implements Data {
        private final URL url;
        protected final Charset cs;
        private int hash;
        protected String source;
        protected int length;
        protected long lastModified;

        private URLData(URL url, Charset cs) {
            this.url = Objects.requireNonNull(url);
            this.cs = cs;
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = this.hash = this.url.hashCode();
            }
            return h;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof URLData)) {
                return false;
            }
            URLData otherData = (URLData)other;
            if (this.url.equals(otherData.url)) {
                try {
                    if (this.isDeferred()) {
                        assert (!otherData.isDeferred());
                        this.loadMeta();
                    } else if (otherData.isDeferred()) {
                        otherData.loadMeta();
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                return this.length == otherData.length && this.lastModified == otherData.lastModified;
            }
            return false;
        }

        public String toString() {
            return this.data();
        }

        @Override
        public URL url() {
            return this.url;
        }

        @Override
        public int length() {
            return this.length;
        }

        @Override
        public long lastModified() {
            return this.lastModified;
        }

        @Override
        public String data() {
            assert (!this.isDeferred());
            return this.source;
        }

        @Override
        public boolean isEvalCode() {
            return false;
        }

        boolean isDeferred() {
            return this.source == null;
        }

        protected void load() throws IOException {
            if (this.source == null) {
                URLConnection c = this.url.openConnection();
                try (InputStream in = c.getInputStream();){
                    this.source = this.cs == null ? Source.readFully(in) : Source.readFully(in, this.cs);
                    this.length = this.source.length();
                    this.lastModified = c.getLastModified();
                }
            }
        }

        protected void loadMeta() throws IOException {
            if (this.length == 0 && this.lastModified == 0L) {
                URLConnection c = this.url.openConnection();
                this.length = c.getContentLength();
                this.lastModified = c.getLastModified();
            }
        }
    }

    private static final class RawData
    implements Data {
        private final String source;
        private final boolean evalCode;
        private int hash;

        private RawData(String source, boolean evalCode) {
            this.source = Objects.requireNonNull(source);
            this.evalCode = evalCode;
        }

        private RawData(Reader reader) throws IOException {
            this(Source.readFully(reader), false);
        }

        public int hashCode() {
            int h = this.hash;
            if (h == 0) {
                h = this.hash = this.source.hashCode() ^ (this.evalCode ? 1 : 0);
            }
            return h;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RawData) {
                RawData other = (RawData)obj;
                return this.source.equals(other.source) && this.evalCode == other.evalCode;
            }
            return false;
        }

        public String toString() {
            return this.data();
        }

        @Override
        public URL url() {
            return null;
        }

        @Override
        public int length() {
            return this.source.length();
        }

        @Override
        public long lastModified() {
            return 0L;
        }

        @Override
        public String data() {
            return this.source;
        }

        @Override
        public boolean isEvalCode() {
            return this.evalCode;
        }
    }

    private static interface Data {
        public URL url();

        public int length();

        public long lastModified();

        public String data();

        public boolean isEvalCode();
    }
}

