/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.videobridge.datachannel.protocol;

import java.nio.ByteBuffer;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerImpl;
import org.jitsi.videobridge.datachannel.protocol.DataChannelBinaryMessage;
import org.jitsi.videobridge.datachannel.protocol.DataChannelMessage;
import org.jitsi.videobridge.datachannel.protocol.DataChannelStringMessage;
import org.jitsi.videobridge.datachannel.protocol.OpenChannelAckMessage;
import org.jitsi.videobridge.datachannel.protocol.OpenChannelMessage;

public class DataChannelProtocolMessageParser {
    private static Logger logger = new LoggerImpl(DataChannelProtocolMessageParser.class.getName());

    private static int getMessageType(byte[] data2) {
        return ByteBuffer.wrap(data2).get(0) & 0xFF;
    }

    public static DataChannelMessage parse(byte[] data2, long ppid) {
        if (ppid == 50L) {
            int messageType = DataChannelProtocolMessageParser.getMessageType(data2);
            switch (messageType) {
                case 2: {
                    return new OpenChannelAckMessage();
                }
                case 3: {
                    return OpenChannelMessage.parse(data2);
                }
            }
            logger.warn("Unrecognized datachannel control message type: " + messageType);
            return null;
        }
        if (ppid == 51L) {
            return DataChannelStringMessage.parse(data2);
        }
        if (ppid == 53L) {
            return new DataChannelBinaryMessage(data2);
        }
        logger.warn("Unrecognized data channel ppid: " + ppid);
        return null;
    }
}

