/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls.crypto.impl.bc;

import org.bouncycastle.crypto.Digest;
import org.bouncycastle.tls.crypto.TlsHash;
import org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;

final class BcTlsHash
implements TlsHash {
    private final BcTlsCrypto crypto;
    private final int cryptoHashAlgorithm;
    private final Digest digest;

    BcTlsHash(BcTlsCrypto bcTlsCrypto, int n) {
        this(bcTlsCrypto, n, bcTlsCrypto.createDigest(n));
    }

    private BcTlsHash(BcTlsCrypto bcTlsCrypto, int n, Digest digest) {
        this.crypto = bcTlsCrypto;
        this.cryptoHashAlgorithm = n;
        this.digest = digest;
    }

    public void update(byte[] byArray, int n, int n2) {
        this.digest.update(byArray, n, n2);
    }

    public byte[] calculateHash() {
        byte[] byArray = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(byArray, 0);
        return byArray;
    }

    public TlsHash cloneHash() {
        return new BcTlsHash(this.crypto, this.cryptoHashAlgorithm, this.crypto.cloneDigest(this.cryptoHashAlgorithm, this.digest));
    }

    public void reset() {
        this.digest.reset();
    }
}

