/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.core.utils.exceptions.JadxRuntimeException;
import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.MainWindow;
import jadx.gui.ui.TabComponent;
import jadx.gui.ui.codearea.AbstractCodeArea;
import jadx.gui.ui.codearea.AbstractCodeContentPanel;
import jadx.gui.ui.codearea.ClassCodeContentPanel;
import jadx.gui.ui.codearea.EditorViewState;
import jadx.gui.ui.codearea.SmaliArea;
import jadx.gui.ui.panel.ContentPanel;
import jadx.gui.ui.panel.HtmlPanel;
import jadx.gui.ui.panel.IViewStateSupport;
import jadx.gui.ui.panel.ImagePanel;
import jadx.gui.utils.JumpManager;
import jadx.gui.utils.JumpPosition;
import jadx.gui.utils.NLS;
import java.awt.Component;
import java.awt.KeyEventDispatcher;
import java.awt.KeyboardFocusManager;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TabbedPane
extends JTabbedPane {
    private static final long serialVersionUID = -8833600618794570904L;
    private static final Logger LOG = LoggerFactory.getLogger(TabbedPane.class);
    private final transient MainWindow mainWindow;
    private final transient Map<JNode, ContentPanel> openTabs = new LinkedHashMap<JNode, ContentPanel>();
    private final transient JumpManager jumps = new JumpManager();
    private transient ContentPanel curTab;
    private transient ContentPanel lastTab;

    TabbedPane(MainWindow window) {
        this.mainWindow = window;
        this.setTabLayoutPolicy(1);
        this.addMouseWheelListener(event -> {
            int direction = event.getWheelRotation();
            if (this.openTabs.isEmpty() || direction == 0) {
                return;
            }
            direction = direction < 0 ? -1 : 1;
            int index = this.getSelectedIndex();
            int maxIndex = this.getTabCount() - 1;
            if ((index += direction) < 0) {
                index = maxIndex;
            } else if (index > maxIndex) {
                index = 0;
            }
            try {
                this.setSelectedIndex(index);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        });
        this.interceptTabKey();
        this.interceptCloseKey();
        this.enableSwitchingTabs();
    }

    private void interceptTabKey() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){
            private static final int ctrlDown = 128;
            private long ctrlInterval = 0L;

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                boolean isReleased;
                long cur = System.currentTimeMillis();
                if (!FocusManager.isActive()) {
                    return false;
                }
                int code = e.getKeyCode();
                boolean consume = code == 9;
                boolean bl = isReleased = e.getID() == 402;
                if (isReleased) {
                    if (code == 17) {
                        this.ctrlInterval = cur;
                    } else if (code == 9) {
                        boolean doSwitch = false;
                        if ((e.getModifiersEx() & 0x80) != 0) {
                            doSwitch = TabbedPane.this.lastTab != null && TabbedPane.this.getTabCount() > 1;
                        } else {
                            this.ctrlInterval = cur - this.ctrlInterval;
                            if (this.ctrlInterval <= 90L) {
                                boolean bl2 = doSwitch = TabbedPane.this.lastTab != null && TabbedPane.this.getTabCount() > 1;
                            }
                        }
                        if (doSwitch) {
                            TabbedPane.this.selectTab(TabbedPane.this.lastTab);
                        }
                    }
                } else if (consume && (e.getModifiersEx() & 0x80) == 0 && TabbedPane.this.curTab instanceof ClassCodeContentPanel) {
                    ((ClassCodeContentPanel)TabbedPane.this.curTab).switchPanel();
                }
                return consume;
            }
        });
    }

    private void interceptCloseKey() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new KeyEventDispatcher(){
            private static final int closeKey = 87;
            private boolean canClose = true;

            @Override
            public boolean dispatchKeyEvent(KeyEvent e) {
                if (!FocusManager.isActive()) {
                    return false;
                }
                if (e.getKeyCode() != 87) {
                    return false;
                }
                if (e.getID() == 402) {
                    this.canClose = true;
                    return false;
                }
                if (e.isControlDown() && this.canClose) {
                    TabbedPane.this.closeCodePanel(TabbedPane.this.curTab);
                    this.canClose = false;
                    return true;
                }
                return false;
            }
        });
    }

    private void enableSwitchingTabs() {
        this.addChangeListener(e -> {
            ContentPanel tab = this.getSelectedCodePanel();
            if (tab == null) {
                this.curTab = null;
                this.lastTab = null;
                return;
            }
            FocusManager.focusOnCodePanel(tab);
            if (tab == this.curTab) {
                if (this.lastTab != null && this.indexOfComponent(this.lastTab) == -1) {
                    this.setLastTabAdjacentToCurTab();
                }
                return;
            }
            if (tab == this.lastTab && this.indexOfComponent(this.curTab) == -1) {
                this.curTab = this.lastTab;
                this.setLastTabAdjacentToCurTab();
                return;
            }
            this.lastTab = this.curTab;
            this.curTab = tab;
        });
    }

    private void setLastTabAdjacentToCurTab() {
        if (this.getTabCount() < 2) {
            this.lastTab = null;
            return;
        }
        int idx = this.indexOfComponent(this.curTab);
        this.lastTab = idx == 0 ? (ContentPanel)this.getComponentAt(idx + 1) : (ContentPanel)this.getComponentAt(idx - 1);
    }

    public MainWindow getMainWindow() {
        return this.mainWindow;
    }

    public void codeJump(JNode node) {
        if (node.getPos() != 0 || node.getRootClass() == null) {
            this.codeJump(new JumpPosition(node));
            return;
        }
        this.mainWindow.getBackgroundExecutor().execute(NLS.str("progress.load"), () -> node.getRootClass().getCodeInfo(), status -> this.codeJump(new JumpPosition(node)));
    }

    public void codeJump(JumpPosition pos) {
        this.saveJump(pos);
        this.showCode(pos);
    }

    private void saveJump(JumpPosition pos) {
        JumpPosition curPos = this.getCurrentPosition();
        if (curPos != null) {
            this.jumps.addPosition(curPos);
            this.jumps.addPosition(pos);
        }
    }

    private void showCode(JumpPosition jumpPos) {
        ContentPanel contentPanel = this.getContentPanel(jumpPos.getNode());
        if (contentPanel != null) {
            this.scrollToPos(contentPanel, jumpPos.getPos());
            this.selectTab(contentPanel);
        }
    }

    public boolean showNode(JNode node) {
        ContentPanel contentPanel = this.getContentPanel(node);
        if (contentPanel == null) {
            return false;
        }
        this.selectTab(contentPanel);
        return true;
    }

    private void scrollToPos(ContentPanel contentPanel, int pos) {
        if (pos == 0) {
            LOG.warn("Ignore zero jump!", (Throwable)new JadxRuntimeException(new String[0]));
            return;
        }
        if (contentPanel instanceof AbstractCodeContentPanel) {
            AbstractCodeArea codeArea = ((AbstractCodeContentPanel)contentPanel).getCodeArea();
            codeArea.scrollToPos(pos);
            codeArea.requestFocus();
        }
    }

    public void selectTab(ContentPanel contentPanel) {
        this.setSelectedComponent(contentPanel);
        if (this.mainWindow.getSettings().isAlwaysSelectOpened()) {
            this.mainWindow.syncWithEditor();
        }
    }

    public void smaliJump(JClass cls, int pos, boolean debugMode) {
        ContentPanel panel = this.getOpenTabs().get(cls);
        if (panel == null) {
            this.showCode(new JumpPosition(cls, 1));
            panel = this.getOpenTabs().get(cls);
            if (panel == null) {
                throw new JadxRuntimeException("Failed to open panel for JClass: " + cls);
            }
        } else {
            this.selectTab(panel);
        }
        ClassCodeContentPanel codePane = (ClassCodeContentPanel)panel;
        codePane.showSmaliPane();
        SmaliArea smaliArea = (SmaliArea)codePane.getSmaliCodeArea();
        if (debugMode) {
            smaliArea.scrollToDebugPos(pos);
        }
        smaliArea.scrollToPos(pos);
        smaliArea.requestFocus();
    }

    @Nullable
    public JumpPosition getCurrentPosition() {
        ContentPanel selectedCodePanel = this.getSelectedCodePanel();
        if (selectedCodePanel instanceof AbstractCodeContentPanel) {
            return ((AbstractCodeContentPanel)selectedCodePanel).getCodeArea().getCurrentPosition();
        }
        return null;
    }

    public List<EditorViewState> getEditorViewStates() {
        ArrayList<EditorViewState> states = new ArrayList<EditorViewState>();
        for (ContentPanel panel : this.openTabs.values()) {
            if (panel instanceof IViewStateSupport) {
                states.add(((IViewStateSupport)((Object)panel)).getEditorViewState());
                continue;
            }
            states.add(new EditorViewState(panel.getNode(), "", 0, EditorViewState.ZERO));
        }
        return states;
    }

    public void restoreEditorViewState(EditorViewState viewState) {
        ContentPanel contentPanel = this.getContentPanel(viewState.getNode());
        if (contentPanel instanceof IViewStateSupport) {
            ((IViewStateSupport)((Object)contentPanel)).restoreEditorViewState(viewState);
        }
    }

    public void navBack() {
        JumpPosition pos;
        if (this.jumps.size() > 1) {
            this.jumps.updateCurPosition(this.getCurrentPosition());
        }
        if ((pos = this.jumps.getPrev()) != null) {
            this.showCode(pos);
        }
    }

    public void navForward() {
        JumpPosition pos;
        if (this.jumps.size() > 1) {
            this.jumps.updateCurPosition(this.getCurrentPosition());
        }
        if ((pos = this.jumps.getNext()) != null) {
            this.showCode(pos);
        }
    }

    private void addContentPanel(ContentPanel contentPanel) {
        this.openTabs.put(contentPanel.getNode(), contentPanel);
        this.add(contentPanel);
    }

    public void closeCodePanel(ContentPanel contentPanel) {
        this.openTabs.remove(contentPanel.getNode());
        this.remove(contentPanel);
        contentPanel.dispose();
    }

    @Nullable
    private ContentPanel getContentPanel(JNode node) {
        ContentPanel panel = this.openTabs.get(node);
        if (panel == null) {
            panel = node.getContentPanel(this);
            if (panel == null) {
                return null;
            }
            FocusManager.listen(panel);
            this.addContentPanel(panel);
            this.setTabComponentAt(this.indexOfComponent(panel), this.makeTabComponent(panel));
        }
        return panel;
    }

    public void refresh(JNode node) {
        ContentPanel panel = this.openTabs.get(node);
        if (panel != null) {
            this.setTabComponentAt(this.indexOfComponent(panel), this.makeTabComponent(panel));
            this.fireStateChanged();
        }
    }

    @Nullable
    public ContentPanel getSelectedCodePanel() {
        return (ContentPanel)this.getSelectedComponent();
    }

    private Component makeTabComponent(ContentPanel contentPanel) {
        return new TabComponent(this, contentPanel);
    }

    public void closeAllTabs() {
        ArrayList<ContentPanel> contentPanels = new ArrayList<ContentPanel>(this.openTabs.values());
        for (ContentPanel panel : contentPanels) {
            this.closeCodePanel(panel);
        }
    }

    public Map<JNode, ContentPanel> getOpenTabs() {
        return this.openTabs;
    }

    public void loadSettings() {
        for (ContentPanel panel : this.openTabs.values()) {
            panel.loadSettings();
        }
        int tabCount = this.getTabCount();
        for (int i = 0; i < tabCount; ++i) {
            Component tabComponent = this.getTabComponentAt(i);
            if (!(tabComponent instanceof TabComponent)) continue;
            ((TabComponent)tabComponent).loadSettings();
        }
    }

    public void reset() {
        this.closeAllTabs();
        this.openTabs.clear();
        this.jumps.reset();
        this.curTab = null;
        this.lastTab = null;
        FocusManager.reset();
    }

    @Nullable
    public Component getFocusedComp() {
        return FocusManager.getFocusedComp();
    }

    private static class FocusManager
    implements FocusListener {
        private static final FocusManager INSTANCE = new FocusManager();
        @Nullable
        private static Component focusedComp;

        private FocusManager() {
        }

        static boolean isActive() {
            return focusedComp != null;
        }

        static void reset() {
            focusedComp = null;
        }

        static Component getFocusedComp() {
            return focusedComp;
        }

        @Override
        public void focusGained(FocusEvent e) {
            focusedComp = (Component)e.getSource();
        }

        @Override
        public void focusLost(FocusEvent e) {
            focusedComp = null;
        }

        static void listen(ContentPanel pane) {
            if (pane instanceof ClassCodeContentPanel) {
                ((ClassCodeContentPanel)pane).getCodeArea().addFocusListener(INSTANCE);
                ((ClassCodeContentPanel)pane).getSmaliCodeArea().addFocusListener(INSTANCE);
                return;
            }
            if (pane instanceof AbstractCodeContentPanel) {
                ((AbstractCodeContentPanel)pane).getCodeArea().addFocusListener(INSTANCE);
                return;
            }
            if (pane instanceof HtmlPanel) {
                ((HtmlPanel)pane).getHtmlArea().addFocusListener(INSTANCE);
                return;
            }
            if (pane instanceof ImagePanel) {
                pane.addFocusListener(INSTANCE);
                return;
            }
        }

        static void focusOnCodePanel(ContentPanel pane) {
            if (pane instanceof ClassCodeContentPanel) {
                SwingUtilities.invokeLater(() -> ((ClassCodeContentPanel)pane).getCurrentCodeArea().requestFocus());
                return;
            }
            if (pane instanceof AbstractCodeContentPanel) {
                SwingUtilities.invokeLater(() -> ((AbstractCodeContentPanel)pane).getCodeArea().requestFocus());
                return;
            }
            if (pane instanceof HtmlPanel) {
                SwingUtilities.invokeLater(() -> ((HtmlPanel)pane).getHtmlArea().requestFocusInWindow());
                return;
            }
            if (pane instanceof ImagePanel) {
                SwingUtilities.invokeLater(((ImagePanel)pane)::requestFocusInWindow);
                return;
            }
        }
    }
}

