/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.waitforfile;

import java.io.IOException;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.waitforfile.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryWaitForFile
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String filename;
    private String maximumTimeout;
    private String checkCycleTime;
    private boolean successOnTimeout;
    private boolean fileSizeCheck;
    private boolean addFilenameToResult;
    private static String DEFAULT_MAXIMUM_TIMEOUT = "0";
    private static String DEFAULT_CHECK_CYCLE_TIME = "60";

    public JobEntryWaitForFile(String n) {
        super(n, "");
        this.filename = null;
        this.maximumTimeout = DEFAULT_MAXIMUM_TIMEOUT;
        this.checkCycleTime = DEFAULT_CHECK_CYCLE_TIME;
        this.successOnTimeout = false;
        this.fileSizeCheck = false;
        this.addFilenameToResult = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.WAIT_FOR_FILE);
    }

    public JobEntryWaitForFile() {
        this("");
    }

    public JobEntryWaitForFile(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryWaitForFile je = (JobEntryWaitForFile)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"filename", (String)this.filename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"maximum_timeout", (String)this.maximumTimeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"check_cycle_time", (String)this.checkCycleTime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_on_timeout", (boolean)this.successOnTimeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"file_size_check", (boolean)this.fileSizeCheck));
        retval.append("      ").append(XMLHandler.addTagValue((String)"add_filename_result", (boolean)this.addFilenameToResult));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.filename = XMLHandler.getTagValue((Node)entrynode, (String)"filename");
            this.maximumTimeout = XMLHandler.getTagValue((Node)entrynode, (String)"maximum_timeout");
            this.checkCycleTime = XMLHandler.getTagValue((Node)entrynode, (String)"check_cycle_time");
            this.successOnTimeout = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"success_on_timeout"));
            this.fileSizeCheck = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"file_size_check"));
            this.addFilenameToResult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"add_filename_result"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'wait for file' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.filename = rep.getJobEntryAttributeString(id_jobentry, "filename");
            this.maximumTimeout = rep.getJobEntryAttributeString(id_jobentry, "maximum_timeout");
            this.checkCycleTime = rep.getJobEntryAttributeString(id_jobentry, "check_cycle_time");
            this.successOnTimeout = rep.getJobEntryAttributeBoolean(id_jobentry, "success_on_timeout");
            this.fileSizeCheck = rep.getJobEntryAttributeBoolean(id_jobentry, "file_size_check");
            this.addFilenameToResult = rep.getJobEntryAttributeBoolean(id_jobentry, "add_filename_result");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'wait for file' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "filename", this.filename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "maximum_timeout", this.maximumTimeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "check_cycle_time", this.checkCycleTime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_on_timeout", this.successOnTimeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "file_size_check", this.fileSizeCheck);
            rep.saveJobEntryAttribute(id_job, this.getID(), "add_filename_result", this.addFilenameToResult);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'wait for file' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Override
    public String getFilename() {
        return this.filename;
    }

    @Override
    public String getRealFilename() {
        return this.environmentSubstitute(this.getFilename());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        LogWriter log = LogWriter.getInstance();
        Result result = previousResult;
        result.setResult(false);
        long timeStart = System.currentTimeMillis() / 1000L;
        if (this.filename != null) {
            String realFilename;
            FileObject fileObject;
            block36: {
                fileObject = null;
                realFilename = this.getRealFilename();
                fileObject = KettleVFS.getFileObject((String)realFilename);
                long iMaximumTimeout = Const.toInt((String)this.getRealMaximumTimeout(), (int)Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0));
                long iCycleTime = Const.toInt((String)this.getRealCheckCycleTime(), (int)Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)0));
                if (iMaximumTimeout < 0L) {
                    iMaximumTimeout = Const.toInt((String)DEFAULT_MAXIMUM_TIMEOUT, (int)0);
                    if (log.isBasic()) {
                        log.logBasic(this.toString(), "Maximum timeout invalid, reset to " + iMaximumTimeout, new Object[0]);
                    }
                }
                if (iCycleTime < 1L) {
                    iCycleTime = Const.toInt((String)DEFAULT_CHECK_CYCLE_TIME, (int)1);
                    if (log.isBasic()) {
                        log.logBasic(this.toString(), "Check cycle time invalid, reset to " + iCycleTime, new Object[0]);
                    }
                }
                if (iMaximumTimeout == 0L) {
                    if (log.isBasic()) {
                        log.logBasic(this.toString(), "Waiting indefinitely for file [" + realFilename + "]", new Object[0]);
                    }
                } else if (log.isBasic()) {
                    log.logBasic(this.toString(), "Waiting " + iMaximumTimeout + " seconds for file [" + realFilename + "]", new Object[0]);
                }
                boolean continueLoop = true;
                while (continueLoop && !parentJob.isStopped()) {
                    fileObject = KettleVFS.getFileObject((String)realFilename);
                    if (fileObject.exists()) {
                        if (log.isBasic()) {
                            log.logBasic(this.toString(), "Detected file [" + realFilename + "] within timeout", new Object[0]);
                        }
                        result.setResult(true);
                        continueLoop = false;
                        if (!this.addFilenameToResult || fileObject.getType() != FileType.FILE) continue;
                        ResultFile resultFile = new ResultFile(0, fileObject, parentJob.getJobname(), this.toString());
                        resultFile.setComment(Messages.getString("JobWaitForFile.FilenameAdded"));
                        result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
                        continue;
                    }
                    long now = System.currentTimeMillis() / 1000L;
                    if (iMaximumTimeout > 0L && now > timeStart + iMaximumTimeout) {
                        continueLoop = false;
                        if (this.isSuccessOnTimeout()) {
                            if (log.isBasic()) {
                                log.logBasic(this.toString(), "Didn't detect file [" + realFilename + "] before timeout, success", new Object[0]);
                            }
                            result.setResult(true);
                        } else {
                            if (log.isBasic()) {
                                log.logBasic(this.toString(), "Didn't detect file [" + realFilename + "] before timeout, failure", new Object[0]);
                            }
                            result.setResult(false);
                        }
                    }
                    long sleepTime = 0L;
                    sleepTime = iMaximumTimeout == 0L ? iCycleTime : (now + iCycleTime < timeStart + iMaximumTimeout ? iCycleTime : iCycleTime - (now + iCycleTime - (timeStart + iMaximumTimeout)));
                    try {
                        if (sleepTime <= 0L) continue;
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), "Sleeping " + sleepTime + " seconds before next check for file [" + realFilename + "]", new Object[0]);
                        }
                        Thread.sleep(sleepTime * 1000L);
                    }
                    catch (InterruptedException e) {
                        result.setResult(false);
                        continueLoop = false;
                    }
                }
                if (!parentJob.isStopped() && fileObject.exists() && this.isFileSizeCheck()) {
                    long oldSize = -1L;
                    long newSize = fileObject.getContent().getSize();
                    if (log.isDetailed()) {
                        log.logDetailed(this.toString(), "File [" + realFilename + "] is " + newSize + " bytes long", new Object[0]);
                    }
                    if (log.isBasic()) {
                        log.logBasic(this.toString(), "Waiting until file [" + realFilename + "] stops growing for " + iCycleTime + " seconds", new Object[0]);
                    }
                    while (oldSize != newSize && !parentJob.isStopped()) {
                        try {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), "Sleeping " + iCycleTime + " seconds, waiting for file [" + realFilename + "] to stop growing", new Object[0]);
                            }
                            Thread.sleep(iCycleTime * 1000L);
                        }
                        catch (InterruptedException e) {
                            result.setResult(false);
                            continueLoop = false;
                        }
                        oldSize = newSize;
                        newSize = fileObject.getContent().getSize();
                        if (!log.isDetailed()) continue;
                        log.logDetailed(this.toString(), "File [" + realFilename + "] is " + newSize + " bytes long", new Object[0]);
                    }
                    if (log.isBasic()) {
                        log.logBasic(this.toString(), "Stopped waiting for file [" + realFilename + "] to stop growing", new Object[0]);
                    }
                }
                if (!parentJob.isStopped()) break block36;
                result.setResult(false);
            }
            Object var22_21 = null;
            if (fileObject == null) return result;
            try {
                fileObject.close();
                return result;
            }
            catch (Exception e2) {}
            return result;
            {
                catch (IOException e) {
                    log.logBasic(this.toString(), "Exception while waiting for file [" + realFilename + "] to stop growing: " + e.getMessage(), new Object[0]);
                    Object var22_22 = null;
                    if (fileObject == null) return result;
                    try {
                        fileObject.close();
                        return result;
                    }
                    catch (Exception e2) {}
                    return result;
                }
            }
            catch (Throwable throwable) {
                Object var22_23 = null;
                if (fileObject == null) throw throwable;
                try {
                    fileObject.close();
                    throw throwable;
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        log.logError(this.toString(), "No filename is defined.", new Object[0]);
        return result;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public boolean isSuccessOnTimeout() {
        return this.successOnTimeout;
    }

    public void setSuccessOnTimeout(boolean successOnTimeout) {
        this.successOnTimeout = successOnTimeout;
    }

    public String getCheckCycleTime() {
        return this.checkCycleTime;
    }

    public String getRealCheckCycleTime() {
        return this.environmentSubstitute(this.getCheckCycleTime());
    }

    public void setCheckCycleTime(String checkCycleTime) {
        this.checkCycleTime = checkCycleTime;
    }

    public String getMaximumTimeout() {
        return this.maximumTimeout;
    }

    public String getRealMaximumTimeout() {
        return this.environmentSubstitute(this.getMaximumTimeout());
    }

    public void setMaximumTimeout(String maximumTimeout) {
        this.maximumTimeout = maximumTimeout;
    }

    public boolean isFileSizeCheck() {
        return this.fileSizeCheck;
    }

    public void setFileSizeCheck(boolean fileSizeCheck) {
        this.fileSizeCheck = fileSizeCheck;
    }

    public boolean isAddFilenameToResult() {
        return this.addFilenameToResult;
    }

    public void setAddFilenameToResult(boolean addFilenameToResult) {
        this.addFilenameToResult = addFilenameToResult;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.filename)) {
            String realFileName = jobMeta.environmentSubstitute(this.filename);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realFileName, ResourceEntry.ResourceType.FILE));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "filename", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "maximumTimeout", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "checkCycleTime", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

