/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.channel.Channel;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.QueryStringDecoder;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.traccar.BaseHttpProtocolDecoder;
import org.traccar.Protocol;
import org.traccar.helper.Parser;
import org.traccar.helper.PatternBuilder;
import org.traccar.model.CellTower;
import org.traccar.model.Network;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class VltProtocolDecoder
extends BaseHttpProtocolDecoder {
    private static final Pattern PATTERN = new PatternBuilder().number("(dd)").expression("([HL])").number("([01])").number("(dd)(dd)(dd)").number("(dd)(dd)(dd)").number("(d{3}.d{6})([NS])").number("(d{3}.d{6})([EW])").number("(d{3})").expression("(x*[0-9]+)").number("(x{4})").number("(d{9})").number("(d{3}.d{2})").number("(d{3}.d{2})").number("(d{2})").number("(d{2})").number("(d{2})").number("([01])").number("([01])").expression("([HMS])").compile();

    public VltProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private Position decodePosition(DeviceSession deviceSession, String sentence) {
        Parser parser = new Parser(PATTERN, sentence);
        if (!parser.matches()) {
            return null;
        }
        Position position = new Position(this.getProtocolName());
        position.setDeviceId(deviceSession.getDeviceId());
        position.set("event", parser.nextInt());
        position.set("archive", parser.next().equals("H") ? Boolean.valueOf(true) : null);
        position.setValid(parser.nextInt() > 0);
        position.setTime(parser.nextDateTime(Parser.DateTimeFormat.DMY_HMS));
        position.setLatitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        position.setLongitude(parser.nextCoordinate(Parser.CoordinateFormat.DEG_HEM));
        int mcc = parser.nextInt();
        int mnc = Integer.parseInt(parser.next().replaceAll("x", ""));
        int lac = parser.nextHexInt();
        int cid = parser.nextInt();
        position.setSpeed(parser.nextDouble());
        position.setCourse(parser.nextDouble());
        position.set("sat", parser.nextInt());
        position.set("hdop", parser.nextInt());
        position.setNetwork(new Network(CellTower.from(mcc, mnc, lac, cid, parser.nextInt())));
        position.set("ignition", parser.nextInt() > 0);
        position.set("charge", parser.nextInt() > 0);
        position.set("motion", parser.next().equals("M"));
        return position;
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        FullHttpRequest request = (FullHttpRequest)msg;
        QueryStringDecoder decoder = new QueryStringDecoder(request.content().toString(StandardCharsets.US_ASCII), false);
        String sentence = (String)((List)decoder.parameters().get("vltdata")).iterator().next();
        int index = 0;
        String type = sentence.substring(index, index += 3);
        String imei = sentence.substring(index, index += 15);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            this.sendResponse(channel, HttpResponseStatus.BAD_REQUEST);
            return null;
        }
        this.sendResponse(channel, HttpResponseStatus.OK);
        switch (type) {
            case "NRM": {
                return this.decodePosition(deviceSession, sentence.substring(18));
            }
            case "BTH": {
                LinkedList<Position> positions = new LinkedList<Position>();
                int count = Integer.parseInt(sentence.substring(index, index += 3));
                for (int i = 0; i < count; ++i) {
                    positions.add(this.decodePosition(deviceSession, sentence.substring(index, index += 78)));
                }
                return positions;
            }
        }
        return null;
    }
}

