/*
 * Decompiled with CFR 0.152.
 */
package org.traccar.protocol;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.util.Date;
import org.traccar.BaseProtocolDecoder;
import org.traccar.NetworkMessage;
import org.traccar.Protocol;
import org.traccar.helper.BitUtil;
import org.traccar.helper.DateBuilder;
import org.traccar.helper.UnitsConverter;
import org.traccar.model.Position;
import org.traccar.session.DeviceSession;

public class FlexibleReportProtocolDecoder
extends BaseProtocolDecoder {
    public static final int MSG_GENERAL = 0;

    public FlexibleReportProtocolDecoder(Protocol protocol) {
        super(protocol);
    }

    private void sendResponse(Channel channel, SocketAddress remoteAddress, int index) {
        if (channel != null) {
            ByteBuf response = Unpooled.buffer();
            response.writeByte(126);
            response.writeShort(2);
            response.writeByte(224);
            response.writeByte(BitUtil.check(index, 0) ? 79 : 15);
            channel.writeAndFlush((Object)new NetworkMessage(response, remoteAddress));
        }
    }

    private Date decodeTime(ByteBuf buf) {
        int timestamp = buf.readInt();
        return new DateBuilder().setSecond(timestamp % 60).setMinute(timestamp / 60 % 60).setHour(timestamp / 3600 % 24).setDay(1 + timestamp / 86400 % 31).setMonth(1 + timestamp / 2678400 % 12).setYear(2000 + timestamp / 32140800).getDate();
    }

    @Override
    protected Object decode(Channel channel, SocketAddress remoteAddress, Object msg) throws Exception {
        ByteBuf buf = (ByteBuf)msg;
        buf.readUnsignedByte();
        short flags = buf.readUnsignedByte();
        String imei = ByteBufUtil.hexDump((ByteBuf)buf.readSlice(8)).substring(1);
        DeviceSession deviceSession = this.getDeviceSession(channel, remoteAddress, imei);
        if (deviceSession == null) {
            return null;
        }
        int index = buf.readUnsignedShort();
        if (BitUtil.to(flags, 2) > 0) {
            this.sendResponse(channel, remoteAddress, index);
        }
        Date time = this.decodeTime(buf);
        short event = buf.readUnsignedByte();
        buf.readUnsignedByte();
        short type = buf.readUnsignedByte();
        if (type == 0) {
            Position position = new Position(this.getProtocolName());
            position.setDeviceId(deviceSession.getDeviceId());
            position.setDeviceTime(time);
            position.set("event", Integer.valueOf(event));
            buf.readUnsignedByte();
            long mask = buf.readUnsignedInt();
            if (BitUtil.check(mask, 0)) {
                buf.readUnsignedByte();
            }
            if (BitUtil.check(mask, 1)) {
                position.setFixTime(this.decodeTime(buf));
            }
            if (BitUtil.check(mask, 2)) {
                position.setValid(true);
                position.setLatitude((double)buf.readUnsignedInt() / 1000000.0 - 90.0);
                position.setLongitude((double)buf.readUnsignedInt() / 1000000.0 - 180.0);
            }
            if (BitUtil.check(mask, 3)) {
                position.setSpeed(UnitsConverter.knotsFromKph(buf.readUnsignedByte()));
                position.setCourse(buf.readUnsignedShort());
            }
            if (BitUtil.check(mask, 4)) {
                position.setAltitude(buf.readShort());
            }
            if (BitUtil.check(mask, 5)) {
                buf.readUnsignedShort();
            }
            if (BitUtil.check(mask, 6)) {
                position.set("power", (double)buf.readUnsignedShort() * 0.001);
            }
            if (BitUtil.check(mask, 7)) {
                position.set("battery", (double)buf.readUnsignedShort() * 0.001);
            }
            if (BitUtil.check(mask, 8)) {
                position.set("auxPower", (double)buf.readUnsignedShort() * 0.001);
            }
            if (BitUtil.check(mask, 9)) {
                position.set("solarPower", (double)buf.readUnsignedShort() * 0.001);
            }
            if (BitUtil.check(mask, 10)) {
                short cellService = buf.readUnsignedByte();
                position.set("roaming", BitUtil.check(cellService, 7));
                position.set("service", BitUtil.to(cellService, 7));
                buf.skipBytes(4);
            }
            if (BitUtil.check(mask, 11)) {
                buf.readUnsignedByte();
            }
            if (BitUtil.check(mask, 12)) {
                short inputs = buf.readUnsignedByte();
                position.set("ignition", BitUtil.check(inputs, 0));
                position.set("io1", Integer.valueOf(inputs));
            }
            if (BitUtil.check(mask, 13)) {
                position.set("io2", buf.readUnsignedByte());
            }
            if (BitUtil.check(mask, 14)) {
                position.set("odometer", buf.readUnsignedInt() * 1000L);
            }
            if (BitUtil.check(mask, 15)) {
                position.set("temp1", (double)buf.readUnsignedShort() * 0.01);
            }
            return position;
        }
        return null;
    }
}

