/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.fasttrack;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.mpxj.TimeUnit;
import net.sf.mpxj.fasttrack.FastTrackColumn;
import net.sf.mpxj.fasttrack.FastTrackData;
import net.sf.mpxj.fasttrack.FastTrackField;
import net.sf.mpxj.fasttrack.FastTrackTableType;
import net.sf.mpxj.fasttrack.MapRow;

class FastTrackTable
implements Iterable<MapRow> {
    private final FastTrackData m_data;
    private final FastTrackTableType m_type;
    private final ArrayList<MapRow> m_rows = new ArrayList();

    public FastTrackTable(FastTrackTableType fastTrackTableType, FastTrackData fastTrackData) {
        this.m_data = fastTrackData;
        this.m_type = fastTrackTableType;
    }

    public FastTrackTableType getType() {
        return this.m_type;
    }

    public TimeUnit getDurationTimeUnit() {
        return this.m_data.getDurationTimeUnit();
    }

    public TimeUnit getWorkTimeUnit() {
        return this.m_data.getWorkTimeUnit();
    }

    public void addColumn(FastTrackColumn fastTrackColumn) {
        FastTrackField fastTrackField = fastTrackColumn.getType();
        Object[] objectArray = fastTrackColumn.getData();
        for (int i = 0; i < objectArray.length; ++i) {
            MapRow mapRow = this.getRow(i);
            mapRow.getMap().put(fastTrackField, objectArray[i]);
        }
    }

    @Override
    public Iterator<MapRow> iterator() {
        return this.m_rows.iterator();
    }

    private MapRow getRow(int n) {
        MapRow mapRow;
        if (n == this.m_rows.size()) {
            mapRow = new MapRow(this, new HashMap<FastTrackField, Object>());
            this.m_rows.add(mapRow);
        } else {
            mapRow = this.m_rows.get(n);
        }
        return mapRow;
    }
}

