/*
 * Decompiled with CFR 0.152.
 */
package org.lwjgl.test.mapped;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.lwjgl.MemoryUtil;
import org.lwjgl.test.mapped.MappedVec3;
import org.lwjgl.util.mapped.MappedHelper;

public class MappedObjectBench {
    static void benchmarkInstances() {
        int runs = 64;
        int iterations = 65536;
        InstanceVec3 vec1 = new InstanceVec3();
        InstanceVec3 vec2 = new InstanceVec3();
        InstanceVec3 vec3 = new InstanceVec3();
        long[] took = new long[64];
        for (int run = 0; run < 64; ++run) {
            long t0 = System.nanoTime();
            for (int iteration = 0; iteration < 65536; ++iteration) {
                vec1.x = 13.0f;
                vec1.y += vec1.y * vec1.x + 0.3f;
                vec1.z += vec2.y + vec1.x + 0.3f;
                vec2.z += vec2.y + vec1.x;
                vec3.z += vec2.z + vec1.y;
            }
            long t1 = System.nanoTime();
            took[run] = t1 - t0;
        }
        Arrays.sort(took);
        System.out.println("instance took: " + took[took.length / 2] / 1024L + "us");
        System.out.println(vec1);
        System.out.println(vec2);
        System.out.println(vec3);
    }

    static void benchmarkMapped() {
        int runs = 64;
        int iterations = 65536;
        ByteBuffer bb = ByteBuffer.allocateDirect(200);
        MappedVec3 vecs = (MappedVec3)MappedVec3.map((ByteBuffer)bb);
        MappedVec3 vec1 = (MappedVec3)vecs.dup();
        MappedVec3 vec2 = (MappedVec3)vecs.dup();
        MappedVec3 vec3 = (MappedVec3)vecs.dup();
        vec1.view = 0;
        vec2.view = 1;
        vec3.view = 2;
        long[] took = new long[64];
        for (int run = 0; run < 64; ++run) {
            long t0 = System.nanoTime();
            for (int iteration = 0; iteration < 65536; iteration += 2) {
                vec1.x = 13.0f;
                vec1.y += vec1.y * vec1.x + 0.3f;
                vec1.z += vec2.y + vec1.x + 0.3f;
                vec2.z += vec2.y + vec1.x;
                vec3.z += vec2.z + vec1.y;
                vec1.x = 13.0f;
                vec1.y += vec1.y * vec1.x + 0.3f;
                vec1.z += vec2.y + vec1.x + 0.3f;
                vec2.z += vec2.y + vec1.x;
                vec3.z += vec2.z + vec1.y;
            }
            long t1 = System.nanoTime();
            took[run] = t1 - t0;
        }
        Arrays.sort(took);
        System.out.println("mapped took: " + took[took.length / 2] / 1024L + "us");
        System.out.println((Object)vec1);
        System.out.println((Object)vec2);
        System.out.println((Object)vec3);
        System.out.println(bb);
    }

    static void benchmarkIndirectArray() {
        int runs = 64;
        int iterations = 65536;
        float[] bb = new float[200];
        ArrayVec3 vec1 = new ArrayVec3();
        ArrayVec3 vec2 = new ArrayVec3();
        ArrayVec3 vec3 = new ArrayVec3();
        vec1.a = bb;
        vec2.a = bb;
        vec3.a = bb;
        vec1.i = 0;
        vec2.i = 1;
        vec3.i = 2;
        long[] took = new long[64];
        for (int run = 0; run < 64; ++run) {
            long t0 = System.nanoTime();
            for (int iteration = 0; iteration < 65536; ++iteration) {
                vec1.a[vec1.i * 3 + 0] = 13.0f;
                int n = vec1.i * 3 + 1;
                vec1.a[n] = vec1.a[n] + (vec1.a[vec1.i * 3 + 1] * vec1.a[vec1.i * 3 + 0] + 0.3f);
                int n2 = vec1.i * 3 + 2;
                vec1.a[n2] = vec1.a[n2] + (vec2.a[vec2.i * 3 + 1] + vec1.a[vec1.i * 3 + 0] + 0.3f);
                int n3 = vec2.i * 3 + 2;
                vec2.a[n3] = vec2.a[n3] + (vec2.a[vec2.i * 3 + 1] + vec1.a[vec1.i * 3 + 0]);
                int n4 = vec3.i * 3 + 2;
                vec3.a[n4] = vec3.a[n4] + (vec2.a[vec2.i * 3 + 2] + vec2.a[vec2.i * 3 + 1]);
            }
            long t1 = System.nanoTime();
            took[run] = t1 - t0;
        }
        Arrays.sort(took);
        System.out.println("array took: " + took[took.length / 2] / 1024L + "us");
        System.out.println(vec1);
        System.out.println(vec2);
        System.out.println(vec3);
        System.out.println(bb);
    }

    static void benchmarkDirectArray() {
        int runs = 64;
        int iterations = 65536;
        float[] bb = new float[200];
        long[] took = new long[64];
        for (int run = 0; run < 64; ++run) {
            long t0 = System.nanoTime();
            for (int iteration = 0; iteration < 65536; ++iteration) {
                bb[3] = 13.0f;
                bb[4] = bb[4] + (bb[4] * bb[3] + 0.3f);
                bb[5] = bb[5] + (bb[7] + bb[3] + 0.3f);
                bb[8] = bb[8] + (bb[7] + bb[3]);
                bb[11] = bb[11] + (bb[8] + bb[7]);
            }
            long t1 = System.nanoTime();
            took[run] = t1 - t0;
        }
        Arrays.sort(took);
        System.out.println("array2 took: " + took[took.length / 2] / 1024L + "us");
        System.out.println(bb);
    }

    static void benchmarkUnsafe() {
        int runs = 64;
        int iterations = 65536;
        ByteBuffer bb = ByteBuffer.allocateDirect(200);
        long addr = MemoryUtil.getAddress((ByteBuffer)bb);
        long[] took = new long[64];
        for (int run = 0; run < 64; ++run) {
            long t0 = System.nanoTime();
            for (int iteration = 0; iteration < 65536; ++iteration) {
                MappedHelper.fput((float)13.0f, (long)(addr + 12L));
                MappedHelper.fput((float)(MappedHelper.fget((long)(addr + 16L)) + MappedHelper.fget((long)(addr + 16L)) * MappedHelper.fget((long)(addr + 12L)) + 0.3f), (long)(addr + 16L));
                MappedHelper.fput((float)(MappedHelper.fget((long)(addr + 20L)) + MappedHelper.fget((long)(addr + 28L)) + MappedHelper.fget((long)(addr + 12L)) + 0.3f), (long)(addr + 20L));
                MappedHelper.fput((float)(MappedHelper.fget((long)(addr + 32L)) + MappedHelper.fget((long)(addr + 28L)) + MappedHelper.fget((long)(addr + 12L))), (long)(addr + 32L));
                MappedHelper.fput((float)(MappedHelper.fget((long)(addr + 44L)) + MappedHelper.fget((long)(addr + 32L)) + MappedHelper.fget((long)(addr + 28L))), (long)(addr + 44L));
            }
            long t1 = System.nanoTime();
            took[run] = t1 - t0;
        }
        Arrays.sort(took);
        System.out.println("unsafe took: " + took[took.length / 2] / 1024L + "us");
        System.out.println(bb);
    }

    static class ArrayVec3 {
        float[] a;
        int i;

        ArrayVec3() {
        }

        public String toString() {
            return "ArrayVec3[" + this.a[this.i * 3 + 0] + ", " + this.a[this.i * 3 + 1] + ", " + this.a[this.i * 3 + 2] + "]";
        }
    }

    static class InstanceVec3 {
        float x;
        float y;
        float z;

        InstanceVec3() {
        }

        public String toString() {
            return "InstanceVec3[" + this.x + ", " + this.y + ", " + this.z + "]";
        }
    }
}

