/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.rtp;

import org.jitsi.rtp.util.BufferPool;
import org.jitsi.utils.ByteArrayBuffer;

public abstract class ByteArrayBufferImpl
implements ByteArrayBuffer {
    public byte[] buffer;
    public int offset;
    public int length;

    public ByteArrayBufferImpl(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public ByteArrayBufferImpl() {
        this.buffer = new byte[0];
        this.offset = 0;
        this.length = 0;
    }

    @Override
    public byte[] getBuffer() {
        return this.buffer;
    }

    @Override
    public int getOffset() {
        return this.offset;
    }

    @Override
    public void setOffset(int offset) {
        this.offset = offset;
    }

    @Override
    public int getLength() {
        return this.length;
    }

    @Override
    public void setLength(int length) {
        this.length = length;
    }

    public void setOffsetLength(int offset, int length) {
        this.offset = offset;
        this.length = length;
    }

    @Override
    public void readRegionToBuff(int off, int len, byte[] outBuff) {
        int startOffset = this.offset + off;
        if (off < 0 || len <= 0 || startOffset + len > this.buffer.length) {
            return;
        }
        if (outBuff.length < len) {
            return;
        }
        System.arraycopy(this.buffer, startOffset, outBuff, 0, len);
    }

    @Override
    public void append(byte[] data2, int len) {
        if (data2 == null || len == 0) {
            return;
        }
        this.grow(len);
        System.arraycopy(data2, 0, this.buffer, this.length + this.offset, len);
        this.length += len;
    }

    @Override
    public void grow(int howMuch) {
        if (howMuch < 0) {
            throw new IllegalArgumentException("howMuch: " + howMuch);
        }
        int newLength = this.length + howMuch;
        if (newLength > this.buffer.length - this.offset) {
            byte[] newBuffer = BufferPool.Companion.getGetArray().invoke(newLength);
            System.arraycopy(this.buffer, this.offset, newBuffer, 0, this.length);
            this.offset = 0;
            byte[] oldBuffer = this.buffer;
            this.setBuffer(newBuffer);
            BufferPool.Companion.getReturnArray().invoke(oldBuffer);
        }
    }

    @Override
    public void shrink(int len) {
        if (len <= 0) {
            return;
        }
        this.length -= len;
        if (this.length < 0) {
            this.length = 0;
        }
    }

    public void setBuffer(byte[] buffer) {
        this.buffer = buffer;
    }

    @Override
    public boolean isInvalid() {
        return false;
    }
}

