/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.regions.conditions;

import jadx.core.dex.attributes.AttrNode;
import jadx.core.dex.instructions.ArithNode;
import jadx.core.dex.instructions.ArithOp;
import jadx.core.dex.instructions.IfNode;
import jadx.core.dex.instructions.IfOp;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.LiteralArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.regions.conditions.Compare;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.exceptions.JadxRuntimeException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public final class IfCondition
extends AttrNode {
    private final Mode mode;
    private final List<IfCondition> args;
    private final Compare compare;

    private IfCondition(Compare compare) {
        this.mode = Mode.COMPARE;
        this.compare = compare;
        this.args = Collections.emptyList();
    }

    private IfCondition(Mode mode, List<IfCondition> args) {
        this.mode = mode;
        this.args = args;
        this.compare = null;
    }

    private IfCondition(IfCondition c) {
        this.mode = c.mode;
        this.compare = c.compare;
        this.args = c.mode == Mode.COMPARE ? Collections.emptyList() : new ArrayList<IfCondition>(c.args);
    }

    public static IfCondition fromIfBlock(BlockNode header) {
        InsnNode lastInsn = BlockUtils.getLastInsn(header);
        if (lastInsn == null) {
            return null;
        }
        return IfCondition.fromIfNode((IfNode)lastInsn);
    }

    public static IfCondition fromIfNode(IfNode insn) {
        return new IfCondition(new Compare(insn));
    }

    public static IfCondition ternary(IfCondition a, IfCondition b, IfCondition c) {
        return new IfCondition(Mode.TERNARY, Arrays.asList(a, b, c));
    }

    public static IfCondition merge(Mode mode, IfCondition a, IfCondition b) {
        if (a.getMode() == mode) {
            IfCondition n = new IfCondition(a);
            n.addArg(b);
            return n;
        }
        return new IfCondition(mode, Arrays.asList(a, b));
    }

    public Mode getMode() {
        return this.mode;
    }

    public List<IfCondition> getArgs() {
        return this.args;
    }

    public IfCondition first() {
        return this.args.get(0);
    }

    public IfCondition second() {
        return this.args.get(1);
    }

    public IfCondition third() {
        return this.args.get(2);
    }

    public void addArg(IfCondition c) {
        this.args.add(c);
    }

    public boolean isCompare() {
        return this.mode == Mode.COMPARE;
    }

    public Compare getCompare() {
        return this.compare;
    }

    public static IfCondition invert(IfCondition cond) {
        Mode mode = cond.getMode();
        switch (mode) {
            case COMPARE: {
                return new IfCondition(cond.getCompare().invert());
            }
            case TERNARY: {
                return IfCondition.ternary(cond.first(), IfCondition.not(cond.second()), IfCondition.not(cond.third()));
            }
            case NOT: {
                return cond.first();
            }
            case AND: 
            case OR: {
                List<IfCondition> args = cond.getArgs();
                ArrayList<IfCondition> newArgs = new ArrayList<IfCondition>(args.size());
                for (IfCondition arg : args) {
                    newArgs.add(IfCondition.invert(arg));
                }
                return new IfCondition(mode == Mode.AND ? Mode.OR : Mode.AND, newArgs);
            }
        }
        throw new JadxRuntimeException("Unknown mode for invert: " + (Object)((Object)mode));
    }

    public static IfCondition not(IfCondition cond) {
        if (cond.getMode() == Mode.NOT) {
            return cond.first();
        }
        if (cond.getCompare() != null) {
            return new IfCondition(cond.compare.invert());
        }
        return new IfCondition(Mode.NOT, Collections.singletonList(cond));
    }

    public static IfCondition simplify(IfCondition cond) {
        int count;
        if (cond.isCompare()) {
            Compare c = cond.getCompare();
            IfCondition i = IfCondition.simplifyCmpOp(c);
            if (i != null) {
                return i;
            }
            if (c.getOp() == IfOp.EQ && c.getB().isFalse()) {
                cond = new IfCondition(Mode.NOT, Collections.singletonList(new IfCondition(c.invert())));
            } else {
                c.normalize();
            }
        }
        ArrayList<IfCondition> args = null;
        for (int i = 0; i < cond.getArgs().size(); ++i) {
            IfCondition arg = cond.getArgs().get(i);
            IfCondition simpl = IfCondition.simplify(arg);
            if (simpl == arg) continue;
            if (args == null) {
                args = new ArrayList<IfCondition>(cond.getArgs());
            }
            args.set(i, simpl);
        }
        if (args != null) {
            cond = new IfCondition(cond.getMode(), args);
        }
        if (cond.getMode() == Mode.NOT && cond.first().getMode() == Mode.NOT) {
            cond = IfCondition.invert(cond.first());
        }
        if (cond.getMode() == Mode.TERNARY && cond.first().getMode() == Mode.NOT) {
            cond = IfCondition.invert(cond);
        }
        if ((cond.getMode() == Mode.OR || cond.getMode() == Mode.AND) && (count = cond.getArgs().size()) > 1) {
            int negCount = 0;
            for (IfCondition arg : cond.getArgs()) {
                if (arg.getMode() != Mode.NOT && (!arg.isCompare() || arg.getCompare().getOp() != IfOp.NE)) continue;
                ++negCount;
            }
            if (negCount > count / 2) {
                return IfCondition.not(IfCondition.invert(cond));
            }
        }
        return cond;
    }

    private static IfCondition simplifyCmpOp(Compare c) {
        if (!c.getA().isInsnWrap()) {
            return null;
        }
        if (!c.getB().isLiteral()) {
            return null;
        }
        long lit = ((LiteralArg)c.getB()).getLiteral();
        if (lit != 0L && lit != 1L) {
            return null;
        }
        InsnNode wrapInsn = ((InsnWrapArg)c.getA()).getWrapInsn();
        switch (wrapInsn.getType()) {
            case CMP_L: 
            case CMP_G: {
                if (lit != 0L) break;
                IfNode insn = c.getInsn();
                insn.changeCondition(insn.getOp(), wrapInsn.getArg(0), wrapInsn.getArg(1));
                break;
            }
            case ARITH: {
                ArithOp arithOp;
                if (c.getB().getType() != ArgType.BOOLEAN || (arithOp = ((ArithNode)wrapInsn).getOp()) != ArithOp.OR && arithOp != ArithOp.AND) break;
                IfOp ifOp = c.getInsn().getOp();
                boolean isTrue = ifOp == IfOp.NE && lit == 0L || ifOp == IfOp.EQ && lit == 1L;
                IfOp op = isTrue ? IfOp.NE : IfOp.EQ;
                Mode mode = isTrue && arithOp == ArithOp.OR || !isTrue && arithOp == ArithOp.AND ? Mode.OR : Mode.AND;
                IfNode if1 = new IfNode(op, -1, wrapInsn.getArg(0), LiteralArg.litFalse());
                IfNode if2 = new IfNode(op, -1, wrapInsn.getArg(1), LiteralArg.litFalse());
                return new IfCondition(mode, Arrays.asList(new IfCondition(new Compare(if1)), new IfCondition(new Compare(if2))));
            }
        }
        return null;
    }

    public List<RegisterArg> getRegisterArgs() {
        ArrayList<RegisterArg> list = new ArrayList<RegisterArg>();
        if (this.mode == Mode.COMPARE) {
            this.compare.getInsn().getRegisterArgs(list);
        } else {
            for (IfCondition arg : this.args) {
                list.addAll(arg.getRegisterArgs());
            }
        }
        return list;
    }

    public void visitInsns(Consumer<InsnNode> visitor) {
        if (this.mode == Mode.COMPARE) {
            this.compare.getInsn().visitInsns(visitor);
        } else {
            this.args.forEach(arg -> arg.visitInsns(visitor));
        }
    }

    public List<InsnNode> collectInsns() {
        ArrayList<InsnNode> list = new ArrayList<InsnNode>();
        this.visitInsns(list::add);
        return list;
    }

    public int getSourceLine() {
        for (InsnNode insn : this.collectInsns()) {
            int line = insn.getSourceLine();
            if (line == 0) continue;
            return line;
        }
        return 0;
    }

    @Nullable
    public InsnNode getFirstInsn() {
        if (this.mode == Mode.COMPARE) {
            return this.compare.getInsn();
        }
        return this.args.get(0).getFirstInsn();
    }

    public String toString() {
        switch (this.mode) {
            case COMPARE: {
                return this.compare.toString();
            }
            case TERNARY: {
                return this.first() + " ? " + this.second() + " : " + this.third();
            }
            case NOT: {
                return "!(" + this.first() + ')';
            }
            case AND: 
            case OR: {
                String op = this.mode == Mode.OR ? " || " : " && ";
                StringBuilder sb = new StringBuilder();
                sb.append('(');
                Iterator<IfCondition> it = this.args.iterator();
                while (it.hasNext()) {
                    IfCondition arg = it.next();
                    sb.append(arg);
                    if (!it.hasNext()) continue;
                    sb.append(op);
                }
                sb.append(')');
                return sb.toString();
            }
        }
        return "??";
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof IfCondition)) {
            return false;
        }
        IfCondition other = (IfCondition)obj;
        if (this.mode != other.mode) {
            return false;
        }
        return Objects.equals(this.args, other.args) && Objects.equals(this.compare, other.compare);
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.mode.hashCode();
        result = 31 * result + this.args.hashCode();
        result = 31 * result + (this.compare != null ? this.compare.hashCode() : 0);
        return result;
    }

    public static enum Mode {
        COMPARE,
        TERNARY,
        NOT,
        AND,
        OR;

    }
}

