/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.filter;

import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.apache.maven.plugins.assembly.filter.ContainerDescriptorHandler;
import org.apache.maven.plugins.assembly.utils.AssemblyFileUtils;
import org.codehaus.plexus.archiver.Archiver;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.UnArchiver;
import org.codehaus.plexus.components.io.fileselectors.FileInfo;

@Named(value="file-aggregator")
public class SimpleAggregatingDescriptorHandler
implements ContainerDescriptorHandler {
    private final String commentChars = "#";
    private final StringWriter aggregateWriter = new StringWriter();
    private final List<String> filenames = new ArrayList<String>();
    private String filePattern;
    private String outputPath;
    private boolean overrideFilterAction;

    public void finalizeArchiveCreation(Archiver archiver) {
        this.checkConfig();
        if (this.outputPath.endsWith("/")) {
            throw new ArchiverException("Cannot write aggregated properties to a directory. You must specify a file name in the outputPath configuration for this handler. (handler: " + this.getClass().getName());
        }
        if (this.outputPath.startsWith("/")) {
            this.outputPath = this.outputPath.substring(1);
        }
        File temp = this.writePropertiesFile();
        this.overrideFilterAction = true;
        archiver.addFile(temp, this.outputPath);
        this.overrideFilterAction = false;
    }

    private File writePropertiesFile() {
        File f;
        try {
            f = Files.createTempFile("maven-assembly-plugin", "tmp", new FileAttribute[0]).toFile();
            f.deleteOnExit();
            try (Writer writer = this.getWriter(f);){
                writer.write("# Aggregated on " + new Date() + " from: ");
                for (String filename : this.filenames) {
                    writer.write("\n# " + filename);
                }
                writer.write("\n\n");
                writer.write(this.aggregateWriter.toString());
            }
        }
        catch (IOException e) {
            throw new ArchiverException("Error adding aggregated properties to finalize archive creation. Reason: " + e.getMessage(), (Throwable)e);
        }
        return f;
    }

    private Writer getWriter(File f) throws IOException {
        OutputStreamWriter writer = AssemblyFileUtils.isPropertyFile(f) ? new OutputStreamWriter(Files.newOutputStream(f.toPath(), new OpenOption[0]), StandardCharsets.ISO_8859_1) : new OutputStreamWriter(Files.newOutputStream(f.toPath(), new OpenOption[0]));
        return writer;
    }

    public void finalizeArchiveExtraction(UnArchiver unarchiver) {
    }

    public List<String> getVirtualFiles() {
        this.checkConfig();
        return Collections.singletonList(this.outputPath);
    }

    public boolean isSelected(FileInfo fileInfo) throws IOException {
        this.checkConfig();
        if (this.overrideFilterAction) {
            return true;
        }
        String name = AssemblyFileUtils.normalizeFileInfo(fileInfo);
        if (fileInfo.isFile() && name.matches(this.filePattern)) {
            this.readProperties(fileInfo);
            this.filenames.add(name);
            return false;
        }
        return true;
    }

    private void checkConfig() {
        if (this.filePattern == null || this.outputPath == null) {
            throw new IllegalStateException("You must configure filePattern and outputPath in your containerDescriptorHandler declaration.");
        }
    }

    private void readProperties(FileInfo fileInfo) throws IOException {
        try (StringWriter writer = new StringWriter();
             InputStreamReader reader = AssemblyFileUtils.isPropertyFile(fileInfo.getName()) ? new InputStreamReader(fileInfo.getContents(), StandardCharsets.ISO_8859_1) : new InputStreamReader(fileInfo.getContents());){
            IOUtils.copy((Reader)reader, (Writer)writer);
            String content = writer.toString();
            this.aggregateWriter.write("\n");
            this.aggregateWriter.write(content);
        }
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public void setFilePattern(String filePattern) {
        this.filePattern = filePattern;
    }

    public String getOutputPath() {
        return this.outputPath;
    }

    public void setOutputPath(String outputPath) {
        this.outputPath = outputPath;
    }
}

