/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.sip.impl;

import io.pkts.buffer.Buffer;
import io.pkts.packet.sip.SipParseException;
import io.pkts.packet.sip.SipResponse;
import io.pkts.packet.sip.header.CSeqHeader;
import io.pkts.packet.sip.header.SipHeader;
import io.pkts.packet.sip.impl.ImmutableSipMessage;
import io.pkts.packet.sip.impl.SipResponseLine;
import java.util.List;
import java.util.Map;

public class ImmutableSipResponse
extends ImmutableSipMessage
implements SipResponse {
    protected ImmutableSipResponse(Buffer message, SipResponseLine initialLine, Map<String, List<SipHeader>> headers, SipHeader toHeader, SipHeader fromHeader, SipHeader cSeqHeader, SipHeader callIdHeader, SipHeader maxForwardsHeader, SipHeader viaHeader, SipHeader routeHeader, SipHeader recordRouteHeader, SipHeader contactHeader, Buffer body) {
        super(message, initialLine, headers, toHeader, fromHeader, cSeqHeader, callIdHeader, maxForwardsHeader, viaHeader, routeHeader, recordRouteHeader, contactHeader, body);
    }

    @Override
    public Buffer getMethod() throws SipParseException {
        CSeqHeader cseq = this.getCSeqHeader();
        if (cseq != null) {
            return cseq.getMethod();
        }
        return null;
    }

    @Override
    public SipResponse.Builder copy() {
        SipResponseLine responseLine = this.getInitialLineAsObject().toResponseLine();
        SipResponse.Builder builder = SipResponse.withStatusCode(responseLine.getStatusCode());
        builder.withReasonPhrase(responseLine.getReason());
        builder.withHeaders(this.getAllHeaders());
        builder.withBody(this.getContent());
        return builder;
    }

    @Override
    public int getStatus() {
        return this.getInitialLineAsObject().toResponseLine().getStatusCode();
    }

    @Override
    public Buffer getReasonPhrase() {
        return this.getInitialLineAsObject().toResponseLine().getReason();
    }

    @Override
    public final SipResponse clone() {
        return this;
    }
}

