/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smack.tcp.rce;

import java.net.InetAddress;
import org.jivesoftware.smack.datatypes.UInt16;
import org.jivesoftware.smack.tcp.rce.Rfc6120TcpRemoteConnectionEndpoint;
import org.jivesoftware.smack.util.Objects;
import org.jivesoftware.smack.util.rce.SingleAddressRemoteConnectionEndpoint;
import org.minidns.record.InternetAddressRR;

public final class IpTcpRemoteConnectionEndpoint<IARR extends InternetAddressRR<?>>
implements Rfc6120TcpRemoteConnectionEndpoint,
SingleAddressRemoteConnectionEndpoint {
    private final CharSequence host;
    private final UInt16 port;
    private final IARR internetAddressResourceRecord;

    public IpTcpRemoteConnectionEndpoint(CharSequence host, UInt16 port, IARR internetAddressResourceRecord) {
        this.host = (CharSequence)Objects.requireNonNull((Object)host);
        this.port = (UInt16)Objects.requireNonNull((Object)port);
        this.internetAddressResourceRecord = (InternetAddressRR)Objects.requireNonNull(internetAddressResourceRecord);
    }

    public static IpTcpRemoteConnectionEndpoint<InternetAddressRR<?>> from(CharSequence host, UInt16 port, InetAddress inetAddress) {
        InternetAddressRR internetAddressResourceRecord = InternetAddressRR.from((InetAddress)inetAddress);
        return new IpTcpRemoteConnectionEndpoint(host, port, internetAddressResourceRecord);
    }

    public CharSequence getHost() {
        return this.host;
    }

    public UInt16 getPort() {
        return this.port;
    }

    public InetAddress getInetAddress() {
        return this.internetAddressResourceRecord.getInetAddress();
    }

    public String getDescription() {
        return "RFC 6120 A/AAAA Endpoint + [" + this.host + ":" + this.port + "]";
    }
}

