/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.utils;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;

public class TimeUtils {
    private static final long msb0baseTime = 2085978496000L;
    private static final long msb1baseTime = -2208988800000L;
    private static final ThreadLocal<DecimalFormat> trailingMilliFormat = ThreadLocal.withInitial(() -> new DecimalFormat("000"));
    private static final ThreadLocal<DecimalFormat> nanosPerMilliFormat = ThreadLocal.withInitial(() -> {
        DecimalFormatSymbols dfs = new DecimalFormatSymbols();
        dfs.setDecimalSeparator('.');
        return new DecimalFormat(".######", dfs);
    });

    public static long toNtpTime(long t) {
        boolean useBase1 = t < 2085978496000L;
        long baseTime = useBase1 ? t - -2208988800000L : t - 2085978496000L;
        long seconds = baseTime / 1000L;
        long fraction = baseTime % 1000L * 0x100000000L / 1000L;
        if (useBase1) {
            seconds |= 0x80000000L;
        }
        long time = seconds << 32 | fraction;
        return time;
    }

    public static long getTime(long ntpTimeValue) {
        long seconds = ntpTimeValue >>> 32 & 0xFFFFFFFFL;
        long fraction = ntpTimeValue & 0xFFFFFFFFL;
        fraction = Math.round(1000.0 * (double)fraction / 4.294967296E9);
        long msb = seconds & 0x80000000L;
        if (msb == 0L) {
            return 2085978496000L + seconds * 1000L + fraction;
        }
        return -2208988800000L + seconds * 1000L + fraction;
    }

    public static long toNtpShortFormat(long ntpTime) {
        return (ntpTime & 0xFFFFFFFF0000L) >>> 16;
    }

    public static long ntpShortToMs(long ntpShortTime) {
        return ntpShortTime * 1000L >>> 16;
    }

    public static long constructNtp(long msw, long lsw) {
        return msw << 32 | lsw & 0xFFFFFFFFL;
    }

    public static long getMsw(long ntpTime) {
        return ntpTime >>> 32 & 0xFFFFFFFFL;
    }

    public static long getLsw(long ntpTime) {
        return ntpTime & 0xFFFFFFFFL;
    }

    public static String formatTimeAsFullMillis(long secs, int nanos) {
        assert (nanos >= 0 && nanos < 1000000000);
        StringBuilder builder = new StringBuilder();
        if (secs < 0L && nanos != 0) {
            secs = -secs - 1L;
            nanos = 1000000000 - nanos;
            builder.append('-');
        }
        int millis = nanos / 1000000;
        int nanosPerMilli = nanos % 1000000;
        if (secs != 0L) {
            builder.append(secs);
            builder.append(trailingMilliFormat.get().format(millis));
        } else {
            builder.append(millis);
        }
        if (nanosPerMilli != 0) {
            builder.append(nanosPerMilliFormat.get().format((double)nanosPerMilli / 1000000.0));
        }
        return builder.toString();
    }
}

