/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.jersey.test.spi;

import java.lang.reflect.Method;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.DynamicContainer;
import org.junit.jupiter.api.DynamicTest;
import org.junit.jupiter.api.Test;
import org.junit.platform.commons.util.ReflectionUtils;

public final class TestHelper {
    public static String zeroPortToAvailablePort(URI uri) {
        return uri.getPort() != 0 ? uri.toString() : uri.toString().replaceFirst(":0", ":<AVAILABLE-PORT>");
    }

    private TestHelper() {
    }

    public static DynamicContainer toTestContainer(Object test, String displayName) {
        Class<?> klass = test.getClass();
        List testMethods = ReflectionUtils.findMethods(klass, method -> method.isAnnotationPresent(Test.class) && !method.isAnnotationPresent(Disabled.class));
        List beforeEachMethods = ReflectionUtils.findMethods(klass, method -> method.isAnnotationPresent(BeforeEach.class));
        List afterEachMethods = ReflectionUtils.findMethods(klass, method -> method.isAnnotationPresent(AfterEach.class));
        ArrayList<DynamicTest> children = new ArrayList<DynamicTest>();
        for (Method method2 : testMethods) {
            children.add(DynamicTest.dynamicTest((String)method2.getName(), () -> {
                try {
                    for (Method beforeEachMethod : beforeEachMethods) {
                        beforeEachMethod.invoke(test, new Object[0]);
                    }
                    method2.invoke(test, new Object[0]);
                }
                finally {
                    for (Method afterEachMethod : afterEachMethods) {
                        afterEachMethod.invoke(test, new Object[0]);
                    }
                }
            }));
        }
        return DynamicContainer.dynamicContainer((String)displayName, children);
    }
}

