/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.spice.zapper.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.sonatype.spice.zapper.Path;
import org.sonatype.spice.zapper.codec.Codec;
import org.sonatype.spice.zapper.hash.Hash;
import org.sonatype.spice.zapper.internal.Check;
import org.sonatype.spice.zapper.internal.Payload;
import org.sonatype.spice.zapper.internal.TransferIdentifier;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPayload
implements Payload {
    private final TransferIdentifier transferIdentifier;
    private final Path path;
    private final Hash hash;
    private final List<Codec> codecs;

    protected AbstractPayload(TransferIdentifier transferIdentifier, Path path, Hash hash, List<Codec> codecs) {
        this.transferIdentifier = Check.notNull(transferIdentifier, TransferIdentifier.class);
        this.path = Check.notNull(path, Path.class);
        this.hash = Check.notNull(hash, Hash.class);
        ArrayList<Codec> cds = new ArrayList<Codec>();
        if (codecs != null) {
            cds.addAll(codecs);
        }
        this.codecs = Collections.unmodifiableList(cds);
    }

    @Override
    public TransferIdentifier getTransferIdentifier() {
        return this.transferIdentifier;
    }

    @Override
    public Path getPath() {
        return this.path;
    }

    @Override
    public Hash getHash() {
        return this.hash;
    }

    @Override
    public List<Codec> getCodecs() {
        return this.codecs;
    }
}

