/*
 * Decompiled with CFR 0.152.
 */
package io.pkts.packet.impl;

import io.pkts.buffer.Buffer;
import io.pkts.framer.RTPFramer;
import io.pkts.framer.SIPFramer;
import io.pkts.packet.IPPacket;
import io.pkts.packet.Packet;
import io.pkts.packet.TransportPacket;
import io.pkts.packet.impl.AbstractPacket;
import io.pkts.packet.impl.UnknownApplicationPacketImpl;
import io.pkts.packet.rtp.RtpPacket;
import io.pkts.protocol.Protocol;
import java.io.IOException;

public abstract class TransportPacketImpl
extends AbstractPacket
implements TransportPacket {
    private static final SIPFramer sipFramer = new SIPFramer();
    private static final RTPFramer rtpFramer = new RTPFramer();
    private final IPPacket parent;
    private final Buffer headers;

    protected TransportPacketImpl(IPPacket parent, Protocol protocol, Buffer headers, Buffer payload) {
        super(protocol, parent, payload);
        assert (parent != null);
        this.parent = parent;
        this.headers = headers;
    }

    @Override
    public boolean isUDP() {
        return false;
    }

    @Override
    public boolean isTCP() {
        return false;
    }

    @Override
    public boolean isSCTP() {
        return false;
    }

    @Override
    public final int getSourcePort() {
        return this.headers.getUnsignedShort(0);
    }

    @Override
    public final void setSourcePort(int port) {
        this.headers.setUnsignedShort(0, port);
    }

    @Override
    public final int getDestinationPort() {
        return this.headers.getUnsignedShort(2);
    }

    @Override
    public final void setDestinationPort(int port) {
        this.headers.setUnsignedShort(2, port);
    }

    @Override
    public void verify() {
    }

    @Override
    public final long getArrivalTime() {
        return this.parent.getArrivalTime();
    }

    @Override
    public abstract TransportPacket clone();

    @Override
    public Packet getNextPacket() throws IOException {
        RtpPacket rtp;
        Buffer payload = this.getPayload();
        if (payload == null || payload.isEmpty()) {
            return null;
        }
        if (sipFramer.accept(payload)) {
            return sipFramer.frame(this, payload);
        }
        if (rtpFramer.accept(payload) && (rtp = this.frameRtp(payload)) != null) {
            return rtp;
        }
        return new UnknownApplicationPacketImpl(this, payload);
    }

    private RtpPacket frameRtp(Buffer payload) throws IOException {
        try {
            return rtpFramer.frame(this, payload);
        }
        catch (IndexOutOfBoundsException e) {
            return null;
        }
    }

    @Override
    public IPPacket getParentPacket() {
        return (IPPacket)super.getParentPacket();
    }
}

