/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.xmpp.extensions.coin;

import java.io.IOException;
import org.jitsi.xmpp.extensions.DefaultPacketExtensionProvider;
import org.jitsi.xmpp.extensions.SafeParseIqProvider;
import org.jitsi.xmpp.extensions.coin.CallInfoPacketExtension;
import org.jitsi.xmpp.extensions.coin.CoinIQ;
import org.jitsi.xmpp.extensions.coin.ConferenceMediaPacketExtension;
import org.jitsi.xmpp.extensions.coin.ConferenceMediumProvider;
import org.jitsi.xmpp.extensions.coin.DescriptionProvider;
import org.jitsi.xmpp.extensions.coin.SIPDialogIDPacketExtension;
import org.jitsi.xmpp.extensions.coin.SidebarsByValPacketExtension;
import org.jitsi.xmpp.extensions.coin.StateProvider;
import org.jitsi.xmpp.extensions.coin.StateType;
import org.jitsi.xmpp.extensions.coin.URIPacketExtension;
import org.jitsi.xmpp.extensions.coin.URIsPacketExtension;
import org.jitsi.xmpp.extensions.coin.UserRolesPacketExtension;
import org.jitsi.xmpp.extensions.coin.UsersProvider;
import org.jivesoftware.smack.packet.ExtensionElement;
import org.jivesoftware.smack.parsing.SmackParsingException;
import org.jivesoftware.smack.provider.ProviderManager;
import org.jivesoftware.smack.xml.XmlPullParser;
import org.jivesoftware.smack.xml.XmlPullParserException;

public class CoinIQProvider
extends SafeParseIqProvider<CoinIQ> {
    private final DescriptionProvider descriptionProvider = new DescriptionProvider();
    private final UsersProvider usersProvider = new UsersProvider();
    private final StateProvider stateProvider = new StateProvider();
    private final DefaultPacketExtensionProvider<URIsPacketExtension> urisProvider = new DefaultPacketExtensionProvider<URIsPacketExtension>(URIsPacketExtension.class);
    private final DefaultPacketExtensionProvider<SidebarsByValPacketExtension> sidebarsByValProvider = new DefaultPacketExtensionProvider<SidebarsByValPacketExtension>(SidebarsByValPacketExtension.class);

    public CoinIQProvider() {
        ProviderManager.addExtensionProvider((String)"roles", (String)"urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<UserRolesPacketExtension>(UserRolesPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"uri", (String)"urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<URIPacketExtension>(URIPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"sip", (String)"urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<SIPDialogIDPacketExtension>(SIPDialogIDPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"medium", (String)"urn:ietf:params:xml:ns:conference-info", (Object)((Object)new ConferenceMediumProvider()));
        ProviderManager.addExtensionProvider((String)"available-media", (String)"urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<ConferenceMediaPacketExtension>(ConferenceMediaPacketExtension.class));
        ProviderManager.addExtensionProvider((String)"call-info", (String)"urn:ietf:params:xml:ns:conference-info", new DefaultPacketExtensionProvider<CallInfoPacketExtension>(CallInfoPacketExtension.class));
    }

    @Override
    protected CoinIQ doParse(XmlPullParser parser) throws XmlPullParserException, IOException, SmackParsingException {
        CoinIQ coinIQ = new CoinIQ();
        String entity = parser.getAttributeValue("", "entity");
        String version = parser.getAttributeValue("", "version");
        StateType state = StateType.full;
        String stateStr = parser.getAttributeValue("", "state");
        String sid = parser.getAttributeValue("", "sid");
        if (stateStr != null) {
            state = StateType.parseString(stateStr);
        }
        coinIQ.setEntity(entity);
        coinIQ.setVersion(Integer.parseInt(version));
        coinIQ.setState(state);
        coinIQ.setSID(sid);
        boolean done = false;
        while (!done) {
            XmlPullParser.Event eventType = parser.next();
            String elementName = parser.getName();
            if (eventType == XmlPullParser.Event.START_ELEMENT) {
                switch (elementName) {
                    case "conference-description": {
                        coinIQ.addExtension((ExtensionElement)this.descriptionProvider.parse(parser));
                        break;
                    }
                    case "users": {
                        coinIQ.addExtension((ExtensionElement)this.usersProvider.parse(parser));
                        break;
                    }
                    case "conference-state": {
                        coinIQ.addExtension((ExtensionElement)this.stateProvider.parse(parser));
                        break;
                    }
                    case "uris": {
                        coinIQ.addExtension((ExtensionElement)this.urisProvider.parse(parser));
                        break;
                    }
                    case "sidebars-by-val": {
                        coinIQ.addExtension((ExtensionElement)this.sidebarsByValProvider.parse(parser));
                    }
                }
            }
            if (eventType != XmlPullParser.Event.END_ELEMENT || !parser.getName().equals("conference-info")) continue;
            done = true;
        }
        return coinIQ;
    }
}

