/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.utils;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.maven.model.Extension;
import org.apache.maven.model.InputLocation;

public class ExtensionBuilder {
    private Optional<String> groupId = Optional.empty();
    private Optional<String> artifactId = Optional.empty();
    private Optional<String> version = Optional.empty();
    private Map<Object, InputLocation> locations = new HashMap<Object, InputLocation>();

    private ExtensionBuilder() {
    }

    public ExtensionBuilder withGroupId(String groupId) {
        this.groupId = Optional.ofNullable(groupId);
        return this;
    }

    public ExtensionBuilder withArtifactId(String artifactId) {
        this.artifactId = Optional.ofNullable(artifactId);
        return this;
    }

    public ExtensionBuilder withVersion(String version) {
        this.version = Optional.ofNullable(version);
        return this;
    }

    public ExtensionBuilder withLocation(Object key, InputLocation location) {
        this.locations.put(key, location);
        return this;
    }

    public static ExtensionBuilder newBuilder() {
        return new ExtensionBuilder();
    }

    public Extension build() {
        Extension inst = new Extension();
        this.groupId.ifPresent(arg_0 -> ((Extension)inst).setGroupId(arg_0));
        this.artifactId.ifPresent(arg_0 -> ((Extension)inst).setArtifactId(arg_0));
        this.version.ifPresent(arg_0 -> ((Extension)inst).setVersion(arg_0));
        this.locations.forEach((arg_0, arg_1) -> ((Extension)inst).setLocation(arg_0, arg_1));
        return inst;
    }
}

