/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions.filtering;

import java.util.function.Predicate;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.codehaus.mojo.versions.utils.DefaultArtifactVersionCache;

public class WildcardMatcher
implements Predicate<String> {
    public static final String WILDCARD = "*";
    private final String pattern;

    protected WildcardMatcher(String pattern) {
        this.pattern = pattern;
    }

    public static WildcardMatcher parse(String pattern) {
        return new WildcardMatcher(pattern);
    }

    @Override
    public boolean test(String token) {
        boolean matches;
        if (token == null) {
            return WILDCARD.equals(this.pattern);
        }
        if (WILDCARD.equals(this.pattern) || this.pattern.isEmpty()) {
            matches = true;
        } else if (this.pattern.startsWith(WILDCARD) && this.pattern.endsWith(WILDCARD)) {
            String contains = this.pattern.substring(1, this.pattern.length() - 1);
            matches = token.contains(contains);
        } else if (this.pattern.startsWith(WILDCARD)) {
            matches = token.endsWith(this.pattern.substring(1));
        } else if (this.pattern.endsWith(WILDCARD)) {
            String prefix = this.pattern.substring(0, this.pattern.length() - 1);
            matches = token.startsWith(prefix);
        } else {
            matches = this.pattern.startsWith("[") || this.pattern.startsWith("(") ? this.isVersionIncludedInRange(token, this.pattern) : token.equals(this.pattern);
        }
        return matches;
    }

    private boolean isVersionIncludedInRange(String version, String range) {
        try {
            return VersionRange.createFromVersionSpec((String)range).containsVersion((ArtifactVersion)DefaultArtifactVersionCache.of(version));
        }
        catch (InvalidVersionSpecificationException e) {
            return false;
        }
    }

    public String getPattern() {
        return this.pattern;
    }

    public String toString() {
        return String.format("%s{%s}", this.getClass().getSimpleName(), this.pattern);
    }
}

