/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.wagon.Wagon;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.VersionRetrievalException;
import org.codehaus.mojo.versions.api.recording.ChangeRecorder;
import org.codehaus.mojo.versions.api.recording.DependencyChangeRecord;
import org.codehaus.mojo.versions.ordering.InvalidSegmentException;
import org.codehaus.mojo.versions.recording.DefaultDependencyChangeRecord;
import org.codehaus.mojo.versions.rewriting.MutableXMLStreamReader;
import org.codehaus.mojo.versions.utils.DefaultArtifactVersionCache;
import org.codehaus.mojo.versions.utils.DependencyBuilder;
import org.codehaus.mojo.versions.utils.SegmentUtils;
import org.eclipse.aether.RepositorySystem;

@Mojo(name="update-parent", threadSafe=true)
public class UpdateParentMojo
extends AbstractVersionsUpdaterMojo {
    @Parameter(property="parentVersion")
    protected String parentVersion = null;
    @Parameter(property="forceUpdate", defaultValue="false")
    protected boolean forceUpdate = false;
    @Parameter(property="skipResolution", defaultValue="false")
    protected boolean skipResolution = false;
    @Parameter(property="allowDowngrade", defaultValue="false")
    protected boolean allowDowngrade;
    @Parameter(property="allowMajorUpdates", defaultValue="true")
    protected boolean allowMajorUpdates = true;
    @Parameter(property="allowMinorUpdates", defaultValue="true")
    protected boolean allowMinorUpdates = true;
    @Parameter(property="allowIncrementalUpdates", defaultValue="true")
    protected boolean allowIncrementalUpdates = true;

    @Inject
    public UpdateParentMojo(ArtifactHandlerManager artifactHandlerManager, RepositorySystem repositorySystem, Map<String, Wagon> wagonMap, Map<String, ChangeRecorder> changeRecorders) {
        super(artifactHandlerManager, repositorySystem, wagonMap, changeRecorders);
    }

    @Override
    protected void update(MutableXMLStreamReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException, VersionRetrievalException {
        if (this.getProject().getParent() == null) {
            this.getLog().info((CharSequence)"Project does not have a parent");
            return;
        }
        if (this.reactorProjects.contains(this.getProject().getParent())) {
            this.getLog().info((CharSequence)"Project's parent is part of the reactor");
            return;
        }
        if (this.skipResolution && StringUtils.isBlank((CharSequence)this.parentVersion)) {
            throw new MojoExecutionException("skipResolution is only valid if parentVersion is set");
        }
        try {
            ArtifactVersion artifactVersion;
            Object object = artifactVersion = this.skipResolution ? DefaultArtifactVersionCache.of((String)this.parentVersion) : this.resolveTargetVersion();
            if (artifactVersion != null) {
                this.getLog().info((CharSequence)("Updating parent from " + this.getProject().getParent().getVersion() + " to " + artifactVersion));
                if (PomHelper.setProjectParentVersion((MutableXMLStreamReader)pom, (String)artifactVersion.toString())) {
                    if (this.getLog().isDebugEnabled()) {
                        this.getLog().debug((CharSequence)("Made an update from " + this.getProject().getParent().getVersion() + " to " + artifactVersion));
                    }
                    this.getChangeRecorder().recordChange(DefaultDependencyChangeRecord.builder().withKind(DependencyChangeRecord.ChangeKind.PARENT).withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withOldVersion(this.getProject().getParent().getVersion()).withNewVersion(artifactVersion.toString()).build());
                }
            }
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Invalid version range specification: " + this.parentVersion, (Exception)((Object)e));
        }
        catch (InvalidSegmentException e) {
            throw new MojoExecutionException("Invalid segment specification for version " + this.parentVersion, (Exception)((Object)e));
        }
    }

    protected ArtifactVersion resolveTargetVersion() throws MojoExecutionException, VersionRetrievalException, InvalidVersionSpecificationException, InvalidSegmentException {
        Artifact artifact = this.getHelper().createDependencyArtifact(DependencyBuilder.newBuilder().withGroupId(this.getProject().getParent().getGroupId()).withArtifactId(this.getProject().getParent().getArtifactId()).withVersion(this.getProject().getParent().getVersion()).withType("pom").build());
        VersionRange targetVersionRange = VersionRange.createFromVersionSpec((String)this.parentVersion);
        if (targetVersionRange != null && targetVersionRange.getRecommendedVersion() != null) {
            targetVersionRange = targetVersionRange.restrict(VersionRange.createFromVersionSpec((String)("[" + targetVersionRange.getRecommendedVersion() + ",)")));
        }
        ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, false);
        Optional unchangedSegment = SegmentUtils.determineUnchangedSegment((boolean)this.allowMajorUpdates, (boolean)this.allowMinorUpdates, (boolean)this.allowIncrementalUpdates, (Log)this.getLog());
        VersionRange finalTargetVersionRange = targetVersionRange;
        return StreamSupport.stream(UpdateParentMojo.reverse(versions.getNewerVersions(this.getProject().getParent().getVersion(), unchangedSegment, this.allowSnapshots, this.allowDowngrade)).spliterator(), false).filter(v -> finalTargetVersionRange == null || ArtifactVersions.isVersionInRange((ArtifactVersion)v, (VersionRange)finalTargetVersionRange)).findFirst().map(candidate -> {
            if (this.shouldApplyUpdate(artifact, this.getProject().getParent().getVersion(), (ArtifactVersion)candidate, this.forceUpdate)) {
                return candidate;
            }
            this.getLog().debug((CharSequence)"Update not applied. Exiting.");
            return null;
        }).orElseGet(() -> {
            if (versions.isEmpty(this.allowSnapshots)) {
                this.getLog().info((CharSequence)"No versions found");
            } else {
                this.getLog().info((CharSequence)"The parent project is the latest version");
            }
            return null;
        });
    }

    private static <T> Iterable<T> reverse(T[] array) {
        return Arrays.stream(array).sorted(Collections.reverseOrder()).collect(Collectors.toList());
    }
}

