/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.site.descriptor;

import java.io.File;
import java.util.List;
import java.util.Locale;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.doxia.site.decoration.DecorationModel;
import org.apache.maven.doxia.site.decoration.inheritance.DecorationModelInheritanceAssembler;
import org.apache.maven.doxia.tools.SiteToolException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.site.AbstractSiteMojo;

public abstract class AbstractSiteDescriptorMojo
extends AbstractSiteMojo {
    @Component
    private DecorationModelInheritanceAssembler assembler;
    @Parameter(defaultValue="${project.remoteArtifactRepositories}", readonly=true)
    protected List<ArtifactRepository> repositories;
    @Parameter(defaultValue="${basedir}/src/site")
    protected File siteDirectory;
    @Parameter(property="relativizeDecorationLinks", defaultValue="true")
    private boolean relativizeDecorationLinks;

    protected DecorationModel prepareDecorationModel(Locale locale) throws MojoExecutionException {
        DecorationModel decorationModel;
        try {
            decorationModel = this.siteTool.getDecorationModel(this.siteDirectory, locale, this.project, this.reactorProjects, this.localRepository, this.repositories);
        }
        catch (SiteToolException e) {
            throw new MojoExecutionException("SiteToolException: " + e.getMessage(), (Exception)((Object)e));
        }
        if (this.relativizeDecorationLinks) {
            String url = this.project.getUrl();
            if (url == null) {
                this.getLog().warn((CharSequence)"No project URL defined - decoration links will not be relativized!");
            } else {
                List<Locale> localesList = this.getLocales();
                Locale defaultLocale = localesList.get(0);
                String localeUrl = locale.equals(defaultLocale) ? url : this.append(url, locale.getLanguage());
                this.getLog().info((CharSequence)("Relativizing decoration links with respect to localized project URL: " + localeUrl));
                this.assembler.resolvePaths(decorationModel, localeUrl);
            }
        }
        return decorationModel;
    }

    private String append(String url, String path) {
        return url.endsWith("/") ? url + path : url + '/' + path;
    }
}

