/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.sisu.siesta.client.filters;

import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.Filterable;
import java.util.Arrays;
import java.util.Map;

public class RequestFilters
extends ClientFilter {
    public static final String KEY = RequestFilters.class.getName();

    public ClientResponse handle(ClientRequest request) throws ClientHandlerException {
        Object requestFiltersProperty = request.getProperties().get(KEY);
        if (RequestFilters.isClientFilterArray(requestFiltersProperty)) {
            Filterable filterable = new Filterable(this.getNext()){};
            for (ClientFilter clientFilter : Lists.reverse(Arrays.asList((ClientFilter[])requestFiltersProperty))) {
                filterable.addFilter(clientFilter);
            }
            return filterable.getHeadHandler().handle(request);
        }
        return this.getNext().handle(request);
    }

    public static void addRequestFilters(Map<String, Object> properties, ClientFilter ... filters) {
        Object requestFiltersProperty = properties.get(KEY);
        properties.put(KEY, RequestFilters.isClientFilterArray(requestFiltersProperty) ? (ClientFilter[])ObjectArrays.concat((Object[])((ClientFilter[])requestFiltersProperty), (Object[])filters, ClientFilter.class) : filters);
    }

    private static boolean isClientFilterArray(Object requestFiltersProperty) {
        if (requestFiltersProperty == null) {
            return false;
        }
        try {
            ClientFilter[] casted = (ClientFilter[])requestFiltersProperty;
            return true;
        }
        catch (ClassCastException ignore) {
            return false;
        }
    }
}

