/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules.dependency;

import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.enforcer.rules.dependency.BannedDependenciesBase;
import org.apache.maven.enforcer.rules.dependency.ResolverUtil;
import org.apache.maven.enforcer.rules.utils.ArtifactUtils;
import org.apache.maven.execution.MavenSession;

@Named(value="bannedDependencies")
public final class BannedDependencies
extends BannedDependenciesBase {
    @Inject
    BannedDependencies(MavenSession session, ResolverUtil resolverUtil) {
        super(session, resolverUtil);
    }

    @Override
    protected boolean validate(Artifact artifact) {
        return !ArtifactUtils.matchDependencyArtifact(artifact, this.getExcludes()) || ArtifactUtils.matchDependencyArtifact(artifact, this.getIncludes());
    }

    @Override
    protected String getErrorMessage() {
        return "banned via the exclude/include list";
    }

    public String toString() {
        return String.format("BannedDependencies[message=%s, excludes=%s, includes=%s, searchTransitive=%b]", this.getMessage(), this.getExcludes(), this.getIncludes(), this.isSearchTransitive());
    }
}

