/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.enforcer.rules;

import org.apache.maven.enforcer.rule.api.AbstractEnforcerRule;
import org.apache.maven.model.InputLocation;
import org.apache.maven.project.MavenProject;

public abstract class AbstractStandardEnforcerRule
extends AbstractEnforcerRule {
    private String message;

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    private static String getProjectId(MavenProject project) {
        StringBuilder buffer = new StringBuilder(128);
        buffer.append(project.getGroupId() != null && project.getGroupId().length() > 0 ? project.getGroupId() : "[unknown-group-id]");
        buffer.append(':');
        buffer.append(project.getArtifactId() != null && project.getArtifactId().length() > 0 ? project.getArtifactId() : "[unknown-artifact-id]");
        buffer.append(':');
        buffer.append(project.getVersion() != null && project.getVersion().length() > 0 ? project.getVersion() : "[unknown-version]");
        return buffer.toString();
    }

    protected static String formatLocation(MavenProject project, InputLocation location) {
        StringBuilder buffer = new StringBuilder();
        if (!location.getSource().getModelId().equals(AbstractStandardEnforcerRule.getProjectId(project))) {
            buffer.append(location.getSource().getModelId());
            if (location.getSource().getLocation().length() > 0) {
                if (buffer.length() > 0) {
                    buffer.append(", ");
                }
                buffer.append(location.getSource().getLocation());
            }
        }
        if (location.getLineNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("line ").append(location.getLineNumber());
        }
        if (location.getColumnNumber() > 0) {
            if (buffer.length() > 0) {
                buffer.append(", ");
            }
            buffer.append("column ").append(location.getColumnNumber());
        }
        return buffer.toString();
    }
}

