/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.dependency.fromConfiguration;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.dependency.fromConfiguration.AbstractFromConfigurationMojo;
import org.apache.maven.plugins.dependency.fromConfiguration.ArtifactItem;
import org.apache.maven.plugins.dependency.fromConfiguration.ProcessArtifactItemsRequest;
import org.apache.maven.plugins.dependency.utils.CopyUtil;
import org.apache.maven.plugins.dependency.utils.filters.ArtifactItemFilter;
import org.apache.maven.plugins.dependency.utils.filters.DestFileFilter;

@Mojo(name="copy", defaultPhase=LifecyclePhase.PROCESS_SOURCES, requiresProject=false, threadSafe=true)
public class CopyMojo
extends AbstractFromConfigurationMojo {
    @Component
    private CopyUtil copyUtil;
    @Parameter(property="mdep.stripVersion", defaultValue="false")
    private boolean stripVersion = false;
    @Parameter(property="mdep.stripClassifier", defaultValue="false")
    private boolean stripClassifier = false;
    @Parameter(property="mdep.prependGroupId", defaultValue="false")
    private boolean prependGroupId = false;
    @Parameter(property="mdep.useBaseVersion", defaultValue="false")
    private boolean useBaseVersion = false;
    @Parameter(property="artifact")
    private String artifact;

    @Override
    protected void doExecute() throws MojoExecutionException, MojoFailureException {
        this.verifyRequirements();
        List<ArtifactItem> theArtifactItems = this.getProcessedArtifactItems(new ProcessArtifactItemsRequest(this.stripVersion, this.prependGroupId, this.useBaseVersion, this.stripClassifier));
        for (ArtifactItem artifactItem : theArtifactItems) {
            if (artifactItem.isNeedsProcessing()) {
                this.copyArtifact(artifactItem);
                continue;
            }
            this.getLog().info((CharSequence)(artifactItem + " already exists in " + artifactItem.getOutputDirectory()));
        }
    }

    protected void copyArtifact(ArtifactItem artifactItem) throws MojoExecutionException {
        File destFile = new File(artifactItem.getOutputDirectory(), artifactItem.getDestFileName());
        try {
            this.copyUtil.copyArtifactFile(artifactItem.getArtifact(), destFile);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Failed to copy artifact '" + artifactItem.getArtifact() + "' (" + artifactItem.getArtifact().getFile() + ") to " + destFile, (Exception)e);
        }
    }

    @Override
    protected ArtifactItemFilter getMarkedArtifactFilter(ArtifactItem item) {
        return new DestFileFilter(this.isOverWriteReleases(), this.isOverWriteSnapshots(), this.isOverWriteIfNewer(), false, false, false, false, this.stripVersion, this.prependGroupId, this.useBaseVersion, item.getOutputDirectory());
    }

    public boolean isStripVersion() {
        return this.stripVersion;
    }

    public void setStripVersion(boolean stripVersion) {
        this.stripVersion = stripVersion;
    }

    public boolean isStripClassifier() {
        return this.stripClassifier;
    }

    public void setStripClassifier(boolean stripClassifier) {
        this.stripClassifier = stripClassifier;
    }

    public void setUseBaseVersion(boolean useBaseVersion) {
        this.useBaseVersion = useBaseVersion;
    }
}

