/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.components.io.resources;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.output.DeferredFileOutputStream;
import org.codehaus.plexus.components.io.attributes.AttributeUtils;
import org.codehaus.plexus.components.io.attributes.FileAttributes;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.functions.ContentSupplier;
import org.codehaus.plexus.components.io.functions.FileSupplier;
import org.codehaus.plexus.components.io.functions.InputStreamTransformer;
import org.codehaus.plexus.components.io.functions.ResourceAttributeSupplier;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResourceCollection;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;

public class PlexusIoFileResource
extends AbstractPlexusIoResource
implements ResourceAttributeSupplier,
FileSupplier {
    @Nonnull
    private final File file;
    @Nonnull
    private final PlexusIoResourceAttributes attributes;
    @Nonnull
    private final FileAttributes fileAttributes;
    private final ContentSupplier contentSupplier;
    private final DeferredFileOutputStream dfos;
    private static final InputStreamTransformer identityTransformer = AbstractPlexusIoResourceCollection.identityTransformer;

    protected PlexusIoFileResource(@Nonnull File file, @Nonnull String name, @Nonnull PlexusIoResourceAttributes attrs) throws IOException {
        this(file, name, attrs, null, null);
    }

    PlexusIoFileResource(@Nonnull File file, @Nonnull String name, @Nonnull PlexusIoResourceAttributes attrs, ContentSupplier contentSupplier, InputStreamTransformer streamTransformer) throws IOException {
        this(file, name, attrs, new FileAttributes(file, true), contentSupplier, streamTransformer);
    }

    PlexusIoFileResource(@Nonnull File file, @Nonnull String name, @Nonnull PlexusIoResourceAttributes attrs, @Nonnull FileAttributes fileAttributes, ContentSupplier contentSupplier, InputStreamTransformer streamTransformer) throws IOException {
        super(name, fileAttributes.getLastModifiedTime().toMillis(), fileAttributes.getSize(), fileAttributes.isRegularFile(), fileAttributes.isDirectory(), fileAttributes.isRegularFile() || fileAttributes.isDirectory() || fileAttributes.isSymbolicLink() || fileAttributes.isOther());
        this.file = file;
        this.attributes = Objects.requireNonNull(attrs, "attributes is null for file " + file.getName());
        this.fileAttributes = Objects.requireNonNull(fileAttributes, "fileAttributes is null for file " + file.getName());
        this.contentSupplier = contentSupplier != null ? contentSupplier : PlexusIoFileResource.getRootContentSupplier(file);
        boolean hasTransformer = streamTransformer != null && streamTransformer != identityTransformer;
        InputStreamTransformer transToUse = streamTransformer != null ? streamTransformer : identityTransformer;
        this.dfos = hasTransformer && file.isFile() ? PlexusIoFileResource.asDeferredStream(this.contentSupplier, transToUse, this) : null;
    }

    private static DeferredFileOutputStream asDeferredStream(@Nonnull ContentSupplier supplier, @Nonnull InputStreamTransformer transToUse, PlexusIoResource resource) throws IOException {
        DeferredFileOutputStream dfos = DeferredFileOutputStream.builder().setThreshold(5000000).setPrefix("p-archiver").get();
        InputStream inputStream = supplier.getContents();
        InputStream transformed = transToUse.transform(resource, inputStream);
        IOUtils.copy((InputStream)transformed, (OutputStream)dfos);
        IOUtils.closeQuietly((InputStream)inputStream);
        IOUtils.closeQuietly((InputStream)transformed);
        return dfos;
    }

    private static ContentSupplier getRootContentSupplier(File file) {
        return () -> Files.newInputStream(file.toPath(), new OpenOption[0]);
    }

    public static String getName(File file) {
        return file.getPath().replace('\\', '/');
    }

    @Override
    @Nonnull
    public File getFile() {
        return this.file;
    }

    @Override
    @Nonnull
    public InputStream getContents() throws IOException {
        if (this.dfos == null) {
            return this.contentSupplier.getContents();
        }
        if (this.dfos.isInMemory()) {
            return new ByteArrayInputStream(this.dfos.getData());
        }
        return new FileInputStream(this.dfos.getFile()){

            @Override
            public void close() throws IOException {
                super.close();
                PlexusIoFileResource.this.dfos.getFile().delete();
            }
        };
    }

    @Override
    @Nonnull
    public URL getURL() throws IOException {
        return this.getFile().toURI().toURL();
    }

    @Override
    public long getSize() {
        if (this.dfos == null) {
            return this.fileAttributes.getSize();
        }
        if (this.dfos.isInMemory()) {
            return this.dfos.getByteCount();
        }
        return this.dfos.getFile().length();
    }

    @Override
    public boolean isDirectory() {
        return this.fileAttributes.isDirectory();
    }

    @Override
    public boolean isExisting() {
        if (this.attributes instanceof FileAttributes) {
            return true;
        }
        return this.getFile().exists();
    }

    @Override
    public boolean isFile() {
        return this.fileAttributes.isRegularFile();
    }

    @Override
    @Nonnull
    public PlexusIoResourceAttributes getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public FileAttributes getFileAttributes() {
        return this.fileAttributes;
    }

    @Override
    public long getLastModified() {
        FileTime lastModified = this.fileAttributes.getLastModifiedTime();
        if (lastModified != null) {
            return lastModified.toMillis();
        }
        return AttributeUtils.getLastModified(this.getFile());
    }

    @Override
    public boolean isSymbolicLink() {
        return this.getAttributes().isSymbolicLink();
    }

    protected DeferredFileOutputStream getDfos() {
        return this.dfos;
    }
}

