/*
 * @(#)typedefs_md.h	1.33 98/07/01
 *
 * Copyright 1995-1998 by Sun Microsystems, Inc.,
 * 901 San Antonio Road, Palo Alto, California, 94303, U.S.A.
 * All rights reserved.
 * 
 * This software is the confidential and proprietary information
 * of Sun Microsystems, Inc. ("Confidential Information").  You
 * shall not disclose such Confidential Information and shall use
 * it only in accordance with the terms of the license agreement
 * you entered into with Sun.
 */

/*
 * NetBSD-dependent types for Green threads
 */

#ifndef _NETBSD_TYPES_MD_H_
#define _NETBSD_TYPES_MD_H_

#include <sys/types.h>
/* #include <sys/inttypes.h> */
#include <sys/stat.h>
#include "bool.h"

#if __NetBSD__
#include <sys/inttypes.h>
#if 0
typedef unsigned int uint32_t;
typedef unsigned long long uint64_t;
#endif
#endif

/* a Solarisism for src/share/sun/debug/agent.c
   Int Long Pointer magic _ILP32 (defined if they are they all 32-bits?)
*/
#define _ILP32

#if __NetBSD__
typedef unsigned int uint_t;
typedef int int_t;
#endif

/* use these macros when the compiler supports the long long type */

#define ll_high(a)	((long)((a)>>32))
#define ll_low(a)	((long)(a))
#define int2ll(a)	((int64_t)(a))
#define ll2int(a)	((int)(a))
#define ll_add(a, b)	((a) + (b))
#define ll_and(a, b)	((a) & (b))
#define ll_div(a, b)	((a) / (b))
#define ll_mul(a, b)	((a) * (b))
#define ll_neg(a)	(-(a))
#define ll_not(a)	(~(a))
#define ll_or(a, b)	((a) | (b))
#define ll_shl(a, n)	((a) << (n))
#define ll_shr(a, n)	((a) >> (n))
#define ll_sub(a, b)	((a) - (b))
#define ll_ushr(a, n)	((unsigned long long)(a) >> (n))
#define ll_xor(a, b)	((a) ^ (b))
#define uint2ll(a)	((uint64_t)(unsigned long)(a))
#define ll_rem(a,b)	((a) % (b))

#define INT_OP(x,op,y)  ((x) op (y))
#define NAN_CHECK(l,r,x) x
#define IS_NAN(x) isnan(x)


/* On Intel these conversions have to be method calls and not typecasts.
   See the win32 typedefs_md.h file */
#if defined(i386) || defined (__i386)

extern int32_t float2l(float f);
extern int32_t double2l(double d);
extern int64_t float2ll(float f);
extern int64_t double2ll(double d);

#else /* not i386 */

#define float2l(f)	(f)
#define double2l(f)	(f)
#define float2ll(f)	((int64_t) (f))
#define double2ll(f)	((int64_t) (f))

#endif /* i386 */


#define ll2float(a)	((float) (a))
#define ll2double(a)	((double) (a))

/* comparison operators */
#define ll_ltz(ll)	((ll)<0)
#define ll_gez(ll)	((ll)>=0)
#define ll_eqz(a)	((a) == 0)
#define ll_eq(a, b)	((a) == (b))
#define ll_ne(a,b)	((a) != (b))
#define ll_ge(a,b)	((a) >= (b))
#define ll_le(a,b)	((a) <= (b))
#define ll_lt(a,b)	((a) < (b))
#define ll_gt(a,b)	((a) > (b))

#define ll_zero_const	((int64_t) 0)
#define ll_one_const	((int64_t) 1)

extern void ll2str(int64_t a, char *s, char *limit);

#ifdef ppc
#define HAVE_ALIGNED_DOUBLES
#define HAVE_ALIGNED_LONGLONGS
#endif

#endif /* !_NETBSD_TYPES_MD_H_ */
