/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.swing;

import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.event.ExpansionListener;
import com.sun.prodreg.swing.JTreeComponentDescriptionWrapper;
import com.sun.prodreg.swing.JTreeComponentSelectableViewAdapter;
import com.sun.prodreg.swing.ProdRegTreeWillExpandListener;
import com.sun.prodreg.swing.ProdregTreeCellRenderer;
import com.sun.prodreg.view.ComponentSelectableView;
import com.sun.prodreg.view.ComponentSelectableViewListener;
import com.sun.prodreg.view.TreeView;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.Toolkit;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class SwingTreeView
extends JPanel
implements TreeView {
    private ComponentSelectableView csv = null;
    private ProdRegTreeWillExpandListener el = null;
    private JTreeComponentDescriptionWrapper topNode = null;
    private DefaultTreeModel treeModel = null;
    private JTree tree = null;

    public SwingTreeView(ProdRegTreeNode data) {
        Toolkit tk = Toolkit.getDefaultToolkit();
        Image damageImage = tk.getImage(this.getClass().getResource("/images/damage.gif"));
        this.topNode = new JTreeComponentDescriptionWrapper(data, null);
        this.treeModel = new DefaultTreeModel(this.topNode);
        this.tree = new JTree(this.treeModel);
        this.tree.setRootVisible(true);
        this.tree.setShowsRootHandles(true);
        this.tree.setCellRenderer(new ProdregTreeCellRenderer(damageImage));
        this.el = new ProdRegTreeWillExpandListener();
        this.tree.addTreeWillExpandListener(this.el);
        JScrollPane sp = new JScrollPane(this.tree);
        JTreeComponentSelectableViewAdapter ja = new JTreeComponentSelectableViewAdapter(this.tree);
        this.tree.addTreeSelectionListener(ja);
        this.setLayout(new BorderLayout());
        this.add((Component)sp, "Center");
        this.csv = ja;
    }

    public void addComponentSelectableViewListener(ComponentSelectableViewListener c) {
        if (this.csv != null) {
            this.csv.addComponentSelectableViewListener(c);
        }
    }

    public void addExpansionListener(ExpansionListener l) {
        if (this.el != null) {
            this.el.addExpansionListener(l);
        }
    }

    public void refresh(Vector idsToExpand, boolean expand) {
        Vector nodesToExpand = new Vector();
        this.topNode.refresh(nodesToExpand, idsToExpand);
        this.treeModel.reload();
        int i = 0;
        while (i < nodesToExpand.size()) {
            TreeNode node = (TreeNode)nodesToExpand.elementAt(i);
            TreePath newPath = new TreePath(this.treeModel.getPathToRoot(node));
            if (expand) {
                this.tree.expandPath(newPath);
            }
            this.tree.setSelectionPath(newPath);
            ++i;
        }
    }

    public void removeComponentSelectableViewListener(ComponentSelectableViewListener c) {
        if (this.csv != null) {
            this.csv.removeComponentSelectableViewListener(c);
        }
    }

    public void removeExpansionListener(ExpansionListener l) {
        if (this.el != null) {
            this.el.removeExpansionListener(l);
        }
    }

    public void setEnabled(boolean enabled) {
        this.tree.setEnabled(enabled);
    }
}

