/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.core;

import com.sun.prodreg.awt.AWTUIProvider;
import com.sun.prodreg.core.ComponentDescription;
import com.sun.prodreg.core.ComponentDescriptionLookup;
import com.sun.prodreg.core.ComponentReference;
import com.sun.prodreg.core.InstallManager;
import com.sun.prodreg.core.InteractiveUninstaller;
import com.sun.prodreg.core.ProdRegTreeNode;
import com.sun.prodreg.core.ProdRegViewManager;
import com.sun.prodreg.core.Registry;
import com.sun.prodreg.core.RegistryNotAvailableException;
import com.sun.prodreg.core.UIProvider;
import com.sun.prodreg.core.WebstartRegistry;
import com.sun.prodreg.event.ExpansionEvent;
import com.sun.prodreg.event.ExpansionListener;
import com.sun.prodreg.event.NoExpansionException;
import com.sun.prodreg.event.ProgressListener;
import com.sun.prodreg.event.SubprocessDoneEvent;
import com.sun.prodreg.event.SubprocessDoneListener;
import com.sun.prodreg.util.Localizer;
import com.sun.prodreg.util.Log;
import com.sun.prodreg.util.TypedSystemSubprocess;
import com.sun.prodreg.util.Utils;
import com.sun.prodreg.view.ComponentSelectableView;
import com.sun.prodreg.view.ComponentSelectableViewListener;
import com.sun.prodreg.view.ComponentView;
import com.sun.prodreg.view.TreeView;
import java.util.Date;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class ProdReg
implements InstallManager,
ComponentSelectableViewListener,
SubprocessDoneListener,
ProgressListener,
ExpansionListener,
Runnable {
    public static final String ROOT_PROPERTY = "prodreg.pkgroot";
    public static final String SYSTEM_NODE_ID = "a01ee8dd-1dd1-11b2-a3f2-0800209a5b6b";
    public static final String UNCLASSIFIED_NODE_ID = "8f64eabf-1dd2-11b2-a3f1-0800209a5b6b";
    private static final String SYSTEM_TMP_NODE_ID = "ProdRegSystemSoftware";
    private static final String UNCLASSIFIED_TMP_NODE_ID = "ProdRegUnclassifiedSoftware";
    public static final int MAX_NAME_LENGTH = 50;
    public static boolean debug = false;
    private int activeUninstallerCount = 0;
    private Registry reg = null;
    private ProdRegViewManager vm = null;
    private UIProvider provider = null;
    private Log log = null;
    private ComponentDescription desc = null;
    private boolean sysLoaded = false;
    private TreeView tv = null;
    private ComponentDescription rootDesc = null;
    private ComponentDescription systemDesc = null;
    private ComponentDescription unclassifiedDesc = null;

    public ProdReg(UIProvider p) {
        this.provider = p;
        new Thread(this).start();
    }

    static /* synthetic */ boolean access$6(ProdReg $0) {
        return $0.sysLoaded;
    }

    private void cleanup() {
        try {
            this.log.close();
            this.reg.cleanup();
        }
        catch (Exception ex) {
            this.logError("Error cleaning up: " + ex);
        }
    }

    public void close(int status) {
        this.cleanup();
        System.exit(status);
    }

    public void componentSelected(ComponentSelectableView src, ComponentDescription desc) {
        if (!this.sysLoaded && (desc.getID().equals(SYSTEM_TMP_NODE_ID) || desc.getID().equals(UNCLASSIFIED_TMP_NODE_ID))) {
            this.expandSystemFolders(desc, false);
        }
        this.showComponent(desc);
    }

    private boolean currentComponentUninstallable() {
        if (this.desc == null) {
            return false;
        }
        boolean hasPkgs = Utils.listPackages(this.desc) != null;
        boolean hasDependency = this.desc.getDependentComponents() != null && this.desc.getDependentComponents().size() > 0;
        boolean hasUninstaller = this.desc.getUninstaller() != null;
        String noUninstall = this.desc.getData("noUninstall");
        if (noUninstall != null && noUninstall.equalsIgnoreCase("true")) {
            return false;
        }
        if (this.desc == this.rootDesc || this.desc == this.systemDesc) {
            return false;
        }
        return hasPkgs || !hasDependency || hasUninstaller;
    }

    private synchronized void decrementActiveUninstallerCount() {
        if (this.activeUninstallerCount > 0) {
            --this.activeUninstallerCount;
        }
        int options = this.vm.getOptions();
        if (this.activeUninstallerCount <= 0 && this.currentComponentUninstallable()) {
            options |= 1;
        }
        this.vm.setOptions(options);
    }

    private void expandSystemFolders(ComponentDescription desc, boolean setExpanded) {
        if (desc.getID().equals(SYSTEM_TMP_NODE_ID) || desc.getID().equals(UNCLASSIFIED_TMP_NODE_ID)) {
            this.tv.setEnabled(false);
            Vector<String> v = new Vector<String>();
            v.addElement(desc.getID());
            SystemLoader sl = new SystemLoader(this, v, setExpanded);
            Thread resolver = new Thread((Runnable)sl, "SystemResolver");
            resolver.start();
        }
    }

    public void expanding(ExpansionEvent evt) throws NoExpansionException {
        ComponentDescription src = (ComponentDescription)evt.getSource();
        boolean expanding = evt.isExpanding();
        if (expanding && !this.sysLoaded && (src.getID().equals(SYSTEM_TMP_NODE_ID) || src.getID().equals(UNCLASSIFIED_TMP_NODE_ID))) {
            this.expandSystemFolders(src, true);
            throw new NoExpansionException();
        }
    }

    private ProdRegTreeNode getRegistryData() throws RegistryNotAvailableException {
        if (debug) {
            System.out.println("Java diving into JNI at " + new Date().getTime());
        }
        long start = new Date().getTime();
        Vector wsreg = this.reg.getAllComponents(1, this);
        long end = new Date().getTime();
        double wssecs = (double)(end - start) / 1000.0;
        if (debug) {
            System.out.println("Java emerging from JNI.  Total time: " + wssecs + " seconds");
        }
        Vector<ComponentDescription> top = new Vector<ComponentDescription>();
        ComponentDescriptionLookup.removeAll();
        int sz = wsreg.size();
        int i = 0;
        while (i < sz) {
            ComponentDescription desc = (ComponentDescription)wsreg.elementAt(i);
            ComponentDescriptionLookup.add(desc.getID(), desc);
            ++i;
        }
        int i2 = 0;
        while (i2 < sz) {
            ComponentDescription desc = (ComponentDescription)wsreg.elementAt(i2);
            if (desc.getParent() == null) {
                top.addElement(desc);
            } else if (desc.isDamaged()) {
                ComponentReference tmpDesc = desc.getParent();
                while (tmpDesc != null) {
                    ComponentDescription pd = ComponentDescriptionLookup.get(tmpDesc.getID());
                    if (pd != null) {
                        pd.setData("isDamaged", "true");
                        tmpDesc = pd.getParent();
                        continue;
                    }
                    tmpDesc = null;
                }
            }
            ++i2;
        }
        this.systemDesc = new ComponentDescription(SYSTEM_TMP_NODE_ID);
        String sysLabel = Localizer.resolve("<L ProdRegResources.SystemSoftware>");
        this.systemDesc.setDisplayName(sysLabel);
        ComponentDescription systemDescChild = new ComponentDescription("ProdRegSystemSoftware child");
        systemDescChild.setDisplayName("Never Seen");
        this.unclassifiedDesc = new ComponentDescription(UNCLASSIFIED_TMP_NODE_ID);
        String unclassLabel = Localizer.resolve("<L ProdRegResources.UnclassifiedSoftware>");
        this.unclassifiedDesc.setDisplayName(unclassLabel);
        ComponentDescription unclassChild = new ComponentDescription("ProdRegUnclassifiedSoftware child");
        unclassChild.setDisplayName("Never Seen");
        ComponentDescriptionLookup.add(this.systemDesc.getID(), this.systemDesc);
        ComponentDescriptionLookup.add(this.unclassifiedDesc.getID(), this.unclassifiedDesc);
        ComponentDescriptionLookup.add(systemDescChild.getID(), systemDescChild);
        ComponentDescriptionLookup.add(unclassChild.getID(), unclassChild);
        this.rootDesc = new ComponentDescription("root");
        ProdRegTreeNode rootNode = new ProdRegTreeNode(this.rootDesc);
        String rootLabel = Localizer.resolve("<L ProdRegResources.SystemRegistry>");
        rootNode.getComponentDescription().setDisplayName(rootLabel);
        this.systemDesc.addChild(systemDescChild);
        this.unclassifiedDesc.addChild(unclassChild);
        rootNode.getComponentDescription().addChild(this.systemDesc);
        rootNode.getComponentDescription().addChild(this.unclassifiedDesc);
        int i3 = 0;
        while (i3 < top.size()) {
            ComponentDescription childDesc = (ComponentDescription)top.elementAt(i3);
            rootNode.getComponentDescription().addChild(childDesc);
            ++i3;
        }
        this.setProgress(100);
        this.vm.hideProgress();
        return rootNode;
    }

    private static UIProvider getSwingProvider() {
        try {
            Class<?> c = Class.forName("com.sun.prodreg.swing.SwingUIProvider");
            Class.forName("javax.swing.JPanel");
            return (UIProvider)c.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    private TreeView getTreeView() {
        TreeView returnView = null;
        try {
            ProdRegTreeNode data = this.getRegistryData();
            returnView = this.provider.getTreeView(data);
            returnView.addComponentSelectableViewListener(this);
            returnView.addExpansionListener(this);
        }
        catch (RegistryNotAvailableException ex) {
            if (debug) {
                System.out.println("ProdReg: reg not available: " + ex.toString());
            }
            String prompt = Localizer.resolve("<L ProdRegResources.NotAvail>");
            this.logError(prompt);
        }
        return returnView;
    }

    private synchronized void incrementActiveUninstallerCount() {
        ++this.activeUninstallerCount;
        int options = this.vm.getOptions();
        this.vm.setOptions(options &= 0xFFFFFFFE);
    }

    private void initializeReg() {
        this.reg = new WebstartRegistry();
        this.log = new Log();
        if (debug) {
            System.out.println("Java initializing libprodreg...");
        }
        try {
            String altRoot = System.getProperty(ROOT_PROPERTY);
            if (altRoot != null && altRoot.trim().equals("")) {
                Properties p = System.getProperties();
                ((Hashtable)p).remove(ROOT_PROPERTY);
                System.setProperties(p);
                altRoot = null;
            }
            if (altRoot != null && debug) {
                System.out.println("ProdReg using root: " + altRoot);
            }
            this.reg.initialize(this.vm, this.provider, this, altRoot);
            if (debug) {
                System.out.println("Java done initializing libprodreg...");
            }
        }
        catch (Exception ex) {
            if (debug) {
                System.out.println("Error during registry initializatin:" + ex.toString());
                ex.printStackTrace();
            }
            String prompt = Localizer.resolve("<L ProdRegResources.InitError>");
            this.logError(prompt);
        }
    }

    private void initializeUI() {
        String prompt = Localizer.resolve("<L ProdRegResources.PleaseWait>");
        ComponentView initialMoreView = this.provider.getMoreView();
        ComponentView initialSummaryView = this.provider.getSummaryView();
        this.vm = new ProdRegViewManager(this.provider, this, initialSummaryView, initialMoreView, null);
        int options = this.vm.getOptions();
        options &= 0xFFFFFFFD;
        this.vm.setOptions(options &= 0xFFFFFFFE);
        this.vm.showProgress();
        this.vm.setProgress(0);
        this.vm.setProgressMessage(prompt);
    }

    private void installDone(int returnValue, String message) {
        if (returnValue == 0) {
            String title = Localizer.resolve("<L ProdRegResources.InstallSuccessTitle>");
            String ok = Localizer.resolve("<L ProdRegResources.OK>");
            String err = Localizer.resolve("<L ProdRegResources.InstallSuccess>");
            this.vm.query(title, err, message, new String[]{ok});
            this.resetRegistry();
        } else {
            String title = Localizer.resolve("<L ProdRegResources.InstallFailedTitle>");
            String ok = Localizer.resolve("<L ProdRegResources.OK>");
            String cancel = Localizer.resolve("<L ProdRegResources.Cancel>");
            String err = Localizer.resolve("<L ProdRegResources.InstallFailed>");
            int n = this.vm.query(title, err, message, new String[]{ok});
        }
    }

    private void logError(String msg) {
        this.log.logMessage(msg, 2);
        this.vm.logError(msg);
    }

    public static void main(String[] args) {
        UIProvider p = null;
        boolean swingSpecified = false;
        boolean awtSpecified = false;
        String vers = System.getProperty("java.version");
        if (vers.compareTo("1.1.3") < 0) {
            System.err.println(Localizer.resolve("Sorry, Java 1.1.3 or greater is required"));
            System.exit(1);
        }
        Localizer.addResourcePackage("com.sun.prodreg");
        int index = 0;
        while (index < args.length) {
            if (args[index].equals("-swing")) {
                if (awtSpecified) {
                    ProdReg.usage();
                }
                swingSpecified = true;
                awtSpecified = false;
            } else if (args[index].equals("-awt")) {
                if (swingSpecified) {
                    ProdReg.usage();
                }
                swingSpecified = false;
                awtSpecified = true;
            } else if (args[index].equals("-debug")) {
                debug = true;
                TypedSystemSubprocess.debug = true;
            } else if (args[index].equals("-R")) {
                if (index + 1 < args.length) {
                    System.setProperty(ROOT_PROPERTY, args[index + 1]);
                    ++index;
                } else {
                    ProdReg.usage();
                }
            } else {
                System.err.println(String.valueOf(Localizer.resolve("<L ProdRegResources.UnrecognizedArg>:")) + args[index]);
                ProdReg.usage();
            }
            ++index;
        }
        try {
            if (!awtSpecified) {
                p = ProdReg.getSwingProvider();
                if (p == null) {
                    if (swingSpecified) {
                        String warn = Localizer.resolve("<L ProdRegResources.WarnNoSwing>");
                        System.err.println(warn);
                    }
                    p = new AWTUIProvider();
                }
            } else {
                p = new AWTUIProvider();
            }
        }
        catch (InternalError internalError) {
            System.err.println(Localizer.resolve("<L ProdRegResources.NoDisplay>"));
            System.exit(1);
        }
        new ProdReg(p);
    }

    public void newInstall(String workingDir, String installFile) {
        TypedSystemSubprocess installer = new TypedSystemSubprocess(workingDir, installFile);
        installer.addSubprocessDoneListener(this, "NewInstall");
        new Thread((Runnable)installer, "new installer").start();
    }

    public void newUninstall(boolean interactive) {
        boolean hasUninstaller;
        if (this.desc == null) {
            return;
        }
        boolean hasPkgs = Utils.listPackages(this.desc) != null;
        boolean hasDependency = this.desc.getDependentComponents() != null && this.desc.getDependentComponents().size() > 0;
        boolean bl = hasUninstaller = this.desc.getUninstaller() != null;
        if (!interactive && hasDependency) {
            String depString = "";
            Vector deps = this.desc.getDependentComponents();
            int i = 0;
            while (i < deps.size()) {
                ComponentReference kidRef = (ComponentReference)deps.elementAt(i);
                ComponentDescription kidDesc = ComponentDescriptionLookup.get(kidRef.getID());
                depString = String.valueOf(depString) + "\"" + kidDesc.getDisplayName() + "\", ";
                ++i;
            }
            depString = depString.substring(0, depString.length() - 2);
            Object[] args = new String[]{"<bold>\"" + Utils.getDisplayName(this.desc) + "</bold>\"", depString};
            String title = Localizer.resolve("<L ProdRegResources.Warning>");
            String ok = Localizer.resolve("<L ProdRegResources.OK>");
            String cancel = Localizer.resolve("<L ProdRegResources.Cancel>");
            String err = Localizer.resolve("<L ProdRegResources.UninstallDependency>", args);
            int res = this.vm.query(title, err, null, new String[]{cancel, ok});
            if (res == 0) {
                return;
            }
        }
        if (interactive) {
            InteractiveUninstaller iu = new InteractiveUninstaller(this.desc, this.vm, this.reg);
            iu.addSubprocessDoneListener(this);
            this.incrementActiveUninstallerCount();
            new Thread(iu).start();
            return;
        }
        String cmdLine = this.desc.getUninstaller();
        if (cmdLine == null || cmdLine.trim().equals("")) {
            Object[] args = new String[]{"\"" + Utils.getDisplayName(this.desc) + "\""};
            String title = Localizer.resolve("<L ProdRegResources.UninstallFailedTitle>");
            String ok = Localizer.resolve("<L ProdRegResources.OK>");
            String cancel = Localizer.resolve("<L ProdRegResources.Cancel>");
            String err = Localizer.resolve("<L ProdRegResources.NoUninstaller>", args);
            int res = this.vm.query(title, err, null, new String[]{cancel, ok});
            if (res == 1) {
                this.newUninstall(true);
            }
            return;
        }
        String cmd = "bin/rootrun " + TypedSystemSubprocess.escape(' ', this.desc.getUninstaller());
        String prompt = Localizer.resolve("<L ProdRegResources.EnterRootPassword>");
        cmd = String.valueOf(cmd) + " " + TypedSystemSubprocess.escape(' ', prompt);
        String home = System.getProperty("prodreg.home");
        if (debug) {
            System.out.println("ProdReg: running -->" + cmd + "<--");
        }
        TypedSystemSubprocess uninstaller = new TypedSystemSubprocess(home, cmd, 2);
        uninstaller.addSubprocessDoneListener(this, this.desc);
        this.incrementActiveUninstallerCount();
        new Thread((Runnable)uninstaller, "NewUnInstall for file " + this.desc.getUninstaller()).start();
    }

    private void resetRegistry() {
        String prompt = Localizer.resolve("<L ProdRegResources.PleaseWait>");
        int options = this.vm.getOptions();
        options &= 0xFFFFFFFD;
        this.vm.setOptions(options &= 0xFFFFFFFE);
        TreeView oldTreeView = (TreeView)this.vm.getTreeView();
        if (oldTreeView != null) {
            oldTreeView.removeComponentSelectableViewListener(this);
            oldTreeView.removeExpansionListener(this);
        }
        this.vm.setTreeView(null);
        this.showComponent(null);
        this.sysLoaded = false;
        this.tv = null;
        this.tv = this.getTreeView();
        this.vm.setTreeView(this.tv);
        options = this.vm.getOptions();
        options |= 2;
        if (this.currentComponentUninstallable()) {
            options |= 1;
        }
        this.vm.setOptions(options);
    }

    public void run() {
        try {
            this.initializeUI();
            this.initializeReg();
            this.showUI();
        }
        catch (InternalError internalError) {
            System.err.println(Localizer.resolve("<L ProdRegResources.NoDisplay>"));
            this.close(1);
        }
    }

    public void setProgress(int progress) {
        this.vm.setProgress(progress);
    }

    public synchronized void showComponent(ComponentDescription desc) {
        this.desc = desc;
        int options = this.vm.getOptions();
        if (this.activeUninstallerCount <= 0) {
            options |= 1;
        }
        if (!this.currentComponentUninstallable()) {
            options &= 0xFFFFFFFE;
        }
        this.vm.setOptions(options);
        this.vm.showComponent(desc);
    }

    private void showUI() {
        this.tv = this.getTreeView();
        this.vm.setTreeView(this.tv);
        int options = this.vm.getOptions();
        options |= 2;
        if (this.currentComponentUninstallable()) {
            options |= 1;
        }
        this.vm.setOptions(options);
    }

    public void subprocessDone(SubprocessDoneEvent evt) {
        if (evt.getSource() instanceof InteractiveUninstaller) {
            if (evt.getReturnValue() == 0) {
                this.resetRegistry();
            }
            this.decrementActiveUninstallerCount();
        } else {
            Object appData = evt.getData();
            if (appData != null && appData instanceof ComponentDescription) {
                ComponentDescription desc = (ComponentDescription)appData;
                this.uninstallDone(desc, evt.getReturnValue(), evt.getMessage());
            } else if (appData != null && appData instanceof String) {
                String result = (String)appData;
                if (result.equals("NewInstall")) {
                    this.installDone(evt.getReturnValue(), evt.getMessage());
                }
            } else {
                this.logError("Internal Error: unknown process completed");
            }
        }
    }

    private void uninstallDone(ComponentDescription desc, int returnValue, String message) {
        if (returnValue != 0) {
            int res;
            boolean hasPkgs = Utils.listPackages(desc) != null;
            boolean hasDependency = desc.getDependentComponents() != null && desc.getDependentComponents().size() > 0;
            boolean hasUninstaller = desc.getUninstaller() != null;
            Object[] arg = new String[]{"\"<italics>" + Utils.getDisplayName(desc) + "\"" + "</italics>", "<bold> " + returnValue + " </bold>"};
            String title = Localizer.resolve("<L ProdRegResources.UninstallFailedTitle>");
            String ok = Localizer.resolve("<L ProdRegResources.OK>");
            String cancel = Localizer.resolve("<L ProdRegResources.Cancel>");
            if (hasDependency && !hasPkgs) {
                String err = Localizer.resolve("<L ProdRegResources.UninstallFailedNoInt>", arg);
                res = this.vm.query(title, err, message, new String[]{ok});
            } else {
                String err = Localizer.resolve("<L ProdRegResources.UninstallFailed>", arg);
                res = this.vm.query(title, err, message, new String[]{cancel, ok});
            }
            if (res == 1) {
                this.newUninstall(true);
            }
        } else {
            Object[] arg = new String[]{"\"<italics>" + Utils.getDisplayName(desc) + "\"" + "</italics>", "<bold> " + returnValue + " </bold>"};
            String title = Localizer.resolve("<L ProdRegResources.UninstallSuccessTitle>");
            String ok = Localizer.resolve("<L ProdRegResources.OK>");
            String err = Localizer.resolve("<L ProdRegResources.UninstallSuccess>", arg);
            int res = this.vm.query(title, err, message, new String[]{ok});
            this.resetRegistry();
        }
        this.decrementActiveUninstallerCount();
    }

    private static void usage() {
        System.err.print(Localizer.resolve("<L ProdRegResources.Usage>:"));
        System.err.println("prodreg [-awt] [-swing] [-R <root>]");
        System.exit(1);
    }

    class SystemLoader
    implements Runnable {
        private ProgressListener pl = null;
        private boolean failed = false;
        private Vector idsToExpand = null;
        private boolean expand = false;

        public SystemLoader(ProgressListener pl, Vector idsToExpand, boolean expand) {
            this.pl = pl;
            this.idsToExpand = idsToExpand;
            this.expand = expand;
        }

        public boolean hasFailed() {
            return this.failed;
        }

        private void resolveSystemComponents() throws RegistryNotAvailableException {
            String prompt = Localizer.resolve("<L ProdRegResources.SystemPleaseWait>");
            ProdReg.this.vm.showProgress();
            ProdReg.this.vm.setProgress(0);
            ProdReg.this.vm.setProgressMessage(prompt);
            Vector sysreg = ProdReg.this.reg.getAllComponents(0, this.pl);
            ProdReg.this.vm.hideProgress();
            Vector<ComponentDescription> top = new Vector<ComponentDescription>();
            int sz = sysreg.size();
            int i = 0;
            while (i < sz) {
                ComponentDescription desc = (ComponentDescription)sysreg.elementAt(i);
                ComponentDescriptionLookup.add(desc.getID(), desc);
                if (desc.getParent() == null) {
                    top.addElement(desc);
                }
                ++i;
            }
            Vector<String> realIDs = new Vector<String>();
            boolean hasUnclassified = false;
            int i2 = 0;
            while (i2 < top.size()) {
                ComponentDescription desc = (ComponentDescription)top.elementAt(i2);
                ProdReg.this.rootDesc.addChild(desc);
                if (desc.getID().equals(ProdReg.SYSTEM_NODE_ID)) {
                    if (this.idsToExpand.contains(ProdReg.SYSTEM_TMP_NODE_ID)) {
                        realIDs.addElement(desc.getID());
                    }
                } else if (desc.getID().equals(ProdReg.UNCLASSIFIED_NODE_ID)) {
                    hasUnclassified = true;
                    if (this.idsToExpand.contains(ProdReg.UNCLASSIFIED_TMP_NODE_ID)) {
                        realIDs.addElement(desc.getID());
                    }
                }
                ++i2;
            }
            ProdReg.this.rootDesc.removeChild(ProdReg.this.systemDesc);
            if (hasUnclassified) {
                ProdReg.this.rootDesc.removeChild(ProdReg.this.unclassifiedDesc);
            } else {
                String noUnclassified = Localizer.resolve("<L ProdRegResources.NoUnclassifiedSoftware>");
                ProdReg.this.unclassifiedDesc.setDisplayName(Utils.getLocaleName(), noUnclassified);
                ProdReg.this.unclassifiedDesc.setData("isSelectable", "false");
            }
            ProdReg.this.tv.refresh(realIDs, this.expand);
            ProdReg.this.sysLoaded = true;
            ProdReg.this.tv.setEnabled(true);
        }

        public void run() {
            this.failed = false;
            try {
                this.resolveSystemComponents();
            }
            catch (RegistryNotAvailableException registryNotAvailableException) {
                this.failed = true;
            }
        }
    }
}

