/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prodreg.awt;

import com.sun.prodreg.awt.InsetsPanel;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ImagePanel
extends InsetsPanel {
    public static final int LEFT = 1;
    public static final int CENTER = 2;
    public static final int RIGHT = 3;
    public static final int TOP = 1;
    public static final int BOTTOM = 3;
    protected Image image = null;
    protected int hAlign = 2;
    protected int vAlign = 2;
    protected boolean loaded = false;

    public ImagePanel() {
    }

    public ImagePanel(int hAlign, int vAlign) {
        this.hAlign = hAlign;
        this.vAlign = vAlign;
    }

    public ImagePanel(Insets insets) {
        super(insets);
    }

    public ImagePanel(LayoutManager layout) {
        super(layout);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getPreferredSize() {
        Dimension preferredSize = new Dimension(0, 0);
        if (this.image != null) {
            preferredSize.width = this.image.getWidth(this);
            preferredSize.height = this.image.getHeight(this);
        }
        return preferredSize;
    }

    public synchronized boolean imageUpdate(Image image, int infoFlags, int x, int y, int width, int height) {
        if ((infoFlags & 0x20) != 0) {
            this.loaded = true;
            this.repaint();
            return false;
        }
        return true;
    }

    public void paint(Graphics g) {
        super.paint(g);
        if (this.loaded) {
            int xOrigin = 0;
            int yOrigin = 0;
            int imageWidth = this.image.getWidth(this);
            int imageHeight = this.image.getHeight(this);
            Dimension size = this.getSize();
            g.setClip(0, 0, size.width, size.height);
            switch (this.hAlign) {
                case 1: {
                    xOrigin = this.insets.left;
                    break;
                }
                case 2: {
                    xOrigin = (size.width - (this.insets.left + this.insets.right) - imageWidth) / 2 + this.insets.left;
                    break;
                }
                case 3: {
                    xOrigin = size.width - imageWidth - this.insets.right;
                    break;
                }
            }
            switch (this.vAlign) {
                case 1: {
                    yOrigin = this.insets.top;
                    break;
                }
                case 2: {
                    yOrigin = (size.height - (this.insets.top + this.insets.bottom) - imageHeight) / 2 + this.insets.top;
                    break;
                }
                case 3: {
                    yOrigin = size.height - imageHeight - this.insets.bottom;
                    break;
                }
            }
            g.drawImage(this.image, xOrigin, yOrigin, this);
        }
    }

    public void setAlignment(int hAlign, int vAlign) {
        this.hAlign = hAlign;
        this.vAlign = vAlign;
    }

    public void setImage(Image image) {
        this.loaded = false;
        this.image = image;
        this.prepareImage(image, this);
    }
}

